/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure.spi.internal;

import io.opentelemetry.api.internal.ConfigUtil;
import io.opentelemetry.api.internal.StringUtils;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class DefaultConfigProperties
implements ConfigProperties {
    private final Map<String, String> config;

    public static DefaultConfigProperties create(Map<String, String> defaultProperties) {
        return new DefaultConfigProperties(System.getProperties(), System.getenv(), defaultProperties);
    }

    public static DefaultConfigProperties createFromMap(Map<String, String> properties) {
        return new DefaultConfigProperties(properties, Collections.emptyMap(), Collections.emptyMap());
    }

    private DefaultConfigProperties(Map<?, ?> systemProperties, Map<String, String> environmentVariables, Map<String, String> defaultProperties) {
        HashMap<String, String> config = new HashMap<String, String>();
        defaultProperties.forEach((name, value) -> config.put(ConfigUtil.normalizePropertyKey(name), (String)value));
        environmentVariables.forEach((name, value) -> config.put(ConfigUtil.normalizeEnvironmentVariableKey(name), (String)value));
        systemProperties.forEach((key, value) -> config.put(ConfigUtil.normalizePropertyKey(key.toString()), value.toString()));
        this.config = config;
    }

    private DefaultConfigProperties(DefaultConfigProperties previousProperties, Map<String, String> overrides) {
        HashMap<String, String> config = new HashMap<String, String>(previousProperties.config);
        overrides.forEach((name, value) -> config.put(ConfigUtil.normalizePropertyKey(name), (String)value));
        this.config = config;
    }

    @Override
    @Nullable
    public String getString(String name) {
        return this.config.get(ConfigUtil.normalizePropertyKey(name));
    }

    @Override
    @Nullable
    public Boolean getBoolean(String name) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name));
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    @Override
    @Nullable
    public Integer getInt(String name) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name));
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw DefaultConfigProperties.newInvalidPropertyException(name, value, "integer");
        }
    }

    @Override
    @Nullable
    public Long getLong(String name) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name));
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException ex) {
            throw DefaultConfigProperties.newInvalidPropertyException(name, value, "long");
        }
    }

    @Override
    @Nullable
    public Double getDouble(String name) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name));
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            throw DefaultConfigProperties.newInvalidPropertyException(name, value, "double");
        }
    }

    @Override
    @Nullable
    public Duration getDuration(String name) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name));
        if (value == null || value.isEmpty()) {
            return null;
        }
        String unitString = DefaultConfigProperties.getUnitString(value);
        String numberString = value.substring(0, value.length() - unitString.length());
        try {
            long rawNumber = Long.parseLong(numberString.trim());
            TimeUnit unit = DefaultConfigProperties.getDurationUnit(unitString.trim());
            return Duration.ofMillis(TimeUnit.MILLISECONDS.convert(rawNumber, unit));
        }
        catch (NumberFormatException ex) {
            throw new ConfigurationException("Invalid duration property " + name + "=" + value + ". Expected number, found: " + numberString, ex);
        }
        catch (ConfigurationException ex) {
            throw new ConfigurationException("Invalid duration property " + name + "=" + value + ". " + ex.getMessage());
        }
    }

    @Override
    public List<String> getList(String name) {
        String value = this.config.get(ConfigUtil.normalizePropertyKey(name));
        if (value == null) {
            return Collections.emptyList();
        }
        return DefaultConfigProperties.filterBlanksAndNulls(value.split(","));
    }

    public static Set<String> getSet(ConfigProperties config, String name) {
        List<String> list = config.getList(ConfigUtil.normalizePropertyKey(name));
        HashSet<String> set = new HashSet<String>(list);
        if (set.size() != list.size()) {
            String duplicates = list.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(",", "[", "]"));
            throw new ConfigurationException(name + " contains duplicates: " + duplicates);
        }
        return set;
    }

    @Override
    public Map<String, String> getMap(String name) {
        return this.getList(ConfigUtil.normalizePropertyKey(name)).stream().map(entry -> {
            String[] split = entry.split("=", 2);
            if (split.length != 2 || StringUtils.isNullOrEmpty(split[0])) {
                throw new ConfigurationException("Invalid map property: " + name + "=" + this.config.get(name));
            }
            return DefaultConfigProperties.filterBlanksAndNulls(split);
        }).filter(splitKeyValuePairs -> splitKeyValuePairs.size() == 2).map(splitKeyValuePairs -> new AbstractMap.SimpleImmutableEntry<String, String>((String)splitKeyValuePairs.get(0), (String)splitKeyValuePairs.get(1))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (first, next) -> next, LinkedHashMap::new));
    }

    public DefaultConfigProperties withOverrides(Map<String, String> overrides) {
        return new DefaultConfigProperties(this, overrides);
    }

    private static ConfigurationException newInvalidPropertyException(String name, String value, String type) {
        throw new ConfigurationException("Invalid value for property " + name + "=" + value + ". Must be a " + type + ".");
    }

    private static List<String> filterBlanksAndNulls(String[] values) {
        return Arrays.stream(values).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static TimeUnit getDurationUnit(String unitString) {
        switch (unitString) {
            case "": 
            case "ms": {
                return TimeUnit.MILLISECONDS;
            }
            case "s": {
                return TimeUnit.SECONDS;
            }
            case "m": {
                return TimeUnit.MINUTES;
            }
            case "h": {
                return TimeUnit.HOURS;
            }
            case "d": {
                return TimeUnit.DAYS;
            }
        }
        throw new ConfigurationException("Invalid duration string, found: " + unitString);
    }

    private static String getUnitString(String rawValue) {
        char c;
        int lastDigitIndex;
        for (lastDigitIndex = rawValue.length() - 1; lastDigitIndex >= 0 && !Character.isDigit(c = rawValue.charAt(lastDigitIndex)); --lastDigitIndex) {
        }
        return rawValue.substring(lastDigitIndex + 1);
    }
}

