/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.tokentype;

import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentInternal;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20TokenTypeHandlerFactory {
    static final String CLASS = OAuth20TokenTypeHandlerFactory.class.getName();
    static final Logger _log = Logger.getLogger(CLASS);
    static Map<String, OAuth20TokenTypeHandler> _handlerMap = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized OAuth20TokenTypeHandler getHandler(OAuth20ComponentInternal component) throws OAuthConfigurationException {
        String methodName = "getHandler";
        _log.entering(CLASS, methodName);
        OAuth20TokenTypeHandler result = null;
        try {
            String componentId;
            boolean inCache;
            if (_handlerMap == null) {
                _handlerMap = new HashMap<String, OAuth20TokenTypeHandler>();
            }
            boolean bl = inCache = (result = _handlerMap.get(componentId = component.getParentComponentInstance().getInstanceId())) != null;
            if (!inCache) {
                OAuth20ConfigProvider config = component.get20Configuration();
                result = config.getTokenTypeHandler();
                _handlerMap.put(componentId, result);
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return result;
    }
}

