/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.responsetype.impl;

import com.google.gson.JsonArray;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20AccessDeniedException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandler;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20ResponseTypeHandlerTokenImpl
implements OAuth20ResponseTypeHandler {
    static final String CLASS = OAuth20ResponseTypeHandlerTokenImpl.class.getName();
    private static Logger _log = Logger.getLogger(CLASS);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateRequestResponseType(AttributeList attributeList, JsonArray redirectUris, boolean allowRegexpRedirects) throws OAuthException {
        String methodName = "validateRequestResponseType";
        _log.entering(CLASS, methodName);
        try {
            String redirect = attributeList.getAttributeValueByNameAndType("redirect_uri", "urn:ibm:names:query:param");
            if (OidcOAuth20Util.isNullEmpty(redirect) && (OidcOAuth20Util.isNullEmpty(redirectUris) || redirectUris.size() != 1 || allowRegexpRedirects)) {
                throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "redirect_uri", null);
            }
            String username = attributeList.getAttributeValueByNameAndType("username", "urn:ibm:names:oauth:request");
            if (username == null || username.length() == 0) {
                throw new OAuth20AccessDeniedException("security.oauth20.error.access.denied");
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OAuth20Token> buildTokensResponseType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, String redirectUri) {
        String methodName = "buildTokensResponseType";
        _log.entering(CLASS, methodName, new Object[]{redirectUri});
        ArrayList<OAuth20Token> tokenList = null;
        try {
            String clientId = attributeList.getAttributeValueByNameAndType("client_id", "urn:ibm:names:query:param");
            String username = attributeList.getAttributeValueByNameAndType("username", "urn:ibm:names:oauth:request");
            String redirect = attributeList.getAttributeValueByNameAndType("redirect_uri", "urn:ibm:names:query:param");
            String[] scope = attributeList.getAttributeValuesByName("scope");
            if (redirect == null) {
                redirect = redirectUri;
            }
            Map<String, String[]> tokenMap = tokenFactory.buildTokenMap(clientId, username, redirect, null, scope, null, "implicit");
            OAuth20Util.populateJwtAccessTokenData(attributeList, tokenMap);
            OAuth20TokenHelper.getExternalClaims(tokenMap, attributeList);
            String proxy = attributeList.getAttributeValueByName("X-Forwarded-Host");
            tokenMap.put("X-Forwarded-Host", new String[]{proxy});
            OAuth20Token token = tokenFactory.createAccessToken(tokenMap);
            tokenList = new ArrayList<OAuth20Token>();
            tokenList.add(token);
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return tokenList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildResponseResponseType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseResponseType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token token;
            if (tokens.size() >= 1 && (token = tokens.get(0)) != null) {
                String accessToken = token.getTokenString();
                attributeList.setAttribute("access_token", "urn:ibm:names:oauth:response:attribute", new String[]{accessToken});
                String accessTokenId = token.getId();
                attributeList.setAttribute("access_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{accessTokenId});
                String type = token.getSubType();
                attributeList.setAttribute("token_type", "urn:ibm:names:oauth:response:attribute", new String[]{type});
                String expires = OAuth20TokenHelper.expiresInSeconds(token);
                attributeList.setAttribute("expires_in", "urn:ibm:names:oauth:response:attribute", new String[]{expires});
                String[] scope = token.getScope();
                attributeList.setAttribute("scope", "urn:ibm:names:oauth:response:attribute", scope);
                String stateId = token.getStateId();
                attributeList.setAttribute("state_id", "urn:ibm:names:oauth:state", new String[]{stateId});
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }
}

