/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.unified.resolver;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.CompositeComponentExpressionHolder;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.myfaces.shared.config.MyfacesConfig;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentBeanInfo;

public final class CompositeComponentELResolver
extends ELResolver {
    private static final String ATTRIBUTES_MAP = "attrs";
    private static final String PARENT_COMPOSITE_COMPONENT = "parent";
    private static final String COMPOSITE_COMPONENT_ATTRIBUTES_MAPS = "org.apache.myfaces.COMPOSITE_COMPONENT_ATTRIBUTES_MAPS";

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return String.class;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base != null && property != null && base instanceof CompositeComponentAttributesMapWrapper && property instanceof String) {
            FacesContext facesContext = CompositeComponentELResolver.facesContext(context);
            if (facesContext == null) {
                facesContext = FacesContext.getCurrentInstance();
            }
            if (facesContext == null) {
                return null;
            }
            if (!MyfacesConfig.getCurrentInstance((ExternalContext)facesContext.getExternalContext()).isStrictJsf2CCELResolver()) {
                Class exprType = null;
                Class<?> metaType = null;
                CompositeComponentAttributesMapWrapper evalMap = (CompositeComponentAttributesMapWrapper)base;
                ValueExpression ve = evalMap.getExpression((String)property);
                if (ve != null) {
                    exprType = ve.getType(context);
                }
                if (!"".equals(property) && evalMap._propertyDescriptors != null) {
                    for (PropertyDescriptor pd : evalMap._propertyDescriptors) {
                        if (!property.equals(pd.getName())) continue;
                        metaType = CompositeComponentELResolver.resolveType(context, pd);
                        break;
                    }
                }
                if (metaType != null && (exprType == null || exprType.isAssignableFrom(metaType))) {
                    context.setPropertyResolved(true);
                    return metaType;
                }
                return exprType;
            }
        }
        return null;
    }

    private static Class<?> resolveType(ELContext context, PropertyDescriptor pd) {
        if (pd != null) {
            Object type = pd.getValue("type");
            if (type != null) {
                if ((type = ((ValueExpression)type).getValue(context)) instanceof String) {
                    try {
                        type = ClassUtils.javaDefaultTypeToClass((String)type);
                    }
                    catch (ClassNotFoundException e) {
                        type = null;
                    }
                }
                return (Class)type;
            }
            return pd.getPropertyType();
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base != null && base instanceof UIComponent && UIComponent.isCompositeComponent((UIComponent)((UIComponent)base)) && property != null) {
            String propName = property.toString();
            UIComponent baseComponent = (UIComponent)base;
            if (propName.equals(ATTRIBUTES_MAP)) {
                context.setPropertyResolved(true);
                return this._getCompositeComponentAttributesMapWrapper(baseComponent, context);
            }
            if (propName.equals(PARENT_COMPOSITE_COMPONENT)) {
                context.setPropertyResolved(true);
                return UIComponent.getCompositeComponentParent((UIComponent)baseComponent);
            }
        }
        return null;
    }

    private Map<String, Object> _getCompositeComponentAttributesMapWrapper(UIComponent baseComponent, ELContext elContext) {
        Map contextMap = CompositeComponentELResolver.facesContext(elContext).getAttributes();
        WeakHashMap<UIComponent, WeakReference<CompositeComponentAttributesMapWrapper>> compositeComponentAttributesMaps = (WeakHashMap<UIComponent, WeakReference<CompositeComponentAttributesMapWrapper>>)contextMap.get(COMPOSITE_COMPONENT_ATTRIBUTES_MAPS);
        Map<String, Object> attributesMap = null;
        if (compositeComponentAttributesMaps != null) {
            WeakReference weakReference = (WeakReference)compositeComponentAttributesMaps.get(baseComponent);
            if (weakReference != null) {
                attributesMap = (Map)weakReference.get();
            }
            if (attributesMap == null) {
                attributesMap = new CompositeComponentAttributesMapWrapper(baseComponent);
                compositeComponentAttributesMaps.put(baseComponent, new WeakReference<CompositeComponentAttributesMapWrapper>((CompositeComponentAttributesMapWrapper)attributesMap));
            }
        } else {
            attributesMap = new CompositeComponentAttributesMapWrapper(baseComponent);
            compositeComponentAttributesMaps = new WeakHashMap<UIComponent, WeakReference<CompositeComponentAttributesMapWrapper>>();
            compositeComponentAttributesMaps.put(baseComponent, new WeakReference<CompositeComponentAttributesMapWrapper>((CompositeComponentAttributesMapWrapper)attributesMap));
            contextMap.put(COMPOSITE_COMPONENT_ATTRIBUTES_MAPS, compositeComponentAttributesMaps);
        }
        return attributesMap;
    }

    private static FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return true;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }

    private final class CompositeComponentAttributesMapWrapper
    implements CompositeComponentExpressionHolder,
    Map<String, Object> {
        private final UIComponent _component;
        private final BeanInfo _beanInfo;
        private final Map<String, Object> _originalMap;
        private final PropertyDescriptor[] _propertyDescriptors;
        private final CompositeComponentBeanInfo _ccBeanInfo;

        private CompositeComponentAttributesMapWrapper(UIComponent component) {
            this._component = component;
            this._originalMap = component.getAttributes();
            this._beanInfo = (BeanInfo)this._originalMap.get("jakarta.faces.component.BEANINFO_KEY");
            this._propertyDescriptors = this._beanInfo.getPropertyDescriptors();
            this._ccBeanInfo = this._beanInfo instanceof CompositeComponentBeanInfo ? (CompositeComponentBeanInfo)this._beanInfo : null;
        }

        public ValueExpression getExpression(String name) {
            ValueExpression valueExpr = this._component.getValueExpression(name);
            return valueExpr;
        }

        @Override
        public void clear() {
            this._originalMap.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            boolean value = this._originalMap.containsKey(key);
            if (value) {
                return value;
            }
            if (this._ccBeanInfo == null) {
                for (PropertyDescriptor attribute : this._propertyDescriptors) {
                    if (!attribute.getName().equals(key)) continue;
                    return attribute.getValue("default") != null;
                }
            } else {
                PropertyDescriptor attribute = this._ccBeanInfo.getPropertyDescriptorsMap().get(key);
                if (attribute != null) {
                    return attribute.getValue("default") != null;
                }
            }
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return this._originalMap.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this._originalMap.entrySet();
        }

        @Override
        public Object get(Object key) {
            Object obj = this._originalMap.get(key);
            if (obj != null) {
                return obj;
            }
            if (this._ccBeanInfo == null) {
                for (PropertyDescriptor attribute : this._propertyDescriptors) {
                    if (!attribute.getName().equals(key)) continue;
                    obj = attribute.getValue("default");
                    break;
                }
            } else {
                PropertyDescriptor attribute = this._ccBeanInfo.getPropertyDescriptorsMap().get(key);
                if (attribute != null) {
                    obj = attribute.getValue("default");
                }
            }
            if (obj != null && obj instanceof ValueExpression) {
                return ((ValueExpression)obj).getValue(FacesContext.getCurrentInstance().getELContext());
            }
            return obj;
        }

        @Override
        public boolean isEmpty() {
            return this._originalMap.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this._originalMap.keySet();
        }

        @Override
        public Object put(String key, Object value) {
            ValueExpression valueExpression = this._component.getValueExpression(key);
            if (valueExpression != null) {
                valueExpression.setValue(FacesContext.getCurrentInstance().getELContext(), value);
                return null;
            }
            return this._originalMap.put(key, value);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            for (String string : m.keySet()) {
                this.put(string, m.get(string));
            }
        }

        @Override
        public Object remove(Object key) {
            return this._originalMap.remove(key);
        }

        @Override
        public int size() {
            return this._originalMap.size();
        }

        @Override
        public Collection<Object> values() {
            return this._originalMap.values();
        }
    }
}

