/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIDataGraphSchemaNotFoundException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.ws.sib.admin.internal.JsObject;
import com.ibm.ws.sib.mfp.IncorrectMessageTypeException;
import com.ibm.ws.sib.mfp.JsJmsBytesMessage;
import com.ibm.ws.sib.mfp.JsJmsMapMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsJmsObjectMessage;
import com.ibm.ws.sib.mfp.JsJmsStreamMessage;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageType;
import com.ibm.ws.sib.mfp.ObjectFailedToSerializeException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteMessageControllable;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class JsMessagePoint
extends JsObject {
    public static final String $sccsid = "@(#) 1.23 SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/JsMessagePoint.java, SIB.admin, WASX.SIB, rr1243.02 07/07/04 11:44:20 [10/25/12 16:31:40]";
    private static final TraceComponent tc = SibTr.register(JsMessagePoint.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    Properties props = new Properties();

    public Properties getProperties() {
        return (Properties)this.props.clone();
    }

    private byte[] getData(byte[] in, Integer size) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getData", (Object)new Object[]{in, size});
        }
        byte[] tmp = null;
        if (in != null) {
            int len = 1024;
            if (size > 0) {
                len = size;
            }
            if (len > in.length) {
                len = in.length;
            }
            tmp = new byte[len];
            System.arraycopy(in, 0, tmp, 0, len);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getData", tmp);
        }
        return tmp;
    }

    public byte[] getMessageData(SIMPQueuedMessageControllable qmc, Integer size) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)size.toString());
        }
        byte[] data = null;
        if (qmc != null) {
            try {
                JsMessage jm = qmc.getJsMessage();
                data = this.getMessageData(jm, size);
            }
            catch (SIMPException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getMessageData", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData");
        }
        return data;
    }

    public byte[] getMessageData(SIMPRemoteMessageControllable rmc, Integer size) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)size.toString());
        }
        byte[] data = null;
        if (rmc != null) {
            try {
                JsMessage jm = rmc.getJsMessage();
                data = this.getMessageData(jm, size);
            }
            catch (SIMPException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"getMessageData", (Object)((Object)e));
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData");
        }
        return data;
    }

    private byte[] getMessageData(JsMessage jm, Integer size) throws IncorrectMessageTypeException, SIDataGraphSchemaNotFoundException, SIMessageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageData", (Object)new Object[]{jm, size});
        }
        byte[] data = null;
        MessageType mt = jm.getJsMessageType();
        if (mt == MessageType.JMS) {
            JsJmsMessage m = jm.makeInboundJmsMessage();
            if (m instanceof JsJmsTextMessage) {
                JsJmsTextMessage msg = (JsJmsTextMessage)m;
                String text = null;
                try {
                    text = msg.getText();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                if (text != null) {
                    data = this.getData(text.getBytes(), size);
                }
            } else if (m instanceof JsJmsBytesMessage) {
                JsJmsBytesMessage msg = (JsJmsBytesMessage)m;
                data = this.getData(msg.getBytes(), size);
            } else if (m instanceof JsJmsObjectMessage) {
                JsJmsObjectMessage msg = (JsJmsObjectMessage)m;
                try {
                    data = this.getData(msg.getSerializedObject(), size);
                }
                catch (ObjectFailedToSerializeException ofse) {
                    data = null;
                }
            } else if (m instanceof JsJmsMapMessage) {
                JsJmsMapMessage msg = (JsJmsMapMessage)m;
                try {
                    data = this.getData(msg.getUserFriendlyBytes(), size);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else if (m instanceof JsJmsStreamMessage) {
                JsJmsStreamMessage msg = (JsJmsStreamMessage)m;
                try {
                    data = this.getData(msg.getUserFriendlyBytes(), size);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageData", data);
        }
        return data;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/JsMessagePoint.java, SIB.admin, WASX.SIB, rr1243.02 1.23");
        }
    }
}

