/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.cdi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.data.internal.QueryType;
import io.openliberty.data.internal.persistence.DataProvider;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.Util;
import io.openliberty.data.internal.persistence.cdi.FutureEMBuilder;
import io.openliberty.data.internal.persistence.cdi.RepositoryProducer;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.EmptyResultException;
import jakarta.data.exceptions.EntityExistsException;
import jakarta.data.exceptions.MappingException;
import jakarta.data.exceptions.OptimisticLockingFailureException;
import jakarta.data.repository.By;
import jakarta.data.repository.DataRepository;
import jakarta.data.repository.Delete;
import jakarta.data.repository.Find;
import jakarta.data.repository.Insert;
import jakarta.data.repository.Query;
import jakarta.data.repository.Repository;
import jakarta.data.repository.Save;
import jakarta.data.repository.Update;
import jakarta.data.spi.EntityDefining;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DataExtension
implements Extension {
    private static final TraceComponent tc = Tr.register(DataExtension.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    static final String DEFAULT_DATA_SOURCE = "java:comp/DefaultDataSource";
    public static final String PROVIDER_NAME = "Liberty";
    private final ConcurrentHashMap<AnnotatedType<?>, Repository> repositoryAnnos = new ConcurrentHashMap();
    static final long serialVersionUID = 6490381904926426317L;

    @Trivial
    public <T> void annotatedRepository(@Observes @WithAnnotations(value={Repository.class}) ProcessAnnotatedType<T> event) {
        boolean provide;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        AnnotatedType type = event.getAnnotatedType();
        Repository repository = (Repository)type.getAnnotation(Repository.class);
        String dataProvider = repository.provider();
        boolean bl = provide = "".equals(dataProvider) || PROVIDER_NAME.equalsIgnoreCase(dataProvider);
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("annotatedRepository to " + (provide ? "provide" : "ignore")), (Object[])new Object[]{repository.toString(), type.getJavaClass().getName()});
        }
        if (provide) {
            this.repositoryAnnos.put(type, repository);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanMgr) {
        BundleContext bundleContext = FrameworkUtil.getBundle(DataProvider.class).getBundleContext();
        ServiceReference ref = bundleContext.getServiceReference(DataProvider.class);
        DataProvider provider = (DataProvider)bundleContext.getService(ref);
        HashMap<FutureEMBuilder, FutureEMBuilder> entityGroups = new HashMap<FutureEMBuilder, FutureEMBuilder>();
        Iterator it = ((ConcurrentHashMap.KeySetView)this.repositoryAnnos.keySet()).iterator();
        while (it.hasNext()) {
            AnnotatedType repositoryType = (AnnotatedType)it.next();
            it.remove();
            Class repositoryInterface = repositoryType.getJavaClass();
            ClassLoader loader = repositoryInterface.getClassLoader();
            Repository repository = (Repository)repositoryType.getAnnotation(Repository.class);
            String dataStore = repository.dataStore();
            if (dataStore.length() == 0) {
                dataStore = DEFAULT_DATA_SOURCE;
            }
            FutureEMBuilder futureEMBuilder = new FutureEMBuilder(provider, repositoryInterface, loader, dataStore);
            RepositoryProducer<Object> producer = this.discoverEntityClasses(repositoryType, provider, beanMgr);
            if (producer == null) continue;
            FutureEMBuilder previous = entityGroups.putIfAbsent(futureEMBuilder, futureEMBuilder);
            if (previous != null) {
                futureEMBuilder = previous;
                futureEMBuilder.addRepositoryInterface(repositoryInterface);
            }
            for (Class<?> entityClass : producer.queriesPerEntityClass.keySet()) {
                if (QueryInfo.ENTITY_TBD.equals(entityClass)) continue;
                futureEMBuilder.addEntity(entityClass);
            }
            producer.setFutureEMBuilder(futureEMBuilder);
            provider.producerCreated(futureEMBuilder.jeeName.getApplication(), producer);
            Bean bean = beanMgr.createBean(producer, repositoryInterface, producer);
            event.addBean(bean);
        }
        String appName = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData().getJ2EEName().getApplication();
        provider.onStart(appName, entityGroups.keySet());
    }

    private RepositoryProducer<Object> discoverEntityClasses(AnnotatedType<?> repositoryType, DataProvider provider, BeanManager beanMgr) {
        Class repositoryInterface = repositoryType.getJavaClass();
        Class primaryEntityClass = DataExtension.getPrimaryEntityType(repositoryInterface);
        HashSet lifecycleMethodEntityClasses = new HashSet();
        HashMap queriesPerEntity = new HashMap();
        ArrayList queriesWithQueryAnno = new ArrayList();
        ArrayList<QueryInfo> additionalQueriesForPrimaryEntity = new ArrayList<QueryInfo>();
        RepositoryProducer<Object> producer = new RepositoryProducer<Object>(repositoryInterface, beanMgr, provider, this, queriesPerEntity);
        for (Method method : repositoryInterface.getMethods()) {
            List<QueryInfo> queries;
            if (method.isDefault()) continue;
            Class<?> returnType = method.getReturnType();
            if (method.getParameterCount() == 0 && (EntityManager.class.equals(returnType) || DataSource.class.equals(returnType) || Connection.class.equals(returnType))) {
                QueryInfo queryInfo = new QueryInfo(producer, repositoryInterface, method, QueryType.RESOURCE_ACCESS);
                ArrayList<QueryInfo> queries2 = (ArrayList<QueryInfo>)queriesPerEntity.get(Void.class);
                if (queries2 == null) {
                    queries2 = new ArrayList<QueryInfo>();
                    queriesPerEntity.put(Void.class, queries2);
                }
                queries2.add(queryInfo);
                continue;
            }
            Find find = method.getAnnotation(Find.class);
            Class<?> entityClass = find == null ? Void.TYPE : producer.compat().getEntityClass(find);
            Class<?> returnArrayComponentType = null;
            ArrayList returnTypeAtDepth = new ArrayList(5);
            Type type = method.getGenericReturnType();
            for (int depth = 0; depth < 5 && type != null; ++depth) {
                if (type instanceof ParameterizedType) {
                    returnTypeAtDepth.add((Class)((ParameterizedType)type).getRawType());
                    Type[] typeParams = ((ParameterizedType)type).getActualTypeArguments();
                    type = typeParams.length == 1 ? typeParams[0] : null;
                    continue;
                }
                if (type instanceof Class) {
                    Class c = (Class)type;
                    returnTypeAtDepth.add(c);
                    if (IntStream.class.equals((Object)type)) {
                        returnTypeAtDepth.add(Integer.TYPE);
                        ++depth;
                    } else if (LongStream.class.equals((Object)type)) {
                        returnTypeAtDepth.add(Long.TYPE);
                        ++depth;
                    } else if (DoubleStream.class.equals((Object)type)) {
                        returnTypeAtDepth.add(Double.TYPE);
                        ++depth;
                    } else if (returnArrayComponentType == null && (returnArrayComponentType = c.getComponentType()) != null) {
                        returnTypeAtDepth.add(returnArrayComponentType);
                        ++depth;
                    }
                    type = null;
                    continue;
                }
                if (type instanceof GenericArrayType) {
                    Class<?> arrayComponentType = entityClass == Void.TYPE ? DataExtension.requirePrimaryEntity(primaryEntityClass, repositoryInterface, method) : entityClass;
                    returnTypeAtDepth.add((Class<?>)arrayComponentType.arrayType());
                    if (returnArrayComponentType == null) {
                        returnArrayComponentType = arrayComponentType;
                        returnTypeAtDepth.add(returnArrayComponentType);
                        ++depth;
                    }
                    type = null;
                    continue;
                }
                Class<?> ec = entityClass == Void.TYPE ? DataExtension.requirePrimaryEntity(primaryEntityClass, repositoryInterface, method) : entityClass;
                returnTypeAtDepth.add(ec);
                type = null;
            }
            if (entityClass == Void.TYPE) {
                entityClass = (Class)returnTypeAtDepth.get(returnTypeAtDepth.size() - 1);
            }
            Class<?> entityParamType = null;
            boolean hasQueryAnno = method.isAnnotationPresent(Query.class);
            if (method.getParameterCount() == 1 && !method.isDefault() && !hasQueryAnno && (method.isAnnotationPresent(Insert.class) || method.isAnnotationPresent(Update.class) || method.isAnnotationPresent(Save.class) || method.isAnnotationPresent(Delete.class))) {
                String packageName;
                Class<?> c = method.getParameterTypes()[0];
                if (Iterable.class.isAssignableFrom(c) || Stream.class.isAssignableFrom(c)) {
                    type = method.getGenericParameterTypes()[0];
                    if (type instanceof ParameterizedType) {
                        Type[] typeParams = ((ParameterizedType)type).getActualTypeArguments();
                        if (typeParams.length == 1 && typeParams[0] instanceof Class) {
                            c = (Class<?>)typeParams[0];
                        } else {
                            entityParamType = c;
                            c = null;
                        }
                    } else {
                        c = null;
                    }
                } else if (c.isArray()) {
                    c = c.getComponentType();
                }
                if (Object.class.equals(c)) {
                    boolean isEntity = true;
                    for (Annotation anno : method.getParameterAnnotations()[0]) {
                        if (!By.class.equals(anno.annotationType())) continue;
                        isEntity = false;
                    }
                    if (isEntity) {
                        entityParamType = c;
                    }
                } else if (!(c == null || c.isPrimitive() || c.isInterface() || (packageName = c.getPackageName()).startsWith("java.") || packageName.startsWith("jakarta."))) {
                    Parameter param = method.getParameters()[0];
                    entityParamType = param.getType();
                    for (Annotation anno : param.getAnnotations()) {
                        if (!anno.annotationType().getPackageName().startsWith("jakarta.data")) continue;
                        entityParamType = null;
                    }
                    if (entityParamType != null) {
                        entityClass = c;
                        lifecycleMethodEntityClasses.add(c);
                    }
                }
            }
            if (Util.cannotBeEntity(entityClass)) {
                queries = hasQueryAnno ? queriesWithQueryAnno : additionalQueriesForPrimaryEntity;
            } else {
                queries = (List)queriesPerEntity.get(entityClass);
                if (queries == null) {
                    queries = new ArrayList();
                    queriesPerEntity.put(entityClass, queries);
                }
                if (hasQueryAnno) {
                    queries = queriesWithQueryAnno;
                }
            }
            queries.add(new QueryInfo(producer, repositoryInterface, method, entityParamType, returnArrayComponentType, returnTypeAtDepth));
        }
        boolean supportsAllEntities = true;
        HashSet<Class> allEntityClasses = new HashSet<Class>();
        if (primaryEntityClass != null) {
            allEntityClasses.add(primaryEntityClass);
            supportsAllEntities &= this.supportsEntity(primaryEntityClass, repositoryType);
        }
        for (Class clazz : lifecycleMethodEntityClasses) {
            if (!allEntityClasses.add(clazz)) continue;
            supportsAllEntities &= this.supportsEntity(clazz, repositoryType);
        }
        Iterator it = queriesPerEntity.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Class c = (Class)entry.getKey();
            if (allEntityClasses.contains(c)) continue;
            if (c.getAnnotation(Entity.class) == null) {
                supportsAllEntities &= this.supportsEntity(c, repositoryType);
                for (QueryInfo queryInfo : (List)entry.getValue()) {
                    additionalQueriesForPrimaryEntity.add(queryInfo);
                }
                it.remove();
                continue;
            }
            allEntityClasses.add(c);
        }
        if (supportsAllEntities) {
            if (primaryEntityClass == null) {
                if (lifecycleMethodEntityClasses.size() == 1) {
                    primaryEntityClass = (Class)lifecycleMethodEntityClasses.iterator().next();
                } else if (lifecycleMethodEntityClasses.isEmpty()) {
                    if (queriesPerEntity.size() == 1) {
                        primaryEntityClass = (Class)queriesPerEntity.keySet().iterator().next();
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Unable to determine primary entity class because there are multiple entity classes: ", (Object[])new Object[]{queriesPerEntity.keySet()});
                    }
                }
            } else if (!queriesPerEntity.containsKey(primaryEntityClass)) {
                queriesPerEntity.put(primaryEntityClass, new ArrayList());
            }
            if (!additionalQueriesForPrimaryEntity.isEmpty()) {
                Method method = ((QueryInfo)additionalQueriesForPrimaryEntity.get((int)0)).method;
                Class<?> clazz = DataExtension.requirePrimaryEntity(primaryEntityClass, repositoryInterface, method);
                List queries = (List)queriesPerEntity.get(clazz);
                if (queries == null) {
                    queriesPerEntity.put(clazz, additionalQueriesForPrimaryEntity);
                } else {
                    queries.addAll(additionalQueriesForPrimaryEntity);
                }
            }
            if (!queriesWithQueryAnno.isEmpty()) {
                queriesPerEntity.put(Query.class, queriesWithQueryAnno);
            }
            producer.setPrimaryEntityClass(primaryEntityClass);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(repositoryInterface.getName() + " has primary entity " + String.valueOf(primaryEntityClass)), (Object[])new Object[]{"and methods that use the following entities:", queriesPerEntity});
        }
        return supportsAllEntities ? producer : null;
    }

    @Trivial
    public static final <T extends RuntimeException> T exc(Class<T> exceptionType, String messageId, Object ... args) {
        if (!(exceptionType.equals(EmptyResultException.class) || exceptionType.equals(EntityExistsException.class) || exceptionType.equals(IllegalArgumentException.class) || exceptionType.equals(IllegalStateException.class) || exceptionType.equals(NoSuchElementException.class) || exceptionType.equals(NullPointerException.class) || exceptionType.equals(OptimisticLockingFailureException.class))) {
            Tr.error((TraceComponent)tc, (String)messageId, (Object[])args);
        }
        String message = Tr.formatMessage((TraceComponent)tc, (String)messageId, (Object[])args);
        try {
            return (T)((RuntimeException)exceptionType.getConstructor(String.class).newInstance(message));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.data.internal.persistence.cdi.DataExtension", (String)"485", null, (Object[])new Object[]{exceptionType, messageId, args});
            throw new DataException(messageId + " " + Arrays.toString(args));
        }
    }

    static Class<?> getPrimaryEntityType(Class<?> repositoryInterface) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        Class<?>[] interfaceClasses = repositoryInterface.getInterfaces();
        block0: for (Type interfaceType : repositoryInterface.getGenericInterfaces()) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checking " + interfaceType.getTypeName()), (Object[])new Object[0]);
            }
            if (!(interfaceType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)interfaceType;
            for (Class<?> interfaceClass : interfaceClasses) {
                Type firstParamType;
                if (!interfaceClass.equals(parameterizedType.getRawType())) continue;
                if (!DataRepository.class.isAssignableFrom(interfaceClass)) continue block0;
                Type[] typeParams = parameterizedType.getActualTypeArguments();
                Type type = firstParamType = typeParams.length > 0 ? typeParams[0] : null;
                if (firstParamType == null || !(firstParamType instanceof Class)) continue block0;
                return (Class)firstParamType;
            }
        }
        return null;
    }

    @Trivial
    private static Class<?> requirePrimaryEntity(Class<?> primaryEntityClass, Class<?> repositoryInterface, Method method) {
        if (primaryEntityClass == null) {
            throw DataExtension.exc(MappingException.class, "CWWKD1001.no.primary.entity", method.getName(), repositoryInterface.getName(), "DataRepository<EntityClass, EntityIdClass>");
        }
        return primaryEntityClass;
    }

    private boolean supportsEntity(Class<?> entityClass, AnnotatedType<?> repositoryType) {
        Repository repository;
        boolean isSupported;
        Object[] entityClassAnnos = entityClass.getAnnotations();
        boolean hasEntityAnnos = false;
        for (Annotation annotation : entityClassAnnos) {
            Class<? extends Annotation> annoClass = annotation.annotationType();
            if (annoClass.equals(Entity.class)) {
                return true;
            }
            if (!annoClass.getSimpleName().endsWith("Entity") && !annoClass.isAnnotationPresent(EntityDefining.class)) continue;
            hasEntityAnnos = true;
        }
        boolean bl = isSupported = !hasEntityAnnos;
        if (hasEntityAnnos && !"".equals((repository = (Repository)repositoryType.getAnnotation(Repository.class)).provider())) {
            throw DataExtension.exc(DataException.class, "CWWKD1045.unknown.entity.anno", repositoryType.getJavaClass().getName(), entityClass.getName(), Arrays.toString(entityClassAnnos), Entity.class.getName());
        }
        return isSupported;
    }
}

