/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.requests;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.ToolMetadata;
import io.openliberty.mcp.internal.ToolRegistry;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.bind.Jsonb;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpToolCallParams {
    private String name;
    private ToolMetadata metadata;
    private static final TraceComponent tc = Tr.register(McpToolCallParams.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
    private JsonObject arguments;
    private Object[] parsedArguments;
    static final long serialVersionUID = -471949729511696390L;

    public ToolMetadata getMetadata() {
        return this.metadata;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        ToolRegistry tools = ToolRegistry.get();
        this.metadata = tools.getTool(name);
    }

    public void setArguments(JsonObject arguments) {
        this.arguments = arguments;
    }

    public Method getMethod() {
        return this.metadata.method().getJavaMember();
    }

    public Object[] getArguments(Jsonb jsonb) {
        if (this.arguments == null) {
            throw new JSONRPCException(JSONRPCErrorCode.INVALID_PARAMS, List.of(Tr.formatMessage((TraceComponent)tc, (String)"jsonrpc.missing.params", (Object[])new Object[0])));
        }
        if (this.parsedArguments == null) {
            this.parsedArguments = this.parseArguments(this.arguments, jsonb);
        }
        return this.parsedArguments;
    }

    private Object[] parseArguments(JsonObject arguments2, Jsonb jsonb) {
        JsonObject argsObject = arguments2.asJsonObject();
        Map<String, ToolMetadata.ArgumentMetadata> arguments = this.metadata.arguments();
        List<ToolMetadata.SpecialArgumentMetadata> specialArguments = this.metadata.specialArguments();
        Object[] results = new Object[arguments.size() + specialArguments.size()];
        HashSet<String> argsProcessed = new HashSet<String>();
        for (Map.Entry entry : argsObject.entrySet()) {
            String argName = (String)entry.getKey();
            JsonValue argValue = (JsonValue)entry.getValue();
            ToolMetadata.ArgumentMetadata argMetadata = this.metadata.arguments().get(argName);
            if (argMetadata != null) {
                String json = jsonb.toJson((Object)argValue);
                results[argMetadata.index()] = jsonb.fromJson(json, argMetadata.type());
            }
            argsProcessed.add(argName);
        }
        this.validateProcessedArgs(argsProcessed, arguments.keySet());
        return results;
    }

    private void validateProcessedArgs(Set<String> processedArgs, Set<String> expectedArgs) {
        if (!processedArgs.equals(expectedArgs)) {
            List<String> data = this.generateArgumentMismatchData(processedArgs, expectedArgs);
            throw new JSONRPCException(JSONRPCErrorCode.INVALID_PARAMS, data);
        }
    }

    public List<String> generateArgumentMismatchData(Set<String> processed, Set<String> expected) {
        HashSet<String> missing = new HashSet<String>(expected);
        missing.removeAll(processed);
        HashSet<String> extra = new HashSet<String>(processed);
        extra.removeAll(expected);
        ArrayList<String> data = new ArrayList<String>();
        if (!extra.isEmpty()) {
            data.add(Tr.formatMessage((TraceComponent)tc, (String)"jsonrpc.extra.arguments", (Object[])new Object[]{extra}));
        }
        if (!missing.isEmpty()) {
            data.add(Tr.formatMessage((TraceComponent)tc, (String)"jsonrpc.missing.arguments", (Object[])new Object[]{missing}));
        }
        return !data.isEmpty() ? data : null;
    }

    public Bean<?> getBean() {
        return this.metadata.bean();
    }
}

