/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.HeaderValidation;
import io.openliberty.mcp.internal.McpProtocolVersion;
import io.openliberty.mcp.internal.McpSession;
import io.openliberty.mcp.internal.McpSessionStore;
import io.openliberty.mcp.internal.exceptions.jsonrpc.HttpResponseException;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCErrorCode;
import io.openliberty.mcp.internal.exceptions.jsonrpc.JSONRPCException;
import io.openliberty.mcp.internal.requests.McpRequest;
import io.openliberty.mcp.internal.requests.McpRequestId;
import io.openliberty.mcp.internal.responses.McpErrorResponse;
import io.openliberty.mcp.internal.responses.McpResultResponse;
import io.openliberty.mcp.tools.ToolResponse;
import jakarta.json.JsonException;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbException;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpTransport {
    public static final String MCP_SESSION_ID_HEADER = "Mcp-Session-Id";
    private static final TraceComponent tc = Tr.register(McpTransport.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
    private static final String MCP_HEADER = "MCP-Protocol-Version";
    private static final List<String> REQUIRED_MCP_MIME_TYPES = List.of("text/event-stream", "application/json");
    private HttpServletRequest req;
    private HttpServletResponse res;
    private Jsonb jsonb;
    private McpRequest mcpRequest;
    private Writer writer;
    private McpProtocolVersion version;
    private String sessionId;
    private McpSession sessionInfo;
    private static final AtomicInteger TIMEOUT_SECONDS = new AtomicInteger(30);
    static final long serialVersionUID = 3232407711876300613L;

    public McpTransport(HttpServletRequest req, HttpServletResponse res, Jsonb jsonb) throws IOException {
        this.req = req;
        this.res = res;
        this.jsonb = jsonb;
        this.writer = res.getWriter();
    }

    @FFDCIgnore(value={NoSuchElementException.class})
    public void init(McpSessionStore sessionStore) throws IOException {
        if (!this.validReqAcceptHeader()) {
            throw new HttpResponseException(406);
        }
        try {
            this.version = this.readProtocolVersionHeader();
        }
        catch (NoSuchElementException e) {
            String supportedValues = Arrays.stream(McpProtocolVersion.values()).map(McpProtocolVersion::getVersion).collect(Collectors.joining(", "));
            String excpetionMesaage = Tr.formatMessage((TraceComponent)tc, (String)"CWMCM0013E.unsupported.mcp.http.version", (Object[])new Object[]{supportedValues});
            throw new HttpResponseException(400, excpetionMesaage);
        }
        this.mcpRequest = this.toRequest();
        String sessionIdHeader = this.req.getHeader(MCP_SESSION_ID_HEADER);
        if (sessionIdHeader == null) {
            this.sessionInfo = null;
            return;
        }
        McpSession session = sessionStore.getSession(sessionIdHeader);
        if (session == null) {
            throw new HttpResponseException(404, "Invalid or Expired Session Id");
        }
        this.sessionInfo = session;
    }

    @FFDCIgnore(value={JsonException.class})
    private McpRequest toRequest() throws IOException, JSONRPCException {
        McpRequest mcpRequest = null;
        try {
            BufferedReader re = this.req.getReader();
            mcpRequest = McpRequest.createValidMCPRequest(re);
        }
        catch (JsonException | JsonbException e) {
            throw new JSONRPCException(JSONRPCErrorCode.PARSE_ERROR, List.of(e.getMessage()));
        }
        return mcpRequest;
    }

    /*
     * WARNING - void declaration
     */
    private boolean validReqAcceptHeader() throws IOException {
        try {
            String reqHeaderAcceptedTypes = this.req.getHeader("Accept");
            if (reqHeaderAcceptedTypes == null) {
                return false;
            }
            for (String mcpMime : REQUIRED_MCP_MIME_TYPES) {
                if (HeaderValidation.acceptContains(reqHeaderAcceptedTypes, mcpMime)) continue;
                return false;
            }
            return true;
        }
        catch (Exception reqHeaderAcceptedTypes) {
            void e;
            FFDCFilter.processException((Throwable)reqHeaderAcceptedTypes, (String)"io.openliberty.mcp.internal.McpTransport", (String)"140", (Object)this, (Object[])new Object[0]);
            this.sendError((Throwable)e);
            return false;
        }
    }

    private McpProtocolVersion readProtocolVersionHeader() {
        String protocolVersion = this.req.getHeader(MCP_HEADER);
        if (protocolVersion == null) {
            return McpProtocolVersion.V_2025_03_26;
        }
        return McpProtocolVersion.parse(protocolVersion);
    }

    public McpRequest getMcpRequest() {
        return this.mcpRequest;
    }

    void setResponseHeader(String name, String value) {
        this.res.setHeader(name, value);
    }

    public McpSession getSession() {
        return this.sessionInfo;
    }

    public String getSessionId() {
        return this.sessionInfo == null ? null : this.sessionInfo.getSessionId();
    }

    public <T> T getParams(Class<T> type) {
        return this.mcpRequest.getParams(type, this.jsonb);
    }

    public void sendResponse(Object result) {
        McpResultResponse mcpResponse = new McpResultResponse(this.mcpRequest.id(), result);
        this.res.setContentType("application/json");
        this.jsonb.toJson((Object)mcpResponse, this.writer);
    }

    public void sendEmptyResponse() {
        this.res.setStatus(202);
    }

    public void sendError(Throwable e) throws IOException {
        String excpetionMessage = Tr.formatMessage((TraceComponent)tc, (String)"CWMCM0014E.unexpected.server.error", (Object[])new Object[]{this.req.getMethod(), this.req.getRequestURI(), this.req.getQueryString()});
        Tr.error((TraceComponent)tc, (String)"CWMCM0015E.unexpected.server.error.exception", (Object[])new Object[]{this.req.getMethod(), this.req.getRequestURI(), this.req.getQueryString(), e.getMessage()});
        this.res.sendError(500, excpetionMessage);
    }

    public void sendJsonRpcException(JSONRPCException e) {
        McpErrorResponse mcpResponse = new McpErrorResponse(this.mcpRequest == null ? new McpRequestId("") : this.mcpRequest.id(), e);
        this.res.setContentType("application/json");
        this.jsonb.toJson((Object)mcpResponse, this.writer);
    }

    public void sendHttpException(HttpResponseException e) throws IOException {
        this.res.setStatus(e.getStatusCode());
        if (e.getHeaders() != null) {
            e.getHeaders().forEach((key, val) -> this.res.setHeader(key, val));
        }
        if (e.getMessage() != null) {
            this.res.setContentType("text/plain");
            this.writer.write(e.getMessage());
        }
    }

    public String getRequestIpAddress() {
        String ipAddress = this.req.getRemoteAddr();
        String proxyAddress = this.req.getHeader("X-Forwarded-For");
        if (proxyAddress != null && !proxyAddress.equals(ipAddress)) {
            Tr.error((TraceComponent)tc, (String)"CWMCM0021E.unknown.proxy.address", (Object[])new Object[0]);
            throw new HttpResponseException(403, "");
        }
        return ipAddress;
    }

    public McpProtocolVersion getProtocolVersion() {
        return this.version;
    }

    public <T> CompletionStage<Void> sendResultAsync(CompletionStage<T> stage) {
        AsyncContext asyncContext = this.req.startAsync();
        asyncContext.setTimeout(TimeUnit.SECONDS.toMillis(TIMEOUT_SECONDS.get()));
        return stage.handle((result, throwable) -> {
            try {
                if (throwable == null) {
                    this.sendResponse(result);
                } else {
                    this.sendError((Throwable)throwable);
                }
            }
            catch (Exception e) {
                Tr.error((TraceComponent)tc, (String)"CWMCM0016E.error.sending.response.exception", (Object[])new Object[]{e});
                this.sendResponse(ToolResponse.error((String)Tr.formatMessage((TraceComponent)tc, (String)"CWMCM0011E.internal.server.error", (Object[])new Object[0])));
            }
            finally {
                asyncContext.complete();
            }
            return null;
        });
    }
}

