/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.diffing.dot;

import java.util.ArrayList;
import java.util.List;

public class Dotfile {
    private List<Node> nodes = new ArrayList<Node>();
    private List<Edge> edges = new ArrayList<Edge>();

    public void addNode(Node node) {
        this.nodes.add(node);
    }

    public void addNode(String id, String label, String color) {
        this.nodes.add(new Node(id, label, color));
    }

    public void addEdge(String from, String to, String label) {
        this.edges.add(new Edge(from, to, label));
    }

    public void addEdge(Edge e) {
        this.edges.add(e);
    }

    public String getId() {
        return "";
    }

    public String print() {
        StringBuilder result = new StringBuilder();
        result.append("graph G {\n");
        for (Node node : this.nodes) {
            result.append(node.id).append("[label=\"").append(node.label).append("\" color=").append(node.color).append(" style=filled").append("];\n");
        }
        for (Edge edge : this.edges) {
            result.append(edge.from).append(" -- ").append(edge.to).append("[label=\"").append(edge.label).append("\"];\n");
        }
        result.append("}");
        return result.toString();
    }

    String explanation() {
        return "subgraph cluster_explanation {\nlabel=\"Explanation\";\nconcept [color=green style=filled label=\"Concept\"];\norgEntity [color=lightblue style=filled label=\"Org Entity\"];\nproduct [color=red style=filled label=\"Product\"];\nconcept -> product [style=invis];\norgEntity -> concept [style=invis];\n}";
    }

    public static class SubGraph {
        String id;
        String label;
        List<Edge> edges = new ArrayList<Edge>();
        List<Node> nodes = new ArrayList<Node>();

        public SubGraph(String id, String label) {
            this.id = id;
            this.label = label;
        }

        public String getId() {
            return this.id;
        }

        public void addEdge(Edge e) {
            this.edges.add(e);
        }

        public void addNode(Node node) {
            this.nodes.add(node);
        }
    }

    public static class Edge {
        String from;
        String to;
        String label;

        public Edge(String from, String to, String label) {
            this.from = from;
            this.to = to;
            this.label = label;
        }
    }

    public static class Node {
        String id;
        String label;
        String color;

        public Node(String id, String label, String color) {
            this.id = id;
            this.label = label;
            this.color = color;
        }
    }
}

