/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import jakarta.servlet.ServletContext;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.microprofile.config.ResteasyConfigSource;

public class ServletContextConfigSourceImpl
implements ResteasyConfigSource {
    private volatile String name;

    public Map<String, String> getProperties() {
        ServletContext context = ResteasyContext.getContextData(ServletContext.class);
        if (context == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration keys = context.getInitParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                map.put(key, context.getInitParameter(key));
            }
        }
        return map;
    }

    public Set<String> getPropertyNames() {
        ServletContext context = ResteasyContext.getContextData(ServletContext.class);
        if (context == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Collections.list(context.getInitParameterNames()));
    }

    public String getValue(String propertyName) {
        ServletContext context = ResteasyContext.getContextData(ServletContext.class);
        if (context == null) {
            return null;
        }
        return context.getInitParameter(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        String currentName = this.name;
        if (currentName == null) {
            ServletContextConfigSourceImpl servletContextConfigSourceImpl = this;
            synchronized (servletContextConfigSourceImpl) {
                currentName = this.name;
                if (currentName == null) {
                    ServletContext servletContext = ResteasyContext.getContextData(ServletContext.class);
                    StringBuilder sb = new StringBuilder();
                    this.name = currentName = sb.append(servletContext != null ? servletContext.getServletContextName() : null).append(":ServletContextConfigSource").toString();
                }
            }
        }
        return currentName;
    }

    @Override
    public int getDefaultOrdinal() {
        return 40;
    }
}

