/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.crypto.util.AESKeyManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.encoding.EncodingUtils;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIEncryptionUtils {
    public static final TraceComponent tc = Tr.register(TAIEncryptionUtils.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    private static final String TRANSFORMATION_RSA = "RSA/ECB/PKCS1Padding";
    private static final String TRANSFORMATION_AES = "AES/CBC/PKCS5Padding";
    private static final String ALG_RSA = "RSA";
    private static final String ALG_AES = "AES";
    private final EncodingUtils encodingUtils = new EncodingUtils();
    static final long serialVersionUID = 62211017497871164L;

    protected TAIEncryptionUtils() {
    }

    @Sensitive
    public String getEncryptedAccessToken(SocialLoginConfig clientConfig, @Sensitive String accessToken) throws SocialLoginException {
        if (accessToken == null) {
            throw new SocialLoginException("ACCESS_TOKEN_TO_ENCRYPT_IS_NULL", null, new Object[0]);
        }
        return this.getEncryptedAccessTokenUsingAlgorithm(clientConfig, accessToken, clientConfig.getAlgorithm());
    }

    String getEncryptedAccessTokenUsingAlgorithm(SocialLoginConfig clientConfig, @Sensitive String accessToken, String algorithm) throws SocialLoginException {
        String encryptedAccessToken = null;
        if (ALG_RSA.equals(algorithm)) {
            return this.encryptAccessTokenUsingRsa(clientConfig, accessToken);
        }
        if (ALG_AES.equals(algorithm)) {
            return this.encryptAccessTokenUsingAes(clientConfig, accessToken);
        }
        return encryptedAccessToken;
    }

    @FFDCIgnore(value={SocialLoginException.class})
    String encryptAccessTokenUsingRsa(SocialLoginConfig clientConfig, @Sensitive String accessToken) throws SocialLoginException {
        try {
            return this.rsaEncrypt(clientConfig, accessToken);
        }
        catch (SocialLoginException e) {
            throw new SocialLoginException("ERROR_GETTING_ENCRYPTED_ACCESS_TOKEN_RSA", e, new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = clientConfig;
            objectArray[1] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.tai.TAIEncryptionUtils", (String)"77", (Object)this, (Object[])objectArray);
            throw new SocialLoginException("ERROR_GETTING_ENCRYPTED_ACCESS_TOKEN_RSA", e, new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
    }

    @FFDCIgnore(value={SocialLoginException.class})
    String encryptAccessTokenUsingAes(SocialLoginConfig clientConfig, @Sensitive String accessToken) throws SocialLoginException {
        try {
            return this.aesEncrypt(clientConfig, accessToken);
        }
        catch (SocialLoginException e) {
            throw new SocialLoginException("ERROR_GETTING_ENCRYPTED_ACCESS_TOKEN_AES", e, new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = clientConfig;
            objectArray[1] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.tai.TAIEncryptionUtils", (String)"88", (Object)this, (Object[])objectArray);
            throw new SocialLoginException("ERROR_GETTING_ENCRYPTED_ACCESS_TOKEN_AES", e, new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
    }

    @Sensitive
    protected String getDecryptedAccessToken(SocialLoginConfig clientConfig, @Sensitive String encryptedToken) throws Exception {
        if (encryptedToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Provided token is null", (Object[])new Object[0]);
            }
            return null;
        }
        return this.getDecryptedAccessTokenUsingAlgorithm(clientConfig, encryptedToken, clientConfig.getAlgorithm());
    }

    String getDecryptedAccessTokenUsingAlgorithm(SocialLoginConfig clientConfig, @Sensitive String encryptedToken, String algorithm) throws SocialLoginException {
        String decryptedAccessToken = null;
        if (ALG_RSA.equals(algorithm)) {
            return this.decryptAccessTokenUsingRsa(clientConfig, encryptedToken);
        }
        if (ALG_AES.equals(algorithm)) {
            return this.decryptAccessTokenUsingAes(clientConfig, encryptedToken);
        }
        return decryptedAccessToken;
    }

    @FFDCIgnore(value={SocialLoginException.class})
    String decryptAccessTokenUsingRsa(SocialLoginConfig clientConfig, @Sensitive String encryptedToken) throws SocialLoginException {
        try {
            return this.rsaDecrypt(clientConfig, encryptedToken);
        }
        catch (SocialLoginException e) {
            throw new SocialLoginException("ERROR_GETTING_DECRYPTED_ACCESS_TOKEN_RSA", e, new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = clientConfig;
            objectArray[1] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.tai.TAIEncryptionUtils", (String)"120", (Object)this, (Object[])objectArray);
            throw new SocialLoginException("ERROR_GETTING_DECRYPTED_ACCESS_TOKEN_RSA", e, new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
    }

    @FFDCIgnore(value={SocialLoginException.class})
    String decryptAccessTokenUsingAes(SocialLoginConfig clientConfig, @Sensitive String encryptedToken) throws SocialLoginException {
        try {
            return this.aesDecrypt(clientConfig, encryptedToken);
        }
        catch (SocialLoginException e) {
            throw new SocialLoginException("ERROR_GETTING_DECRYPTED_ACCESS_TOKEN_AES", e, new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = clientConfig;
            objectArray[1] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.tai.TAIEncryptionUtils", (String)"131", (Object)this, (Object[])objectArray);
            throw new SocialLoginException("ERROR_GETTING_DECRYPTED_ACCESS_TOKEN_AES", e, new Object[]{clientConfig.getUniqueId(), e.getLocalizedMessage()});
        }
    }

    @Trivial
    protected String rsaEncrypt(SocialLoginConfig clientConfig, @Sensitive String accessToken) throws Exception {
        String encryptedAccessToken = null;
        if (accessToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Access token is null", (Object[])new Object[0]);
            }
            return null;
        }
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_RSA);
        PublicKey publicKey = clientConfig.getPublicKey();
        if (publicKey != null) {
            cipher.init(1, publicKey);
            byte[] encryptedBytes = this.getBytes(cipher, accessToken.getBytes(StandardCharsets.UTF_8), 53);
            encryptedAccessToken = this.encodingUtils.bytesToHexString(encryptedBytes);
        }
        return encryptedAccessToken;
    }

    @Trivial
    protected String rsaDecrypt(SocialLoginConfig clientConfig, @Sensitive String encryptedToken) throws Exception {
        if (encryptedToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Encrypted token is null", (Object[])new Object[0]);
            }
            return null;
        }
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_RSA);
        PrivateKey privateKey = clientConfig.getPrivateKey();
        cipher.init(2, privateKey);
        byte[] decryptedBytes = this.getBytes(cipher, this.hexStringToBytes(encryptedToken), 64);
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    @Trivial
    protected byte[] getBytes(Cipher cipher, byte[] inputBytes, int algMaxInputLength) throws Exception {
        if (inputBytes == null) {
            return null;
        }
        if (algMaxInputLength <= 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Algorithm output offset length was not positive", (Object[])new Object[0]);
            }
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int remaining = inputBytes.length;
        int inputLen = algMaxInputLength;
        int i = 0;
        while (i < inputBytes.length) {
            byte[] part;
            if (remaining < inputLen) {
                inputLen = remaining;
            }
            if ((part = cipher.doFinal(inputBytes, i, inputLen)) != null) {
                baos.write(part);
            }
            i += inputLen;
            remaining -= inputLen;
        }
        return baos.toByteArray();
    }

    @Trivial
    protected String aesEncrypt(SocialLoginConfig clientConfig, @Sensitive String accessToken) throws Exception {
        String encryptedAccessToken = null;
        if (accessToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Access token is null", (Object[])new Object[0]);
            }
            return null;
        }
        Key secretKey = this.getSecretKey(clientConfig);
        if (secretKey != null) {
            IvParameterSpec ivSpec = this.getIvSpec(clientConfig);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION_AES);
            cipher.init(1, secretKey, ivSpec);
            byte[] encryptedBytes = cipher.doFinal(accessToken.getBytes(StandardCharsets.UTF_8));
            encryptedAccessToken = this.encodingUtils.bytesToHexString(encryptedBytes);
        }
        return encryptedAccessToken;
    }

    @Trivial
    protected String aesDecrypt(SocialLoginConfig clientConfig, String encryptedToken) throws Exception {
        if (encryptedToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Encrypted token is null", (Object[])new Object[0]);
            }
            return null;
        }
        Key secretKey = this.getSecretKey(clientConfig);
        IvParameterSpec ivSpec = this.getIvSpec(clientConfig);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_AES);
        cipher.init(2, secretKey, ivSpec);
        byte[] decryptedBytes = cipher.doFinal(this.hexStringToBytes(encryptedToken));
        return new String(decryptedBytes, StandardCharsets.UTF_8);
    }

    Key getSecretKey(SocialLoginConfig config) throws Exception {
        byte[] clientSecretHash = this.getClientSecretHash(config.getClientSecret());
        return AESKeyManager.getKey((AESKeyManager.KeyVersion)this.getAesKeyVersion(), (String)this.encodingUtils.bytesToHexString(clientSecretHash));
    }

    IvParameterSpec getIvSpec(SocialLoginConfig config) throws Exception {
        byte[] clientSecretHash = this.getClientSecretHash(config.getClientSecret());
        return AESKeyManager.getIV((AESKeyManager.KeyVersion)this.getAesKeyVersion(), (String)this.encodingUtils.bytesToHexString(clientSecretHash));
    }

    AESKeyManager.KeyVersion getAesKeyVersion() {
        return CryptoUtils.isFips140_3Enabled() ? AESKeyManager.KeyVersion.AES_V1 : AESKeyManager.KeyVersion.AES_V0;
    }

    byte[] getClientSecretHash(@Sensitive String clientSecret) {
        if (clientSecret == null) {
            return null;
        }
        MessageDigest md = this.getMessageDigest("SHA-256");
        if (md == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The secret key and initialization vector couldn't be initialized because a MessageDigest could not be created", (Object[])new Object[0]);
            }
            return null;
        }
        return md.digest(clientSecret.getBytes(StandardCharsets.UTF_8));
    }

    @FFDCIgnore(value={Exception.class})
    MessageDigest getMessageDigest(String algorithm) {
        MessageDigest md;
        block2: {
            md = null;
            try {
                md = MessageDigest.getInstance(algorithm);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("A MessageDigest object failed to be acquired: " + e), (Object[])new Object[0]);
            }
        }
        return md;
    }

    @Trivial
    protected String bytesToHexString(byte[] bytes) {
        return this.encodingUtils.bytesToHexString(bytes);
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    protected byte[] hexStringToBytes(String string) throws SocialLoginException {
        try {
            return this.encodingUtils.hexStringToBytes(string);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.security.social.tai.TAIEncryptionUtils", (String)"288", (Object)this, (Object[])new Object[]{string});
            throw new SocialLoginException("VALUE_NOT_HEXADECIMAL", (Exception)e, new Object[0]);
        }
    }
}

