/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl;
import java.util.Arrays;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(name="com.ibm.ws.security.social.linkedin", configurationPolicy=ConfigurationPolicy.REQUIRE, immediate=true, service={SocialLoginConfig.class}, property={"service.vendor=IBM", "type=linkedinLogin"})
public class LinkedinLoginConfigImpl
extends Oauth2LoginConfigImpl {
    public static final TraceComponent tc = Tr.register(LinkedinLoginConfigImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    static final long serialVersionUID = -3481064978103367164L;

    @Override
    protected void checkForRequiredConfigAttributes(Map<String, Object> props) {
        this.getRequiredConfigAttribute(props, "clientId");
        this.getRequiredSerializableProtectedStringConfigAttribute(props, "clientSecret");
    }

    @Override
    protected void setAllConfigAttributes(Map<String, Object> props) throws SocialLoginException {
        this.clientId = this.configUtils.getConfigAttribute(props, "clientId");
        this.clientSecret = this.configUtils.processProtectedString(props, "clientSecret");
        this.useSystemPropertiesForHttpClientConnections = this.configUtils.getBooleanConfigAttribute(props, "useSystemPropertiesForHttpClientConnections", false);
        this.authorizationEndpoint = this.configUtils.getConfigAttribute(props, "authorizationEndpoint");
        this.tokenEndpoint = this.configUtils.getConfigAttribute(props, "tokenEndpoint");
        this.userApi = this.configUtils.getConfigAttribute(props, "userApi");
        this.scope = this.configUtils.getConfigAttribute(props, "scope");
        this.userNameAttribute = this.configUtils.getConfigAttribute(props, "userNameAttribute");
        this.mapToUserRegistry = this.configUtils.getBooleanConfigAttribute(props, "mapToUserRegistry", this.mapToUserRegistry);
        this.sslRef = this.configUtils.getConfigAttribute(props, "sslRef");
        this.authFilterRef = this.configUtils.getConfigAttribute(props, "authFilterRef");
        this.isClientSideRedirectSupported = this.configUtils.getBooleanConfigAttribute(props, "isClientSideRedirectSupported", this.isClientSideRedirectSupported);
        this.displayName = this.configUtils.getConfigAttribute(props, "displayName");
        this.website = this.configUtils.getConfigAttribute(props, "website");
        this.tokenEndpointAuthMethod = this.configUtils.getConfigAttribute(props, "tokenEndpointAuthMethod");
        this.userApiNeedsSpecialHeader = this.configUtils.getBooleanConfigAttribute(props, "userApiNeedsSpecialHeader", this.userApiNeedsSpecialHeader);
        this.redirectToRPHostAndPort = this.configUtils.getConfigAttribute(props, "redirectToRPHostAndPort");
    }

    @Override
    protected void resetLazyInitializedMembers() {
        super.resetLazyInitializedMembers();
        this.responseType = "code";
    }

    @Override
    protected void debug() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("" + this), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientId = " + this.clientId), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("clientSecret is null = " + (this.clientSecret == null)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authorizationEndpoint = " + this.authorizationEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpoint = " + this.tokenEndpoint), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userApi = " + this.userApi), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userApiConfigs = " + (this.userApiConfigs == null ? "null" : Integer.valueOf(this.userApiConfigs.length))), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("scope = " + this.scope), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userNameAttribute = " + this.userNameAttribute), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("mapToUserRegistry = " + this.mapToUserRegistry), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("sslRef = " + this.sslRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef = " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("builder = " + this.jwtRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("claims = " + (this.jwtClaims == null ? null : Arrays.toString(this.jwtClaims))), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("isClientSideRedirectSupported = " + this.isClientSideRedirectSupported), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("displayName = " + this.displayName), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("website = " + this.website), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("tokenEndpointAuthMethod = " + this.tokenEndpointAuthMethod), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("userApiNeedsSpecialHeader = " + this.userApiNeedsSpecialHeader), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("redirectToRPHostAndPort = " + this.redirectToRPHostAndPort), (Object[])new Object[0]);
        }
    }
}

