/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.DeprecationSupport;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HTTPRequestValidationHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPRequestValidationHandler.class);
    @Nullable
    private String requiredContentType;
    @Nullable
    private String requiredRequestMethod;
    private boolean requireSecured;
    @NonnullAfterInit
    private Supplier<HttpServletRequest> httpServletRequestSupplier;

    public String getRequiredContentType() {
        return this.requiredContentType;
    }

    public void setRequiredContentType(String contentType) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requiredContentType = contentType;
    }

    public String getRequiredRequestMethod() {
        return this.requiredRequestMethod;
    }

    public void setRequiredRequestMethod(String requestMethod) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requiredRequestMethod = StringSupport.trimOrNull((String)requestMethod);
    }

    public boolean isRequireSecured() {
        return this.requireSecured;
    }

    public void setRequireSecured(boolean secured) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requireSecured = secured;
    }

    @NonnullAfterInit
    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequestSupplier == null ? null : this.httpServletRequestSupplier.get();
    }

    public void setHttpServletRequest(HttpServletRequest request) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        DeprecationSupport.warnOnce((DeprecationSupport.ObjectType)DeprecationSupport.ObjectType.METHOD, (String)"setHttpServletRequest", null, (String)"setHttpServletRequestSupplier");
        this.httpServletRequestSupplier = NonnullSupplier.of((Object)Constraint.isNotNull((Object)request, (String)"HttpServletRequest may not be null"));
    }

    public void setHttpServletRequestSupplier(Supplier<HttpServletRequest> requestSupplier) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpServletRequestSupplier = (Supplier)Constraint.isNotNull(requestSupplier, (String)"HttpServletRequest may not be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        Constraint.isNotNull((Object)this.getHttpServletRequest(), (String)"HttpServletRequest may not be null");
    }

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        this.evaluateContentType(this.getHttpServletRequest());
        this.evaluateRequestMethod(this.getHttpServletRequest());
        this.evaluateSecured(this.getHttpServletRequest());
    }

    protected void evaluateContentType(HttpServletRequest request) throws MessageHandlerException {
        String transportContentType = request.getHeader("Content-Type");
        if (this.getRequiredContentType() != null && !transportContentType.startsWith(this.getRequiredContentType())) {
            this.log.error("Invalid content type, expected '{}' but was '{}'", (Object)this.getRequiredContentType(), (Object)transportContentType);
            throw new MessageHandlerException("Invalid content type, expected " + this.getRequiredContentType() + " but was " + transportContentType);
        }
    }

    protected void evaluateRequestMethod(HttpServletRequest request) throws MessageHandlerException {
        String transportMethod = request.getMethod();
        if (this.getRequiredRequestMethod() != null && !transportMethod.equalsIgnoreCase(this.getRequiredRequestMethod())) {
            this.log.error("Invalid request method, expected '{}' but was '{}'", (Object)this.getRequiredRequestMethod(), (Object)transportMethod);
            throw new MessageHandlerException("Invalid request method, expected " + this.getRequiredRequestMethod() + " but was " + transportMethod);
        }
    }

    protected void evaluateSecured(HttpServletRequest request) throws MessageHandlerException {
        if (this.isRequireSecured() && !request.isSecure()) {
            this.log.error("Request was required to be secured but was not");
            throw new MessageHandlerException("Request was required to be secured but was not");
        }
    }
}

