/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.http.netty.inbound.NettyTCPConnectionContext;
import com.ibm.ws.netty.upgrade.NettyServletUpgradeHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.HandshakeProcessor;
import com.ibm.ws.wsoc.ParametersOfInterest;
import com.ibm.ws.wsoc.WebSocketContainerManager;
import com.ibm.ws.wsoc.external.HandshakeResponseExt;
import com.ibm.ws.wsoc.outbound.ClientTransportAccess;
import com.ibm.ws.wsoc.outbound.HttpRequestor;
import com.ibm.ws.wsoc.outbound.NettyOutboundConnectionLink;
import com.ibm.ws.wsoc.outbound.WsocAddress;
import com.ibm.ws.wsoc.outbound.WsocOutboundChain;
import com.ibm.ws.wsoc.util.Utils;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.genericbnf.exception.MessageSentException;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.ssl.SslHandler;
import io.openliberty.http.options.HttpOption;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.exception.NettyException;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NettyHttpRequestorWsoc10
implements HttpRequestor {
    private static final TraceComponent tc = Tr.register(NettyHttpRequestorWsoc10.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    protected ClientTransportAccess access = null;
    protected WsocAddress endpointAddress = null;
    protected Channel connection;
    protected BootstrapExtended factory;
    private String websocketKey = "";
    private final Map<String, List<String>> requestHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> responseHeaders = null;
    protected final ClientEndpointConfig config;
    private ChannelPromise responsePromise;
    private CountDownLatch activeChannelLatch;
    private FullHttpResponse resp;
    private final ParametersOfInterest things;
    private final Map<String, List<String>> parameterMap = new HashMap<String, List<String>>();
    protected Map<String, Object> httpOptions;
    static final long serialVersionUID = 3371604420227880901L;

    public NettyHttpRequestorWsoc10(WsocAddress endpointAddress, ClientEndpointConfig config, ParametersOfInterest things) {
        this.endpointAddress = endpointAddress;
        this.config = config;
        this.things = things;
        this.httpOptions = WsocOutboundChain.getCurrentHttpOptions();
    }

    @Override
    public ClientTransportAccess getClientTransportAccess() {
        return this.access;
    }

    @Override
    public void connect() throws Exception {
        this.access = new ClientTransportAccess();
        this.factory = WsocOutboundChain.getBootstrap(this.endpointAddress);
        this.startConnection();
    }

    private void startConnection() throws InterruptedException, ExecutionException, NettyException, TimeoutException {
        InetSocketAddress remoteAddress = this.endpointAddress.getRemoteAddress();
        String host = remoteAddress.getHostString();
        int port = remoteAddress.getPort();
        this.factory.handler((ChannelHandler)new WsocClientInitializer(this.factory.getBaseInitializer(), this));
        this.activeChannelLatch = new CountDownLatch(1);
        AtomicBoolean connectSucceded = new AtomicBoolean(true);
        this.connection = WsocOutboundChain.getNettyFramework().startOutbound(this.factory, host, port, future -> {
            if (!future.isSuccess()) {
                connectSucceded.set(false);
            }
            this.activeChannelLatch.countDown();
        });
        this.responsePromise = this.connection.newPromise();
        this.activeChannelLatch.await((Long)HttpOption.READ_TIMEOUT.parse(this.httpOptions), TimeUnit.SECONDS);
        if (!connectSucceded.get()) {
            throw new NettyException("Unable to connect to the specified endpoint!");
        }
    }

    @Override
    public void sendRequest() throws IOException, MessageSentException {
        this.sendRequest(null);
    }

    @Override
    public void sendRequest(ParametersOfInterest poi) throws IOException, MessageSentException {
        this.access.setTCPConnectionContext((TCPConnectionContext)new NettyTCPConnectionContext(this.connection, null));
        this.access.setDeviceConnLink(new NettyOutboundConnectionLink(this.connection));
        String uriPath = this.endpointAddress.getURI().getPath();
        String queryString = this.endpointAddress.getURI().getQuery();
        String finalUri = uriPath + (queryString != null && !queryString.isEmpty() ? "?" + queryString : "");
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, finalUri);
        HttpUtil.setContentLength((HttpMessage)request, (long)0L);
        request.headers().set(HttpHeaderKeys.HDR_HOST.getName(), (Object)(this.endpointAddress.getURI().getHost() + ":" + this.endpointAddress.getURI().getPort()));
        HttpHeaders nettyRequestHeaders = request.headers();
        this.requestHeaders.put(HttpHeaderKeys.HDR_CONNECTION.getName(), Arrays.asList("Upgrade"));
        this.requestHeaders.put(HttpHeaderKeys.HDR_UPGRADE.getName(), Arrays.asList("websocket"));
        this.requestHeaders.put("Sec-WebSocket-Version", Arrays.asList("13"));
        this.websocketKey = WebSocketContainerManager.getRef().generateWebsocketKey();
        this.requestHeaders.put("Sec-WebSocket-Key", Arrays.asList(this.websocketKey));
        if (this.config != null) {
            List extensions;
            List subprotocols = this.config.getPreferredSubprotocols();
            if (subprotocols != null && subprotocols.size() > 0) {
                String subprotocolValue = "";
                for (int x = 0; x < subprotocols.size(); ++x) {
                    subprotocolValue = x == 0 ? ((String)subprotocols.get(0)).trim() : subprotocolValue + "," + ((String)subprotocols.get(x)).trim();
                }
                this.requestHeaders.put("Sec-WebSocket-Protocol", Arrays.asList(subprotocolValue));
            }
            if ((extensions = this.config.getExtensions()) != null && extensions.size() > 0) {
                StringBuffer buf = new StringBuffer();
                boolean first = true;
                for (Extension ext : extensions) {
                    if (first) {
                        first = false;
                    } else {
                        buf.append(", ");
                    }
                    buf.append(ext.getName());
                    List li = ext.getParameters();
                    if (li == null || li.size() <= 0) continue;
                    for (Extension.Parameter p : li) {
                        buf.append("; " + p.getName() + "=" + p.getValue());
                    }
                }
                this.requestHeaders.put("Sec-WebSocket-Extensions", Arrays.asList(buf.toString()));
            }
            if (this.config.getConfigurator() != null) {
                this.config.getConfigurator().beforeRequest(this.requestHeaders);
            }
        }
        for (Map.Entry<String, List<String>> entry : this.requestHeaders.entrySet()) {
            List<String> list = entry.getValue();
            if (list == null) {
                nettyRequestHeaders.set(entry.getKey(), (Object)"");
                continue;
            }
            if (list.size() == 0) {
                nettyRequestHeaders.set(entry.getKey(), (Object)"");
            }
            nettyRequestHeaders.add(entry.getKey(), list);
        }
        this.connection.writeAndFlush((Object)request);
        if (poi != null) {
            Tr.debug((TraceComponent)tc, (String)("set query parms to " + this.endpointAddress.getURI().getQuery()), (Object[])new Object[0]);
            if (Objects.nonNull(queryString) && !queryString.isEmpty()) {
                poi.setQueryString(this.endpointAddress.getURI().getQuery());
            }
            QueryStringDecoder query = new QueryStringDecoder(this.endpointAddress.getURI());
            for (Map.Entry entry : query.parameters().entrySet()) {
                this.parameterMap.put((String)entry.getKey(), (List)entry.getValue());
            }
            poi.setParameterMap(this.parameterMap);
            Tr.debug((TraceComponent)tc, (String)("set ParameterMap " + this.parameterMap), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WsByteBuffer completeResponse() throws IOException {
        String acceptKey;
        try {
            this.responsePromise.get(((Long)HttpOption.READ_TIMEOUT.parse(this.httpOptions)).longValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            void e1;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.wsoc.outbound.NettyHttpRequestorWsoc10", (String)"268", (Object)this, (Object[])new Object[0]);
            throw new SocketTimeoutException(e1.getMessage());
        }
        if (this.resp == null) {
            throw new IOException("Don't have a response yet!");
        }
        if (StatusCodes.SWITCHING_PROTOCOLS.getIntCode() != this.resp.status().code()) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.returncode", (Object[])new Object[]{this.resp.status().code(), this.endpointAddress.getURI().toString()});
            Tr.error((TraceComponent)tc, (String)"client.invalid.returncode", (Object[])new Object[]{this.resp.status().code(), this.endpointAddress.getURI().toString()});
            throw new IOException(msg);
        }
        try {
            acceptKey = Utils.makeAcceptResponseHeaderValue(this.websocketKey);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            void e;
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.wsoc.outbound.NettyHttpRequestorWsoc10", (String)"287", (Object)this, (Object[])new Object[0]);
            throw new IOException((Throwable)e);
        }
        String key = this.resp.headers().get("Sec-WebSocket-Accept");
        if (key != null) {
            if (!key.equals(acceptKey)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.acceptkey", (Object[])new Object[]{this.resp.status().code(), this.endpointAddress.getURI().toString()});
                Tr.error((TraceComponent)tc, (String)"client.invalid.acceptkey", (Object[])new Object[]{this.resp.status().code(), this.endpointAddress.getURI().toString()});
                throw new IOException(msg);
            }
        } else {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"client.invalid.acceptkey", (Object[])new Object[]{this.resp.status().code(), this.endpointAddress.getURI().toString()});
            Tr.error((TraceComponent)tc, (String)"client.invalid.acceptkey", (Object[])new Object[]{this.resp.status().code(), this.endpointAddress.getURI().toString()});
            throw new IOException(msg);
        }
        if (this.config != null) {
            Set names = this.resp.headers().names();
            this.responseHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            for (String name : names) {
                List values = this.resp.headers().getAll(name);
                if (name.equalsIgnoreCase("Sec-WebSocket-Protocol") && values != null && values.size() >= 1) {
                    this.things.setAgreedSubProtocol((String)values.get(0));
                }
                if (name.equalsIgnoreCase("Sec-WebSocket-Extensions") && values != null && values.size() >= 1) {
                    this.things.setNegotiatedExtensions(HandshakeProcessor.parseClientExtensions(values));
                }
                this.responseHeaders.put(name, values);
            }
            if (this.config.getConfigurator() != null) {
                HandshakeResponseExt handshakeResponse = new HandshakeResponseExt(this.responseHeaders);
                this.config.getConfigurator().afterResponse((HandshakeResponse)handshakeResponse);
            }
        }
        this.things.setURI(this.endpointAddress.getURI());
        if (this.config != null) {
            this.things.setLocalSubProtocols(this.config.getPreferredSubprotocols());
        }
        this.things.setWsocProtocolVersion("13");
        this.things.setSecure(this.endpointAddress.isSecure());
        return null;
    }

    private void updatePipelineToWebsocket() {
        NettyServletUpgradeHandler upgradeHandler = new NettyServletUpgradeHandler(this.connection);
        HttpClientCodec httpHandler = (HttpClientCodec)this.connection.pipeline().get(HttpClientCodec.class);
        if (Objects.isNull(httpHandler)) {
            throw new UnsupportedOperationException("Found Null Http Codec!");
        }
        this.connection.pipeline().addLast("ServletUpgradeHandler", (ChannelHandler)upgradeHandler);
        this.connection.pipeline().remove(HttpClientCodec.class);
        this.connection.pipeline().remove(HttpObjectAggregator.class);
    }

    @Override
    public void closeConnection(IOException ioe) {
        if (Objects.nonNull(this.connection)) {
            this.connection.close();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class WsocClientInitializer
    extends ChannelInitializerWrapper {
        final ChannelInitializerWrapper parent;
        final NettyHttpRequestorWsoc10 requestor;
        static final long serialVersionUID = -7029470112093309316L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WsocClientInitializer(ChannelInitializerWrapper parent, NettyHttpRequestorWsoc10 requestor) {
            this.parent = parent;
            this.requestor = requestor;
        }

        @ManualTrace
        protected void initChannel(Channel ch) throws Exception {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"initChannel: Constructing pipeline", (Object[])new Object[0]);
            }
            this.parent.init(ch);
            ChannelPipeline pipeline = ch.pipeline();
            if (this.requestor.endpointAddress.isSecure()) {
                SslHandler handler;
                Object engine = null;
                if (Objects.isNull(engine) && (WsocOutboundChain.getCurrentSslOptions() == null || WsocOutboundChain.getNettyTlsProvider() == null)) {
                    throw new IllegalStateException("Secure address requested but no SSL Options configured");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)ch, (TraceComponent)tc, (String)"initChannel", (Object[])new Object[]{"Adding SSL Support"});
                }
                InetSocketAddress remoteAddress = this.requestor.endpointAddress.getRemoteAddress();
                String host = remoteAddress.getHostString();
                int port = remoteAddress.getPort();
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Create SSL", (Object[])new Object[]{WsocOutboundChain.getNettyTlsProvider(), host, port, WsocOutboundChain.getCurrentSslOptions()});
                }
                if ((handler = WsocOutboundChain.getNettyTlsProvider().getOutboundSSLContext(WsocOutboundChain.getCurrentSslOptions(), host, Integer.toString(port), ch)) == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry((Object)((Object)this), (TraceComponent)tc, (String)"initChannel", (Object[])new Object[]{"Error adding TLS Support"});
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((Object)((Object)this), (TraceComponent)tc, (String)"initChannel");
                    }
                    ch.close();
                    return;
                }
                pipeline.addFirst("SSLHandler", (ChannelHandler)handler);
            }
            ch.attr(NettyHttpConstants.PROTOCOL).set((Object)"WebSocket");
            ch.attr(NettyHttpConstants.IS_OUTBOUND_KEY).set((Object)true);
            pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
            pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<FullHttpResponse>(){
                static final long serialVersionUID = 467462298032407477L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse res) throws Exception {
                    WsocClientInitializer.this.requestor.resp = res;
                    ctx.pipeline().remove((ChannelHandler)this);
                    WsocClientInitializer.this.requestor.updatePipelineToWebsocket();
                    WsocClientInitializer.this.requestor.responsePromise.setSuccess();
                }

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    ctx.fireChannelActive();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.outbound.NettyHttpRequestorWsoc10$WsocClientInitializer$1", 1.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
                }
            }});
            pipeline.remove("inactivityTimeoutHandler");
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.outbound.NettyHttpRequestorWsoc10$WsocClientInitializer", WsocClientInitializer.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
        }
    }
}

