/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.entity.NHttpEntityWrapper;
import org.apache.http.nio.entity.ProducingNHttpEntity;
import org.apache.http.nio.protocol.AsyncNHttpClientHandler;
import org.apache.http.nio.protocol.NHttpHandlerBase;
import org.apache.http.nio.protocol.NHttpRequestExecutionHandler;
import org.apache.http.nio.protocol.NullNHttpEntity;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.HeapByteBufferAllocator;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class AsyncNHttpClientHandler
extends NHttpHandlerBase
implements NHttpClientHandler {
    protected NHttpRequestExecutionHandler execHandler;

    public AsyncNHttpClientHandler(HttpProcessor httpProcessor, NHttpRequestExecutionHandler execHandler, ConnectionReuseStrategy connStrategy, ByteBufferAllocator allocator, HttpParams params) {
        super(httpProcessor, connStrategy, allocator, params);
        this.execHandler = (NHttpRequestExecutionHandler)Args.notNull((Object)execHandler, (String)"HTTP request execution handler");
    }

    public AsyncNHttpClientHandler(HttpProcessor httpProcessor, NHttpRequestExecutionHandler execHandler, ConnectionReuseStrategy connStrategy, HttpParams params) {
        this(httpProcessor, execHandler, connStrategy, (ByteBufferAllocator)HeapByteBufferAllocator.INSTANCE, params);
    }

    public void connected(NHttpClientConnection conn, Object attachment) {
        HttpContext context = conn.getContext();
        this.initialize(conn, attachment);
        ClientConnState connState = new ClientConnState();
        context.setAttribute("http.nio.conn-state", (Object)connState);
        if (this.eventListener != null) {
            this.eventListener.connectionOpen((NHttpConnection)conn);
        }
        this.requestReady(conn);
    }

    public void closed(NHttpClientConnection conn) {
        HttpContext context;
        block3: {
            context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            try {
                connState.reset();
            }
            catch (IOException ex) {
                if (this.eventListener == null) break block3;
                this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
            }
        }
        this.execHandler.finalizeContext(context);
        if (this.eventListener != null) {
            this.eventListener.connectionClosed((NHttpConnection)conn);
        }
    }

    public void exception(NHttpClientConnection conn, HttpException ex) {
        this.closeConnection((NHttpConnection)conn, (Throwable)ex);
        if (this.eventListener != null) {
            this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
        }
    }

    public void exception(NHttpClientConnection conn, IOException ex) {
        this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
        if (this.eventListener != null) {
            this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
        }
    }

    public void requestReady(NHttpClientConnection conn) {
        block13: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            if (connState.getOutputState() != 0) {
                return;
            }
            try {
                HttpRequest request = this.execHandler.submitRequest(context);
                if (request == null) {
                    return;
                }
                request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.params));
                context.setAttribute("http.request", (Object)request);
                this.httpProcessor.process(request, context);
                HttpEntityEnclosingRequest entityReq = null;
                HttpEntity entity = null;
                if (request instanceof HttpEntityEnclosingRequest) {
                    entityReq = (HttpEntityEnclosingRequest)request;
                    entity = entityReq.getEntity();
                }
                if (entity instanceof ProducingNHttpEntity) {
                    connState.setProducingEntity((ProducingNHttpEntity)entity);
                } else if (entity != null) {
                    connState.setProducingEntity((ProducingNHttpEntity)new NHttpEntityWrapper(entity));
                }
                connState.setRequest(request);
                conn.submitRequest(request);
                connState.setOutputState(1);
                if (entityReq != null && entityReq.expectContinue()) {
                    int timeout = conn.getSocketTimeout();
                    connState.setTimeout(timeout);
                    timeout = this.params.getIntParameter("http.protocol.wait-for-continue", 3000);
                    conn.setSocketTimeout(timeout);
                    connState.setOutputState(2);
                } else if (connState.getProducingEntity() != null) {
                    connState.setOutputState(4);
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
                }
            }
            catch (HttpException ex) {
                this.closeConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block13;
                this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
            }
        }
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        block5: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            ConsumingNHttpEntity consumingEntity = connState.getConsumingEntity();
            try {
                consumingEntity.consumeContent(decoder, (IOControl)conn);
                if (decoder.isCompleted()) {
                    this.processResponse(conn, connState);
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
                }
            }
            catch (HttpException ex) {
                this.closeConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block5;
                this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
            }
        }
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        block4: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            try {
                if (connState.getOutputState() == 2) {
                    conn.suspendOutput();
                    return;
                }
                ProducingNHttpEntity entity = connState.getProducingEntity();
                entity.produceContent(encoder, (IOControl)conn);
                if (encoder.isCompleted()) {
                    connState.setOutputState(8);
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block4;
                this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
            }
        }
    }

    public void responseReceived(NHttpClientConnection conn) {
        block13: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            HttpResponse response = conn.getHttpResponse();
            response.setParams((HttpParams)new DefaultedHttpParams(response.getParams(), this.params));
            HttpRequest request = connState.getRequest();
            try {
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 200) {
                    if (statusCode == 100 && connState.getOutputState() == 2) {
                        this.continueRequest(conn, connState);
                    }
                    return;
                }
                connState.setResponse(response);
                if (connState.getOutputState() == 2) {
                    this.cancelRequest(conn, connState);
                } else if (connState.getOutputState() == 4) {
                    this.cancelRequest(conn, connState);
                    connState.invalidate();
                    conn.suspendOutput();
                }
                context.setAttribute("http.response", (Object)response);
                if (!this.canResponseHaveBody(request, response)) {
                    conn.resetInput();
                    response.setEntity(null);
                    this.httpProcessor.process(response, context);
                    this.processResponse(conn, connState);
                } else {
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        ConsumingNHttpEntity consumingEntity = this.execHandler.responseEntity(response, context);
                        if (consumingEntity == null) {
                            consumingEntity = new NullNHttpEntity(entity);
                        }
                        response.setEntity((HttpEntity)consumingEntity);
                        connState.setConsumingEntity(consumingEntity);
                        this.httpProcessor.process(response, context);
                    }
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
                }
            }
            catch (HttpException ex) {
                this.closeConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block13;
                this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
            }
        }
    }

    public void timeout(NHttpClientConnection conn) {
        block3: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            try {
                if (connState.getOutputState() == 2) {
                    this.continueRequest(conn, connState);
                    return;
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block3;
                this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
            }
        }
        this.handleTimeout((NHttpConnection)conn);
    }

    private void initialize(NHttpClientConnection conn, Object attachment) {
        HttpContext context = conn.getContext();
        context.setAttribute("http.connection", (Object)conn);
        this.execHandler.initalizeContext(context, attachment);
    }

    private void continueRequest(NHttpClientConnection conn, ClientConnState connState) throws IOException {
        int timeout = connState.getTimeout();
        conn.setSocketTimeout(timeout);
        conn.requestOutput();
        connState.setOutputState(4);
    }

    private void cancelRequest(NHttpClientConnection conn, ClientConnState connState) throws IOException {
        int timeout = connState.getTimeout();
        conn.setSocketTimeout(timeout);
        conn.resetOutput();
        connState.resetOutput();
    }

    private void processResponse(NHttpClientConnection conn, ClientConnState connState) throws IOException, HttpException {
        if (!connState.isValid()) {
            conn.close();
        }
        HttpContext context = conn.getContext();
        HttpResponse response = connState.getResponse();
        this.execHandler.handleResponse(response, context);
        if (!this.connStrategy.keepAlive(response, context)) {
            conn.close();
        }
        if (conn.isOpen()) {
            connState.resetInput();
            connState.resetOutput();
            conn.requestOutput();
        }
    }
}

