/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.coordinator.domain.model;

import com.arjuna.ats.arjuna.AtomicAction;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.RecordList;
import com.arjuna.ats.arjuna.coordinator.RecordListIterator;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;
import io.narayana.lra.coordinator.domain.model.LRAData;
import io.narayana.lra.coordinator.domain.model.LRARecord;
import io.narayana.lra.coordinator.domain.model.Transaction;
import io.narayana.lra.coordinator.domain.service.LRAService;
import io.narayana.lra.logging.LRALogger;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.lra.annotation.LRAStatus;

public class Transaction
extends AtomicAction {
    private static final String LRA_TYPE = "/StateManager/BasicAction/TwoPhaseCoordinator/LRA";
    private final ScheduledExecutorService scheduler;
    private URI id;
    private URI parentId;
    private String clientId;
    private List<LRARecord> pending;
    private LRAStatus status;
    private String responseData;
    private LocalDateTime startTime;
    private LocalDateTime finishTime;
    private ScheduledFuture<?> scheduledAbort;
    private boolean inFlight;
    private LRAService lraService;
    private String uid;

    public Transaction(LRAService lraService, String baseUrl, URI parentId, String clientId) throws URISyntaxException {
        super(new Uid());
        this.uid = this.get_uid().fileStringForm();
        this.lraService = lraService;
        this.id = new URI(String.format("%s/%s", baseUrl, this.get_uid().fileStringForm()));
        this.inFlight = true;
        this.parentId = parentId;
        this.clientId = clientId;
        this.finishTime = null;
        this.status = LRAStatus.Active;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public Transaction(LRAService lraService, Uid rcvUid) {
        super(rcvUid);
        this.uid = rcvUid.fileStringForm();
        this.lraService = lraService;
        this.inFlight = false;
        this.id = null;
        this.parentId = null;
        this.clientId = null;
        this.finishTime = null;
        this.status = LRAStatus.Active;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public LRAData getLRAData() {
        return new LRAData(this.id.toASCIIString(), this.clientId, this.status == null ? "" : this.status.name(), this.isClosed(), this.isCancelled(), this.isRecovering(), this.isActive().booleanValue(), this.isTopLevel(), this.startTime.toInstant(ZoneOffset.UTC).toEpochMilli(), this.finishTime == null ? 0L : this.finishTime.toInstant(ZoneOffset.UTC).toEpochMilli());
    }

    public static String getType() {
        return LRA_TYPE;
    }

    public boolean save_state(OutputObjectState os, int ot) {
        if (!super.save_state(os, ot) || !this.save_list(os, ot, this.pendingList)) {
            return false;
        }
        try {
            os.packString(this.id == null ? null : this.id.toString());
            os.packString(this.parentId == null ? null : this.parentId.toString());
            os.packString(this.clientId);
            if (this.startTime == null) {
                os.packBoolean(false);
            } else {
                os.packBoolean(true);
                os.packLong(this.startTime.toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            if (this.finishTime == null) {
                os.packBoolean(false);
            } else {
                os.packBoolean(true);
                os.packLong(this.finishTime.toInstant(ZoneOffset.UTC).toEpochMilli());
            }
            if (this.status == null) {
                os.packBoolean(false);
            } else {
                os.packBoolean(true);
                os.packString(this.status.name());
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean save_list(OutputObjectState os, int ot, RecordList list) {
        if (list != null && list.size() > 0) {
            AbstractRecord temp;
            AbstractRecord first = temp = list.getFront();
            while (temp != null) {
                list.putRear(temp);
                if (!temp.doSave()) {
                    return false;
                }
                try {
                    os.packInt(temp.typeIs());
                    if (!temp.save_state(os, ot)) {
                        return false;
                    }
                }
                catch (IOException e) {
                    return false;
                }
                temp = list.getFront();
                if (temp != first) continue;
                list.putFront(temp);
                temp = null;
            }
        }
        try {
            os.packInt(463);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private boolean restore_list(InputObjectState os, int ot, RecordList list) {
        int record_type = 463;
        try {
            while ((record_type = os.unpackInt()) != 463) {
                AbstractRecord record = AbstractRecord.create((int)record_type);
                if (record == null || !record.restore_state(os, ot) || !list.insert(record)) {
                    return false;
                }
                if (!(record instanceof LRARecord)) continue;
                LRARecord lraRecord = (LRARecord)record;
                lraRecord.setLRAService(this.lraService);
                lraRecord.setLRA(this);
            }
        }
        catch (IOException | NullPointerException e1) {
            LRALogger.i18NLogger.warn_coordinatorNorecordfound(Integer.toString(record_type), (Throwable)e1);
            return false;
        }
        return true;
    }

    public boolean restore_state(InputObjectState os, int ot) {
        if (!super.restore_state(os, ot) || !this.restore_list(os, ot, this.pendingList)) {
            return false;
        }
        AbstractRecord rec = this.preparedList.peekFront();
        while (rec != null) {
            LRARecord p;
            if (rec instanceof LRARecord && (p = (LRARecord)rec).isFailed()) {
                boolean moveRec = true;
                this.preparedList.remove((AbstractRecord)p);
                AbstractRecord r = this.failedList.peekFront();
                while (r != null && !p.equals(r)) {
                    r = this.failedList.peekNext(r);
                }
                if (r == null) {
                    this.failedList.putFront((AbstractRecord)p);
                }
            }
            rec = this.preparedList.peekNext(rec);
        }
        this.uid = this.get_uid().fileStringForm();
        try {
            String s = os.unpackString();
            this.id = s == null ? null : new URI(s);
            s = os.unpackString();
            this.parentId = s == null ? null : new URI(s);
            this.clientId = os.unpackString();
            this.startTime = os.unpackBoolean() ? LocalDateTime.ofInstant(Instant.ofEpochMilli(os.unpackLong()), ZoneOffset.UTC) : null;
            this.finishTime = os.unpackBoolean() ? LocalDateTime.ofInstant(Instant.ofEpochMilli(os.unpackLong()), ZoneOffset.UTC) : null;
            LRAStatus lRAStatus = this.status = os.unpackBoolean() ? LRAStatus.valueOf((String)os.unpackString()) : null;
            if (this.finishTime != null) {
                long ttl = ChronoUnit.MILLIS.between(LocalDateTime.now(ZoneOffset.UTC), this.finishTime);
                if (ttl <= 0L) {
                    if (LRALogger.logger.isDebugEnabled()) {
                        LRALogger.logger.debugf("Timer for LRA '%s' has expired since last reload", (Object)this.id);
                    }
                    if (this.isActive().booleanValue()) {
                        this.status = LRAStatus.Cancelling;
                    }
                } else if (LRALogger.logger.isDebugEnabled()) {
                    LRALogger.logger.debugf("Restarting time for LRA '%s'", (Object)this.id);
                }
                this.setTimeLimit(Long.valueOf(ttl));
            }
            return true;
        }
        catch (IOException | URISyntaxException e) {
            if (LRALogger.logger.isDebugEnabled()) {
                LRALogger.logger.debugf((Throwable)e, "Cannot restore state of objec type '%s'", ot);
            }
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Transaction that = (Transaction)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getId().hashCode();
        return result;
    }

    public String type() {
        return LRA_TYPE;
    }

    public URI getId() {
        return this.id;
    }

    public String getClientId() {
        return this.clientId;
    }

    protected LRAService getLraService() {
        return this.lraService;
    }

    public LRAStatus getLRAStatus() {
        return this.status;
    }

    protected void setLRAStatus(int actionStatus) {
        this.status = this.toLRAStatus(actionStatus);
    }

    boolean isClosed() {
        return this.status != null && this.status.equals((Object)LRAStatus.Closed);
    }

    boolean isCancelled() {
        return this.status != null && this.status.equals((Object)LRAStatus.Cancelled);
    }

    public boolean isRecovering() {
        return this.status != null && (this.status.equals((Object)LRAStatus.Cancelling) || this.status.equals((Object)LRAStatus.Closing));
    }

    public boolean isFailed() {
        return this.status != null && (this.status.equals((Object)LRAStatus.FailedToCancel) || this.status.equals((Object)LRAStatus.FailedToClose));
    }

    public boolean isCancel() {
        switch (1.$SwitchMap$org$eclipse$microprofile$lra$annotation$LRAStatus[this.status.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    boolean isFinished() {
        switch (1.$SwitchMap$org$eclipse$microprofile$lra$annotation$LRAStatus[this.status.ordinal()]) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private int cancelLRA() {
        return this.end(true);
    }

    protected ReentrantLock tryLockTransaction() {
        return this.lraService.tryLockTransaction(this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int end(boolean cancel) {
        ReentrantLock lock = null;
        try {
            lock = this.lraService.tryLockTransaction(this.getId());
            if (lock == null) {
                if (LRALogger.logger.isInfoEnabled()) {
                    LRALogger.logger.debugf("Transaction.endLRA Some other thread is finishing LRA %s", (Object)this.getId().toASCIIString());
                }
                int n = this.status();
                return n;
            }
            if (this.status == LRAStatus.Cancelling) {
                int n = this.doEnd(true);
                return n;
            }
            int n = this.doEnd(cancel);
            return n;
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int doEnd(boolean cancel) {
        this.inFlight = false;
        int res = this.status();
        boolean nested = !this.isTopLevel();
        this.updateState(cancel ? LRAStatus.Cancelling : LRAStatus.Closing);
        if (this.scheduledAbort != null) {
            this.scheduledAbort.cancel(false);
            this.scheduledAbort = null;
        }
        this.savePendingList();
        if (res != 0 && res != 3) {
            if (nested) {
                if (cancel) {
                    this.pendingList = new RecordList();
                    this.preparedList = new RecordList();
                    this.failedList = new RecordList();
                    this.moveTo(this.pendingList, this.preparedList);
                    this.moveTo(this.heuristicList, this.preparedList);
                    this.updateState(LRAStatus.Cancelling);
                    super.phase2Commit(true);
                    res = this.status();
                    this.status = this.toLRAStatus(this.status());
                } else {
                    if (!this.forgetAllParticipants()) return 14;
                    this.updateState(LRAStatus.Closed);
                }
            }
        } else if (cancel || this.status() == 3) {
            this.preparedList = new RecordList();
            this.failedList = new RecordList();
            this.moveTo(this.pendingList, this.preparedList);
            this.moveTo(this.heuristicList, this.preparedList);
            this.updateState(LRAStatus.Cancelling);
            if (this.heuristicList == null) {
                this.heuristicList = new RecordList();
            }
            super.phase2Commit(true);
            res = super.status();
        } else {
            this.updateState(LRAStatus.Closing);
            res = super.End(true);
        }
        this.runPostLRAActions();
        if (this.pending != null && this.pending.size() != 0 && !nested) {
            this.pending.clear();
        }
        if (this.getSize(this.heuristicList) != 0) {
            this.status = cancel ? LRAStatus.Cancelling : LRAStatus.Closing;
        } else if (this.getSize(this.failedList) != 0) {
            this.status = cancel ? LRAStatus.FailedToCancel : LRAStatus.FailedToClose;
        } else if (this.getSize(this.pendingList) != 0 || this.getSize(this.preparedList) != 0) {
            this.status = LRAStatus.Closing;
        }
        if (!this.isRecovering() && this.lraService != null) {
            this.lraService.finished(this, false);
        }
        this.responseData = this.isActive() != false ? null : this.status.name();
        this.finishTime = LocalDateTime.now(ZoneOffset.UTC);
        this.deactivate();
        return res;
    }

    protected void runPostLRAActions() {
        if (this.isInEndState() && this.heuristicList != null && this.heuristicList.size() != 0) {
            if (this.preparedList == null) {
                this.preparedList = new RecordList();
            }
            this.moveTo(this.heuristicList, this.preparedList);
            this.checkParticipant(this.preparedList);
            super.phase2Commit(true);
        }
    }

    private boolean updateState(LRAStatus nextState) {
        this.status = nextState;
        return this.pendingList == null || this.pendingList.size() == 0 || this.deactivate();
    }

    protected void checkParticipant(RecordList participants) {
        AbstractRecord r;
        RecordListIterator i = new RecordListIterator(participants);
        while ((r = i.iterate()) != null) {
            if (!(r instanceof LRARecord)) continue;
            LRARecord rec = (LRARecord)r;
            rec.setLraService(this.getLraService());
            rec.setLRA(this);
        }
    }

    protected void moveTo(RecordList fromList, RecordList toList) {
        if (fromList != null) {
            AbstractRecord record;
            while ((record = fromList.getFront()) != null) {
                toList.putFront(record);
            }
        }
    }

    private boolean allFinished(RecordList ... lists) {
        for (RecordList list : lists) {
            AbstractRecord r;
            if (list == null) continue;
            RecordListIterator i = new RecordListIterator(list);
            while ((r = i.iterate()) != null) {
                LRARecord rec;
                if (!(r instanceof LRARecord) || (rec = (LRARecord)r).isFinished()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isInEndState() {
        if (this.status == LRAStatus.Cancelling && this.allFinished(new RecordList[]{this.heuristicList, this.failedList})) {
            this.status = this.failedList != null && this.failedList.size() == 0 ? LRAStatus.Cancelled : LRAStatus.FailedToCancel;
        } else if (this.status == LRAStatus.Closing && this.allFinished(new RecordList[]{this.heuristicList, this.failedList})) {
            this.status = this.failedList != null && this.failedList.size() == 0 ? LRAStatus.Closed : LRAStatus.FailedToClose;
        }
        return this.isFinished();
    }

    private int getSize(RecordList list) {
        return list == null ? 0 : list.size();
    }

    private LRAStatus toLRAStatus(int atomicActionStatus) {
        switch (atomicActionStatus) {
            case 2: 
            case 3: 
            case 6: {
                return this.status == LRAStatus.Cancelling ? LRAStatus.Cancelling : LRAStatus.Closing;
            }
            case 4: 
            case 11: {
                return this.status == LRAStatus.Cancelling ? LRAStatus.Cancelled : LRAStatus.Closed;
            }
            case 7: {
                return this.status == LRAStatus.Cancelling ? LRAStatus.Cancelled : LRAStatus.Closed;
            }
        }
        return LRAStatus.Active;
    }

    public LRARecord enlistParticipant(URI coordinatorUrl, String participantUrl, String recoveryUrlBase, long timeLimit, String compensatorData) throws UnsupportedEncodingException {
        LRARecord participant = this.findLRAParticipant(participantUrl, false);
        if (participant != null) {
            return participant;
        }
        participant = this.enlistParticipant(coordinatorUrl, participantUrl, recoveryUrlBase, null, timeLimit, compensatorData);
        if (participant != null) {
            this.deactivate();
            this.savedIntentionList = true;
        }
        return participant;
    }

    private LRARecord enlistParticipant(URI coordinatorUrl, String participantUrl, String recoveryUrlBase, String terminateUrl, long timeLimit, String compensatorData) throws UnsupportedEncodingException {
        LRARecord p = new LRARecord(this, this.lraService, coordinatorUrl.toASCIIString(), participantUrl, compensatorData);
        String pid = p.get_uid().fileStringForm();
        String txId = URLEncoder.encode(coordinatorUrl.toASCIIString(), "UTF-8");
        p.setRecoveryURI(recoveryUrlBase, txId, pid);
        if (this.add((AbstractRecord)p) != 3) {
            this.setTimeLimit(Long.valueOf(timeLimit));
            return p;
        }
        if (this.isRecovering() && p.getCompensator() == null && p.getEndNotificationUri() != null) {
            this.heuristicList.putRear((AbstractRecord)p);
            this.updateState();
            return p;
        }
        return null;
    }

    public Boolean isActive() {
        return this.status == null || this.status == LRAStatus.Active;
    }

    public boolean forgetParticipant(String participantUrl) {
        return this.findLRAParticipant(participantUrl, true) != null;
    }

    public boolean forgetAllParticipants() {
        if (this.pending == null) {
            return true;
        }
        this.pending.removeIf(LRARecord::forget);
        return this.pending.isEmpty();
    }

    private void savePendingList() {
        AbstractRecord r;
        if (this.pendingList == null) {
            this.savedIntentionList = true;
            return;
        }
        if (this.pending != null) {
            return;
        }
        RecordListIterator i = new RecordListIterator(this.pendingList);
        this.pending = new ArrayList();
        while ((r = i.iterate()) != null) {
            if (!(r instanceof LRARecord)) continue;
            this.pending.add((LRARecord)r);
        }
    }

    private LRARecord findLRAParticipant(String participantUrl, boolean remove) {
        LRARecord rec;
        try {
            URI recoveryUrl = new URI(LRARecord.cannonicalForm((String)participantUrl));
            rec = this.findLRAParticipantByRecoveryUrl(recoveryUrl, remove, new RecordList[]{this.pendingList, this.preparedList, this.heuristicList, this.failedList});
        }
        catch (URISyntaxException ignore) {
            String pUrl;
            try {
                pUrl = LRARecord.extractCompensator((URI)this.id, (String)participantUrl);
            }
            catch (URISyntaxException e) {
                return null;
            }
            rec = this.findLRAParticipant(pUrl, remove, new RecordList[]{this.pendingList, this.preparedList, this.heuristicList, this.failedList});
        }
        return rec;
    }

    private LRARecord findLRAParticipant(String participantUrl, boolean remove, RecordList ... lists) {
        for (RecordList list : lists) {
            AbstractRecord r;
            if (list == null) continue;
            RecordListIterator i = new RecordListIterator(list);
            if (participantUrl.indexOf(44) != -1) {
                try {
                    participantUrl = LRARecord.extractCompensator((URI)this.id, (String)participantUrl);
                }
                catch (URISyntaxException e) {
                    continue;
                }
            }
            while ((r = i.iterate()) != null) {
                LRARecord rr;
                if (!(r instanceof LRARecord) || !participantUrl.equals((rr = (LRARecord)r).getCompensator())) continue;
                if (remove) {
                    list.remove((AbstractRecord)rr);
                }
                return rr;
            }
        }
        return null;
    }

    private LRARecord findLRAParticipantByRecoveryUrl(URI recoveryUrl, boolean remove, RecordList ... lists) {
        for (RecordList list : lists) {
            AbstractRecord r;
            if (list == null) continue;
            RecordListIterator i = new RecordListIterator(list);
            while ((r = i.iterate()) != null) {
                LRARecord rr;
                if (!(r instanceof LRARecord) || !(rr = (LRARecord)r).getRecoveryURI().equals(recoveryUrl)) continue;
                if (remove) {
                    list.remove((AbstractRecord)rr);
                }
                return rr;
            }
        }
        return null;
    }

    public boolean isTopLevel() {
        return this.parentId == null;
    }

    public String getResponseData() {
        return this.responseData;
    }

    public BasicAction currentLRA() {
        return ThreadActionData.currentAction();
    }

    public int getHttpStatus() {
        switch (this.status()) {
            case 4: 
            case 7: {
                return 200;
            }
        }
        return this.lraStatusToHttpStatus();
    }

    private int lraStatusToHttpStatus() {
        if (this.status == null || this.status == LRAStatus.Active) {
            return Response.Status.NO_CONTENT.getStatusCode();
        }
        switch (1.$SwitchMap$org$eclipse$microprofile$lra$annotation$LRAStatus[this.status.ordinal()]) {
            case 2: 
            case 4: {
                return Response.Status.OK.getStatusCode();
            }
            case 1: 
            case 6: {
                return Response.Status.ACCEPTED.getStatusCode();
            }
            case 3: 
            case 5: {
                return Response.Status.PRECONDITION_FAILED.getStatusCode();
            }
        }
        return Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    }

    public int begin(Long timeLimit) {
        int res = super.begin();
        this.startTime = LocalDateTime.now(ZoneOffset.UTC);
        this.setTimeLimit(timeLimit);
        this.deactivate();
        return res;
    }

    public int setTimeLimit(Long timeLimit) {
        if (timeLimit <= 0L) {
            return Response.Status.OK.getStatusCode();
        }
        return this.scheduleCancelation(() -> this.abortLRA(), timeLimit);
    }

    private int scheduleCancelation(Runnable runnable, Long timeLimit) {
        assert (timeLimit > 0L);
        if (this.status() != 0) {
            if (LRALogger.logger.isDebugEnabled()) {
                LRALogger.logger.debugf("Ignoring timer because the action status is `%e'", this.status());
            }
            return Response.Status.PRECONDITION_FAILED.getStatusCode();
        }
        if (this.finishTime != null) {
            LocalDateTime ft = LocalDateTime.now(ZoneOffset.UTC).plusNanos(timeLimit * 1000000L);
            if (ft.isAfter(this.finishTime)) {
                if (LRALogger.logger.isDebugEnabled()) {
                    LRALogger.logger.debugf("Ignoring timer for LRA `%s' since there is already an earlier one", (Object)this.id);
                }
                return Response.Status.OK.getStatusCode();
            }
            this.finishTime = ft;
            if (this.scheduledAbort != null) {
                this.scheduledAbort.cancel(false);
            }
        } else {
            this.finishTime = LocalDateTime.now(ZoneOffset.UTC).plusNanos(timeLimit * 1000000L);
        }
        this.scheduledAbort = this.scheduler.schedule(runnable, (long)timeLimit, TimeUnit.MILLISECONDS);
        return Response.Status.OK.getStatusCode();
    }

    private void abortLRA() {
        ReentrantLock lock = this.tryLockTransaction();
        if (lock != null) {
            try {
                int actionStatus = this.status();
                this.scheduledAbort = null;
                if (actionStatus == 0 || actionStatus == 3) {
                    if (LRALogger.logger.isDebugEnabled()) {
                        LRALogger.logger.debugf("Transaction.abortLRA cancelling LRA `%s", (Object)this.id);
                    }
                    this.status = LRAStatus.Cancelling;
                    CompletableFuture.supplyAsync(() -> this.cancelLRA());
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    private void getRecoveryCoordinatorUrls(Map<String, String> participants, RecordList list) {
        if (list != null) {
            AbstractRecord rec;
            RecordListIterator iter = new RecordListIterator(list);
            while ((rec = iter.iterate()) != null) {
                if (!(rec instanceof LRARecord)) continue;
                LRARecord lraRecord = (LRARecord)rec;
                participants.put(lraRecord.getRecoveryURI().toASCIIString(), lraRecord.getParticipantPath());
            }
        }
    }

    public void getRecoveryCoordinatorUrls(Map<String, String> participants) {
        this.getRecoveryCoordinatorUrls(participants, this.pendingList);
        this.getRecoveryCoordinatorUrls(participants, this.preparedList);
    }

    public void updateRecoveryURI(String compensatorUri, String recoveryUri) {
        block4: {
            LRARecord lraRecord = this.findLRAParticipant(compensatorUri, false);
            if (lraRecord != null) {
                try {
                    lraRecord.setRecoveryURI(recoveryUri);
                    if (!this.deactivate() && LRALogger.logger.isInfoEnabled()) {
                        LRALogger.logger.infof("Could not save new recovery URL", new Object[0]);
                    }
                }
                catch (WebApplicationException e) {
                    if (!LRALogger.logger.isInfoEnabled()) break block4;
                    LRALogger.logger.infof("Could not save new recovery URL: %s", (Object)e.getMessage());
                }
            }
        }
    }

    public boolean isInFlight() {
        return this.inFlight;
    }

    void timedOut(LRARecord lraRecord) {
        ReentrantLock lock = this.lraService.tryLockTransaction(this.getId());
        if (lock != null) {
            try {
                if (this.isActive().booleanValue()) {
                    this.doEnd(true);
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    URI getParentId() {
        return this.parentId;
    }

    public String getUid() {
        return this.uid;
    }

    private boolean hasElements(RecordList list) {
        return list != null && list.size() != 0;
    }

    public boolean hasPendingActions() {
        return !this.isFinished() || this.hasElements(this.heuristicList);
    }

    Map<String, String> getFailedParticipants() {
        ConcurrentHashMap<String, String> participants = new ConcurrentHashMap<String, String>();
        this.getRecoveryCoordinatorUrls(participants, this.failedList);
        return participants;
    }
}

