/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.objectstore.AsyncStore;
import com.arjuna.ats.internal.arjuna.objectstore.HashedStore;
import java.io.SyncFailedException;

public class CacheStore
extends HashedStore {
    static final int NO_STATE_TYPE = -1;
    static final AsyncStore _storeManager = new AsyncStore();

    public boolean commit_state(Uid objUid, String tName) throws ObjectStoreException {
        return _storeManager.addWork(this, 0, objUid, tName, null, -1);
    }

    public void sync() throws SyncFailedException, ObjectStoreException {
        _storeManager.flush();
    }

    protected boolean remove_state(Uid objUid, String name, int ft) throws ObjectStoreException {
        int status = _storeManager.removeState(objUid, ft);
        if (status == 4) {
            return true;
        }
        int fileState = this.currentState(objUid, name);
        if (fileState != -1 || status == 3) {
            return _storeManager.addWork(this, 1, objUid, name, null, fileState);
        }
        return fileState != -1;
    }

    protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int ft) throws ObjectStoreException {
        int status = _storeManager.removeWriteState(objUid, ft);
        return _storeManager.addWork(this, 2, objUid, tName, state, ft);
    }

    protected InputObjectState read_state(Uid objUid, String tName, int ft) throws ObjectStoreException {
        OutputObjectState state = _storeManager.getState(objUid, ft);
        if (state == null) {
            return super.read_state(objUid, tName, ft);
        }
        return new InputObjectState(state);
    }

    protected boolean commitState(Uid objUid, String tName) throws ObjectStoreException {
        return super.commit_state(objUid, tName);
    }

    protected boolean removeState(Uid objUid, String name, int ft) throws ObjectStoreException {
        return super.remove_state(objUid, name, ft);
    }

    protected boolean writeState(Uid objUid, String tName, OutputObjectState state, int ft) throws ObjectStoreException {
        return super.write_state(objUid, tName, state, ft);
    }

    public CacheStore(ObjectStoreEnvironmentBean objectStoreEnvironmentBean) throws ObjectStoreException {
        super(objectStoreEnvironmentBean);
        this.syncWrites = objectStoreEnvironmentBean.isCacheStoreSync();
    }
}

