/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec.curves;

import com.google.common.base.MoreObjects;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.crypto.ec.NamedCurve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNamedCurve
extends AbstractInitializableComponent
implements NamedCurve {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @NonnullAfterInit
    private ECParameterSpec paramSpec;

    @Override
    @NonnullAfterInit
    public ECParameterSpec getParameterSpec() {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.paramSpec;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        this.paramSpec = this.buildParameterSpec();
        if (this.paramSpec == null) {
            throw new ComponentInitializationException("Could not init NamedCurve ECParameterSpec");
        }
    }

    @Nullable
    protected ECParameterSpec buildParameterSpec() {
        this.log.trace("Failed to init NamedCurve ECParameterSpec from BC named curve table, trying keypair generation");
        try {
            ECParameterSpec jcaSpec = ((ECPublicKey)ECPublicKey.class.cast(KeySupport.generateKeyPair("EC", new ECGenParameterSpec(this.getName()), null).getPublic())).getParams();
            this.log.trace("Inited NamedCurve ECParameterSpec via key pair generation for name '{}', OID '{}'", (Object)this.getName(), (Object)this.getObjectIdentifier());
            return jcaSpec;
        }
        catch (Exception e) {
            this.log.warn("Error initing the NamedCurve ECParameterSpce via key pair generation with name: {}", (Object)this.getName(), (Object)e);
            this.log.warn("Failed to init NamedCurve ECParameterSpec from BC or key pair generation for name '{}', OID '{}'", (Object)this.getName(), (Object)this.getObjectIdentifier());
            return null;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.getName()).add("OID", (Object)this.getObjectIdentifier()).toString();
    }
}

