/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.renderkit.html.util;

import jakarta.faces.FacesException;
import jakarta.faces.application.ConfigurableNavigationHandler;
import jakarta.faces.application.NavigationCase;
import jakarta.faces.application.NavigationHandler;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIOutcomeTarget;
import jakarta.faces.component.UIParameter;
import jakarta.faces.context.FacesContext;
import jakarta.faces.lifecycle.ClientWindow;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.shared.application.NavigationUtils;
import org.apache.myfaces.shared.renderkit.RendererUtils;

public class OutcomeTargetUtils {
    private static final Logger log = Logger.getLogger(OutcomeTargetUtils.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOutcomeTargetHref(FacesContext facesContext, UIOutcomeTarget component) throws IOException {
        String href;
        Map navigationCaseParams;
        String outcome = component.getOutcome();
        outcome = outcome == null ? facesContext.getViewRoot().getViewId() : outcome;
        outcome = outcome == null ? "" : outcome.trim();
        NavigationHandler nh = facesContext.getApplication().getNavigationHandler();
        if (!(nh instanceof ConfigurableNavigationHandler)) {
            throw new FacesException("Navigation handler must be an instance of ConfigurableNavigationHandler for using h:link or h:button");
        }
        ConfigurableNavigationHandler navigationHandler = (ConfigurableNavigationHandler)nh;
        String toFlowDocumentId = (String)component.getAttributes().get("to-flow-document-id");
        NavigationCase navigationCase = null;
        navigationCase = toFlowDocumentId == null ? navigationHandler.getNavigationCase(facesContext, null, outcome) : navigationHandler.getNavigationCase(facesContext, null, outcome, toFlowDocumentId);
        if (navigationCase == null) {
            log.warning("Could not determine NavigationCase for UIOutcomeTarget component " + RendererUtils.getPathToComponent((UIComponent)component) + " with outcome " + outcome);
            return null;
        }
        Map parameters = null;
        if (component.getChildCount() > 0) {
            List<UIParameter> validParams = OutcomeTargetUtils.getValidUIParameterChildren(facesContext, component.getChildren(), true, false);
            if (validParams.size() > 0) {
                parameters = new HashMap();
            }
            int size = validParams.size();
            for (int i = 0; i < size; ++i) {
                UIParameter param = validParams.get(i);
                String name = param.getName();
                Object value = param.getValue();
                if (parameters.containsKey(name)) {
                    ((List)parameters.get(name)).add(value.toString());
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(value.toString());
                parameters.put(name, list);
            }
        }
        if (navigationCase.getToFlowDocumentId() != null) {
            if (parameters == null) {
                parameters = new HashMap();
            }
            if (!parameters.containsKey("jftfdi")) {
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(navigationCase.getToFlowDocumentId());
                parameters.put("jftfdi", list);
            }
            if (!parameters.containsKey("jffi")) {
                ArrayList<String> list2 = new ArrayList<String>(1);
                list2.add(navigationCase.getFromOutcome());
                parameters.put("jffi", list2);
            }
        }
        if ((navigationCaseParams = NavigationUtils.getEvaluatedNavigationParameters((FacesContext)facesContext, (Map)navigationCase.getParameters())) != null) {
            if (parameters == null) {
                parameters = new HashMap();
            }
            for (Map.Entry entry : navigationCaseParams.entrySet()) {
                if (parameters.containsKey(entry.getKey())) continue;
                parameters.put((String)entry.getKey(), entry.getValue());
            }
        }
        if (parameters == null) {
            parameters = Collections.emptyMap();
        }
        boolean disableClientWindow = component.isDisableClientWindow();
        ClientWindow clientWindow = facesContext.getExternalContext().getClientWindow();
        try {
            if (clientWindow != null && disableClientWindow) {
                clientWindow.disableClientWindowRenderMode(facesContext);
            }
            ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
            href = viewHandler.getBookmarkableURL(facesContext, navigationCase.getToViewId(facesContext), parameters, navigationCase.isIncludeViewParams() || component.isIncludeViewParams());
        }
        finally {
            if (clientWindow != null && disableClientWindow) {
                clientWindow.enableClientWindowRenderMode(facesContext);
            }
        }
        String fragment = (String)component.getAttributes().get("fragment");
        if (fragment != null && (fragment = fragment.trim()).length() > 0) {
            href = href + "#" + fragment;
        }
        return href;
    }

    public static List<UIParameter> getValidUIParameterChildren(FacesContext facesContext, List<UIComponent> children, boolean skipNullValue, boolean skipUnrendered) {
        return OutcomeTargetUtils.getValidUIParameterChildren(facesContext, children, skipNullValue, skipUnrendered, true);
    }

    public static List<UIParameter> getValidUIParameterChildren(FacesContext facesContext, List<UIComponent> children, boolean skipNullValue, boolean skipUnrendered, boolean skipNullName) {
        List<UIParameter> params = null;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            UIParameter param;
            UIComponent child = children.get(i);
            if (!(child instanceof UIParameter) || (param = (UIParameter)child).isDisable() || skipUnrendered && !param.isRendered()) continue;
            String name = param.getName();
            if (skipNullName && (name == null || "".equals(name))) {
                log.log(Level.WARNING, "The UIParameter " + RendererUtils.getPathToComponent((UIComponent)param) + " has a name of null or empty string and thus will not be added to the URL.");
                continue;
            }
            if (skipNullValue && param.getValue() == null) {
                if (!facesContext.isProjectStage(ProjectStage.Development)) continue;
                log.log(Level.INFO, "The UIParameter " + RendererUtils.getPathToComponent((UIComponent)param) + " has a value of null and thus will not be added to the URL.");
                continue;
            }
            if (params == null) {
                params = new ArrayList<UIParameter>();
            }
            params.add(param);
        }
        if (params == null) {
            params = Collections.emptyList();
        }
        return params;
    }
}

