/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.jdeparser.JClass;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JFormatter;
import org.jboss.jdeparser.JPackage;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypeVar;

final class JArrayClass
extends JClass {
    private final JType componentType;

    JArrayClass(JDeparser owner, JType component) {
        super(owner);
        this.componentType = component;
    }

    @Override
    public String name() {
        return this.componentType.name() + "[]";
    }

    @Override
    public String fullName() {
        return this.componentType.fullName() + "[]";
    }

    @Override
    public String binaryName() {
        return this.componentType.binaryName() + "[]";
    }

    @Override
    public void generate(JFormatter f) {
        f.g(this.componentType).p("[]");
    }

    @Override
    public JPackage _package() {
        return this.owner().rootPackage();
    }

    @Override
    public JClass _extends() {
        return this.owner().ref(Object.class);
    }

    @Override
    public Iterator<JClass> _implements() {
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public JType elementType() {
        return this.componentType;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JArrayClass)) {
            return false;
        }
        return this.componentType.equals(((JArrayClass)obj).componentType);
    }

    public int hashCode() {
        return this.componentType.hashCode();
    }

    @Override
    protected JClass substituteParams(JTypeVar[] variables, List<JClass> bindings) {
        if (this.componentType.isPrimitive()) {
            return this;
        }
        JClass c = ((JClass)this.componentType).substituteParams(variables, bindings);
        if (c == this.componentType) {
            return this;
        }
        return new JArrayClass(this.owner(), c);
    }
}

