/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.spi.expression.function;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.data.expression.NumericExpression;
import jakarta.data.messages.Messages;
import jakarta.data.spi.expression.function.NumericOperatorExpression;
import jakarta.data.spi.expression.literal.NumericLiteral;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.math.BigDecimal;
import java.math.BigInteger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class NumericOperatorExpressionRecord<T, N extends Number>
extends Record
implements NumericOperatorExpression<T, N> {
    private final NumericOperatorExpression.Operator operator;
    private final NumericExpression<? super T, N> left;
    private final NumericExpression<? super T, N> right;
    static final long serialVersionUID = -3936746146105923508L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    NumericOperatorExpressionRecord(NumericOperatorExpression.Operator operator, NumericExpression<? super T, N> left, NumericExpression<? super T, N> right) {
        NumericLiteral lit;
        Messages.requireNonNull((Object)operator, "operator");
        Messages.requireNonNull(left, "left");
        Messages.requireNonNull(right, "right");
        if (operator == NumericOperatorExpression.Operator.DIVIDE && right instanceof NumericLiteral && NumericOperatorExpressionRecord.zero((lit = (NumericLiteral)right).value())) {
            throw new IllegalArgumentException(Messages.get("005.zero.not.allowed", "divisor"));
        }
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @Override
    public String toString() {
        char op = switch (this.operator) {
            case NumericOperatorExpression.Operator.PLUS -> '+';
            case NumericOperatorExpression.Operator.TIMES -> '*';
            case NumericOperatorExpression.Operator.MINUS -> '-';
            case NumericOperatorExpression.Operator.DIVIDE -> '/';
            default -> throw new IllegalStateException();
        };
        String rightString = this.right.toString();
        String leftString = this.left.toString();
        StringBuilder expression = new StringBuilder(rightString.length() + leftString.length() + 7);
        if (this.left instanceof NumericOperatorExpression) {
            expression.append('(').append(leftString).append(')');
        } else {
            expression.append(leftString);
        }
        expression.append(' ').append(op).append(' ');
        if (this.right instanceof NumericOperatorExpression) {
            expression.append('(').append(rightString).append(')');
        } else {
            expression.append(rightString);
        }
        return expression.toString();
    }

    private static boolean zero(Object number) {
        if (number instanceof Integer) {
            Integer i = (Integer)number;
            return i == 0;
        }
        if (number instanceof Long) {
            Long l = (Long)number;
            return l == 0L;
        }
        if (number instanceof Double) {
            Double d = (Double)number;
            return 0 == Double.compare(d, 0.0);
        }
        if (number instanceof Float) {
            Float f = (Float)number;
            return 0 == Float.compare(f.floatValue(), 0.0f);
        }
        if (number instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)number;
            return 0 == bd.compareTo(BigDecimal.ZERO);
        }
        if (number instanceof BigInteger) {
            BigInteger bi = (BigInteger)number;
            return 0 == bi.compareTo(BigInteger.ZERO);
        }
        if (number instanceof Short) {
            Short s = (Short)number;
            return s == 0;
        }
        if (number instanceof Byte) {
            Byte b = (Byte)number;
            return b == 0;
        }
        throw new IllegalArgumentException(Messages.get("009.unknown.number.type", number.getClass().getName()));
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NumericOperatorExpressionRecord.class, "operator;left;right", "operator", "left", "right"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NumericOperatorExpressionRecord.class, "operator;left;right", "operator", "left", "right"}, this, o);
    }

    @Override
    public NumericOperatorExpression.Operator operator() {
        return this.operator;
    }

    @Override
    public NumericExpression<? super T, N> left() {
        return this.left;
    }

    @Override
    public NumericExpression<? super T, N> right() {
        return this.right;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"jakarta.data.spi.expression.function.NumericOperatorExpressionRecord", NumericOperatorExpressionRecord.class, null, null);
    }
}

