/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.injectionengine;

import com.ibm.wsspi.injectionengine.InjectionException;

public class RecursiveInjectionException
extends InjectionException {
    private static final long serialVersionUID = 1023041353362607468L;
    public boolean ivLogged = false;

    public static RecursionDetection detectRecursiveInjection(Throwable t) {
        boolean recursiveInjection = false;
        boolean logged = false;
        Throwable lastCause = null;
        for (Throwable cause = t; cause != null && cause != lastCause; cause = cause.getCause()) {
            if (cause instanceof StackOverflowError || cause instanceof RecursiveInjectionException) {
                recursiveInjection = true;
                if (cause instanceof RecursiveInjectionException && ((RecursiveInjectionException)cause).ivLogged) {
                    logged = true;
                    break;
                }
            }
            lastCause = cause;
        }
        RecursionDetection rd = recursiveInjection && logged ? RecursionDetection.RecursiveAlreadyLogged : (recursiveInjection ? RecursionDetection.Recursive : RecursionDetection.NotRecursive);
        return rd;
    }

    public RecursiveInjectionException() {
    }

    public RecursiveInjectionException(String message) {
        super(message);
    }

    public RecursiveInjectionException(String message, Throwable cause) {
        super(message, cause);
    }

    public RecursiveInjectionException(Throwable cause) {
        super(cause);
    }

    public static enum RecursionDetection {
        NotRecursive,
        Recursive,
        RecursiveAlreadyLogged;

    }
}

