/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.inbound;

import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventHandler;
import com.ibm.websphere.event.Topic;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(configurationPid={"com.ibm.ws.http.HttpPipelineEventHandler"}, property={"event.topics=com/ibm/ws/http/channel/events/PIPELINING", "service.vendor=IBM"})
public class HttpPipelineEventHandler
implements EventHandler {
    private static final TraceComponent tc = Tr.register(HttpPipelineEventHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    public static final Topic TOPIC_PIPELINING = new Topic("com/ibm/ws/http/channel/events/PIPELINING");

    public HttpPipelineEventHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Created the HTTP pipeline event handler", (Object[])new Object[0]);
        }
    }

    @Activate
    protected void activate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Activating the HTTP pipeline event handler", (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Deactivating the HTTP pipeline event handler", (Object[])new Object[0]);
        }
    }

    public void handleEvent(Event event) {
        HttpInboundLink link;
        String topic = event.getTopic();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Received event topic: " + topic), (Object[])new Object[0]);
        }
        if (null != (link = (HttpInboundLink)((Object)event.getProperty(CallbackIDs.CALLBACK_HTTPICL.getName(), HttpInboundLink.class)))) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Processing request on new thread; " + (Object)((Object)link)), (Object[])new Object[0]);
            }
            link.ready(link.getVirtualConnection());
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Unable to process pipelined request with null link", (Object[])new Object[0]);
        }
    }
}

