/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.feature.internal.cmdline;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import com.ibm.ws.kernel.feature.Visibility;
import com.ibm.ws.kernel.feature.internal.FeatureResolverImpl;
import com.ibm.ws.kernel.feature.internal.cmdline.APIType;
import com.ibm.ws.kernel.feature.internal.cmdline.NLS;
import com.ibm.ws.kernel.feature.internal.cmdline.ReturnCode;
import com.ibm.ws.kernel.feature.internal.generator.ManifestFileProcessor;
import com.ibm.ws.kernel.feature.internal.subsystem.FeatureRepository;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.feature.resolver.FeatureResolver;
import com.ibm.ws.kernel.provisioning.BundleRepositoryRegistry;
import com.ibm.ws.kernel.provisioning.ContentBasedLocalBundleRepository;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ParserUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClasspathAction
implements ActionHandler {
    private static final SubsystemContentType[] JAR_CONTENT_TYPES;
    static final long serialVersionUID = 4117799374839239916L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public ExitCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        String[] features;
        String output = (String)args.getPositionalArguments().get(0);
        String featuresString = args.getOption("features");
        String[] stringArray = features = featuresString == null || featuresString.trim().isEmpty() ? null : featuresString.split("[\\s,]+");
        if (features == null || features.length == 0) {
            stderr.println(NLS.getMessage("missing.option", args.getAction(), "--features"));
            return ReturnCode.BAD_ARGUMENT;
        }
        HashMap<String, ProductInfo> productInfos = new HashMap<String, ProductInfo>();
        HashMap<String, FeatureInfo> featuresBySymbolicName = new HashMap<String, FeatureInfo>();
        this.collectFeatureInfos(productInfos, featuresBySymbolicName);
        ArrayList<FeatureInfo> featureInfos = new ArrayList<FeatureInfo>();
        for (String name : features) {
            FeatureInfo featureInfo = this.getFeatureInfo(name, productInfos, featuresBySymbolicName);
            if (featureInfo == null) {
                stderr.println(NLS.getMessage("classpath.feature.not.found", name));
                return ReturnCode.BAD_ARGUMENT;
            }
            if (featureInfo.feature.getVisibility() != Visibility.PUBLIC) {
                stderr.println(NLS.getMessage("classpath.feature.not.public", name));
                return ReturnCode.BAD_ARGUMENT;
            }
            featureInfos.add(featureInfo);
        }
        FeatureRepository repo = new FeatureRepository();
        repo.init();
        FeatureResolverImpl resolver = new FeatureResolverImpl();
        FeatureResolver.Result r = resolver.resolve(repo, Collections.emptySet(), Arrays.asList(features), Collections.emptySet(), false, Collections.emptySet());
        HashMap<String, FeatureInfo> featuresToCheck = new HashMap<String, FeatureInfo>();
        for (String string : r.getResolvedFeatures()) {
            FeatureInfo fullFeature = this.getFeatureInfo(string, productInfos, featuresBySymbolicName);
            if (fullFeature == null) continue;
            String[] fullFeatureInfo = fullFeature.toString().split("/");
            if (fullFeatureInfo.length > 2) {
                featuresToCheck.put((String)fullFeatureInfo[1], fullFeature);
            }
            featuresToCheck.put(string, fullFeature);
        }
        LinkedHashSet<File> apiJars = new LinkedHashSet<File>();
        for (FeatureInfo featureInfo : featureInfos) {
            this.collectAPIJars(featureInfo, featuresToCheck, apiJars);
        }
        File file = new File(output);
        StringBuilder jarClasspath = new StringBuilder();
        for (File apiJar : apiJars) {
            String relativePath = ClasspathAction.getRelativePath(file, apiJar);
            if (relativePath == null) {
                stderr.println(NLS.getMessage("classpath.wrong.drive", file.getAbsolutePath(), apiJar.getAbsolutePath()));
                return ReturnCode.BAD_ARGUMENT;
            }
            if (jarClasspath.length() != 0) {
                jarClasspath.append(' ');
            }
            jarClasspath.append(ParserUtils.encode((String)relativePath));
        }
        try {
            this.createClasspathJar(file, jarClasspath.toString());
        }
        catch (IOException fullFeatureInfo) {
            void e;
            FFDCFilter.processException((Throwable)fullFeatureInfo, (String)"com.ibm.ws.kernel.feature.internal.cmdline.ClasspathAction", (String)"163", (Object)this, (Object[])new Object[]{stdout, stderr, args});
            stderr.println(NLS.getMessage("classpath.create.fail", file.getAbsolutePath(), e.getLocalizedMessage()));
            return ReturnCode.IO_FAILURE;
        }
        return ReturnCode.OK;
    }

    private void collectFeatureInfos(Map<String, ProductInfo> productInfos, Map<String, FeatureInfo> featuresBySymbolicName) {
        ManifestFileProcessor manifestFileProcessor = new ManifestFileProcessor();
        for (Map.Entry<String, Map<String, ProvisioningFeatureDefinition>> productEntry : manifestFileProcessor.getFeatureDefinitionsByProduct().entrySet()) {
            String productName = productEntry.getKey();
            Map<String, ProvisioningFeatureDefinition> features = productEntry.getValue();
            ContentBasedLocalBundleRepository repository = productName.equals("core") ? BundleRepositoryRegistry.getInstallBundleRepository() : (productName.equals("usr") ? BundleRepositoryRegistry.getUsrInstallBundleRepository() : manifestFileProcessor.getBundleRepository(productName, null));
            ProductInfo productInfo = new ProductInfo(repository);
            productInfos.put(productName, productInfo);
            for (Map.Entry<String, ProvisioningFeatureDefinition> featureEntry : features.entrySet()) {
                String featureSymbolicName = featureEntry.getKey();
                ProvisioningFeatureDefinition feature = featureEntry.getValue();
                FeatureInfo featureInfo = new FeatureInfo(productInfo, feature);
                featuresBySymbolicName.put(featureSymbolicName, featureInfo);
                String shortName = feature.getIbmShortName();
                if (shortName == null) continue;
                productInfo.featuresByShortName.put(shortName, featureInfo);
            }
        }
    }

    private FeatureInfo getFeatureInfo(String name, Map<String, ProductInfo> productInfos, Map<String, FeatureInfo> featuresBySymbolicName) {
        String featureName;
        String productName;
        int index = name.indexOf(58);
        if (index == -1) {
            FeatureInfo featureInfo = featuresBySymbolicName.get(name);
            if (featureInfo != null) {
                return featureInfo;
            }
            productName = "core";
            featureName = name;
        } else {
            productName = name.substring(0, index);
            featureName = name.substring(index + 1);
        }
        ProductInfo product = productInfos.get(productName);
        return product == null ? null : product.featuresByShortName.get(featureName);
    }

    private void collectAPIJars(FeatureInfo featureInfo, Map<String, FeatureInfo> allowedFeatures, Set<File> apiJars) {
        for (SubsystemContentType contentType : JAR_CONTENT_TYPES) {
            for (FeatureResource resource : featureInfo.feature.getConstituents(contentType)) {
                File file;
                if (APIType.getAPIType(resource) != APIType.API || (file = featureInfo.productInfo.repository.selectBundle(resource.getLocation(), resource.getSymbolicName(), resource.getVersionRange())) == null) continue;
                apiJars.add(file);
            }
        }
        for (FeatureResource resource : featureInfo.feature.getConstituents(SubsystemContentType.FEATURE_TYPE)) {
            String name = resource.getSymbolicName();
            FeatureInfo childFeatureInfo = allowedFeatures.get(name);
            if (childFeatureInfo == null || !APIType.API.matches(resource)) continue;
            allowedFeatures.remove(name);
            this.collectAPIJars(childFeatureInfo, allowedFeatures, apiJars);
        }
    }

    private static String getRelativePath(File src, File target) {
        int i;
        String[] srcComponents = ClasspathAction.getCanonicalPath(src).replace(File.separatorChar, '/').split("/");
        String[] targetComponents = ClasspathAction.getCanonicalPath(target).replace(File.separatorChar, '/').split("/");
        if (srcComponents.length > 0 && targetComponents.length > 0 && !targetComponents[0].equals(srcComponents[0])) {
            return null;
        }
        int minLength = Math.min(srcComponents.length, targetComponents.length);
        for (int common = 0; common < minLength && srcComponents[common].equals(targetComponents[common]); ++common) {
        }
        StringBuilder result = new StringBuilder();
        for (i = common; i < srcComponents.length - 1; ++i) {
            if (result.length() != 0) {
                result.append('/');
            }
            result.append("..");
        }
        for (i = common; i < targetComponents.length; ++i) {
            if (result.length() != 0) {
                result.append('/');
            }
            result.append(targetComponents[i]);
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.kernel.feature.internal.cmdline.ClasspathAction", (String)"323", null, (Object[])new Object[]{file});
            e.getClass();
            return file.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClasspathJar(File outputFile, String classpath) throws IOException {
        try (FileOutputStream out = new FileOutputStream(outputFile);){
            Manifest manifest = new Manifest();
            Attributes attrs = manifest.getMainAttributes();
            attrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attrs.put(Attributes.Name.CLASS_PATH, classpath);
            new JarOutputStream((OutputStream)out, manifest).close();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.cmdline.ClasspathAction", ClasspathAction.class, null, null);
        JAR_CONTENT_TYPES = new SubsystemContentType[]{SubsystemContentType.BUNDLE_TYPE, SubsystemContentType.JAR_TYPE};
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class FeatureInfo {
        final ProductInfo productInfo;
        final ProvisioningFeatureDefinition feature;
        static final long serialVersionUID = -5465397091866513420L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        FeatureInfo(ProductInfo productInfo, ProvisioningFeatureDefinition feature) {
            this.productInfo = productInfo;
            this.feature = feature;
        }

        public String toString() {
            return this.feature.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.cmdline.ClasspathAction$FeatureInfo", FeatureInfo.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ProductInfo {
        final ContentBasedLocalBundleRepository repository;
        final Map<String, FeatureInfo> featuresByShortName = new TreeMap<String, FeatureInfo>(String.CASE_INSENSITIVE_ORDER);
        static final long serialVersionUID = -4309113800741354244L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ProductInfo(ContentBasedLocalBundleRepository repository) {
            this.repository = repository;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.feature.internal.cmdline.ClasspathAction$ProductInfo", ProductInfo.class, null, null);
        }
    }
}

