/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.storage;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.storage.Storage;
import io.openliberty.security.oidcclientcore.storage.StorageProperties;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SessionBasedStorage
implements Storage {
    public static final TraceComponent tc = Tr.register(SessionBasedStorage.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private final HttpServletRequest request;
    static final long serialVersionUID = -5418953384772497642L;

    public SessionBasedStorage(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void store(String name, @Sensitive String value) {
        this.store(name, value, null);
    }

    @Override
    public void store(String name, @Sensitive String value, StorageProperties properties) {
        HttpSession session = this.request.getSession();
        session.setAttribute(name, (Object)value);
    }

    @Override
    @Sensitive
    public String get(String name) {
        HttpSession session = this.request.getSession();
        Object value = session.getAttribute(name);
        if (value == null) {
            return null;
        }
        return (String)value;
    }

    @Override
    public void remove(String name) {
        HttpSession session = this.request.getSession();
        session.removeAttribute(name);
    }
}

