/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.queue;

import com.ibm.ws.request.timing.queue.QueueableRequest;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DelayedRequestQueue<R extends QueueableRequest> {
    private final DelayQueue<R> requestQueue;
    private final Set<String> queuedRequests;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock r = this.rwl.readLock();
    private final Lock w = this.rwl.writeLock();

    public DelayedRequestQueue() {
        this.requestQueue = new DelayQueue();
        this.queuedRequests = new HashSet<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRequest(R request) {
        String requestId = ((QueueableRequest)request).getRequestContext().getRequestId().getId();
        boolean retVal = false;
        this.w.lock();
        try {
            if (!this.queuedRequests.contains(requestId)) {
                this.queuedRequests.add(requestId);
                this.requestQueue.put(request);
                retVal = true;
            }
        }
        finally {
            this.w.unlock();
        }
        return retVal;
    }

    public void removeRequest(R request) {
        String requestId = ((QueueableRequest)request).getRequestContext().getRequestId().getId();
        this.w.lock();
        try {
            this.queuedRequests.remove(requestId);
        }
        finally {
            this.w.unlock();
        }
    }

    public void requeueRequest(R request) {
        String requestId = ((QueueableRequest)request).getRequestContext().getRequestId().getId();
        this.r.lock();
        try {
            if (this.queuedRequests.contains(requestId)) {
                this.requestQueue.put(request);
            }
        }
        finally {
            this.r.unlock();
        }
    }

    public R processNext() throws InterruptedException {
        QueueableRequest request = (QueueableRequest)this.requestQueue.take();
        this.r.lock();
        try {
            if (this.queuedRequests.contains(request.getRequestContext().getRequestId().getId())) {
                QueueableRequest queueableRequest = request;
                return (R)queueableRequest;
            }
        }
        finally {
            this.r.unlock();
        }
        return this.processNext();
    }

    public void clear() {
        this.w.lock();
        try {
            this.requestQueue.clear();
            this.queuedRequests.clear();
        }
        finally {
            this.w.unlock();
        }
    }
}

