/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.http.netty.inbound.NettySSLConnectionContext;
import com.ibm.ws.http.netty.inbound.NettyTCPReadRequestContext;
import com.ibm.ws.http.netty.inbound.NettyTCPWriteRequestContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.SSLConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NettyTCPConnectionContext
implements TCPConnectionContext {
    private final NettyTCPReadRequestContext readContext;
    private final NettyTCPWriteRequestContext writeContext;
    private final VirtualConnection vc;
    private final Channel nettyChannel;
    private SSLConnectionContext sslContext;
    static final long serialVersionUID = 9165463487399309959L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public NettyTCPConnectionContext(Channel channel, VirtualConnection vc) {
        this.vc = vc;
        this.nettyChannel = channel;
        this.readContext = new NettyTCPReadRequestContext(this, this.nettyChannel);
        this.readContext.setVC(this.vc);
        this.writeContext = new NettyTCPWriteRequestContext(this, this.nettyChannel);
        this.writeContext.setVC(this.vc);
        this.initializeSSLContext();
    }

    private void initializeSSLContext() {
        SslHandler sslHandler = (SslHandler)this.nettyChannel.pipeline().get(SslHandler.class);
        if (sslHandler != null) {
            this.sslContext = new NettySSLConnectionContext(this.nettyChannel, (Boolean)this.nettyChannel.attr(NettyHttpConstants.IS_OUTBOUND_KEY).get());
        }
    }

    public TCPReadRequestContext getReadInterface() {
        return this.readContext;
    }

    public TCPWriteRequestContext getWriteInterface() {
        return this.writeContext;
    }

    public InetAddress getRemoteAddress() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.nettyChannel.remoteAddress();
        return remoteAddress.getAddress();
    }

    public int getRemotePort() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.nettyChannel.remoteAddress();
        return remoteAddress.getPort();
    }

    public InetAddress getLocalAddress() {
        InetSocketAddress localAddress = (InetSocketAddress)this.nettyChannel.localAddress();
        return localAddress.getAddress();
    }

    public int getLocalPort() {
        InetSocketAddress localAddress = (InetSocketAddress)this.nettyChannel.localAddress();
        return localAddress.getPort();
    }

    public SSLConnectionContext getSSLContext() {
        return this.sslContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.inbound.NettyTCPConnectionContext", NettyTCPConnectionContext.class, null, null);
    }
}

