/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.messaging.mbean.QueueMBean;
import com.ibm.websphere.messaging.mbean.SubscriberMBean;
import com.ibm.websphere.messaging.mbean.TopicMBean;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.Controllable;
import com.ibm.ws.sib.admin.ControllableRegistrationService;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.admin.SIBExceptionInvalidValue;
import com.ibm.ws.sib.admin.exception.AlreadyRegisteredException;
import com.ibm.ws.sib.admin.exception.NotRegisteredException;
import com.ibm.ws.sib.admin.exception.ParentNotFoundException;
import com.ibm.ws.sib.admin.internal.JsMessagingEngineImpl;
import com.ibm.ws.sib.admin.internal.JsObject;
import com.ibm.ws.sib.admin.internal.JsQueue;
import com.ibm.ws.sib.admin.internal.SubscriberImpl;
import com.ibm.ws.sib.admin.internal.TopicImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.AccessController;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.management.StandardMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class MessagingMBeanFactoryImpl
implements ControllableRegistrationService {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.internal.MessagingMBeanFactoryImpl";
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private static final TraceComponent tc = SibTr.register(MessagingMBeanFactoryImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private final HashMap serviceObjects = new HashMap();
    private JsMessagingEngineImpl _me = null;
    private final Vector objects = new Vector();
    private final HashMap newObjects = new HashMap();
    private final HashMap controllableMap = new HashMap();
    BundleContext bcontext;

    public MessagingMBeanFactoryImpl(JsMessagingEngineImpl me) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JsMessagingEngineImpl().<init>", (Object)this);
        }
        SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.MessagingMBeanFactoryImpl().<init>");
        this._me = me;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.internal.MessagingMBeanFactoryImpl().<init>");
        }
    }

    public MessagingMBeanFactoryImpl(JsMessagingEngineImpl jsMessagingEngineImpl, BundleContext bContext) {
        this(jsMessagingEngineImpl);
        this.bcontext = bContext;
    }

    public RuntimeEventListener register(Controllable controllable, ControllableType type) throws AlreadyRegisteredException, SIBExceptionInvalidValue {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)new Object[]{controllable, type});
        }
        RuntimeEventListener retValue = null;
        if (type == ControllableType.QUEUE_POINT) {
            this.createQueueMBean(controllable);
        } else if (type == ControllableType.PUBLICATION_POINT) {
            this.createTopicMBean(controllable);
        } else if (type == ControllableType.SUBSCRIPTION_POINT) {
            this.createSubscriberMBean(controllable);
        } else {
            String reason = "Invalid ControllableType of " + type.toString();
            SIBExceptionInvalidValue e = new SIBExceptionInvalidValue(nls.getFormattedMessage("INTERNAL_ERROR_SIAS0003", new Object[]{reason}, reason));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.MessagingMBeanFactoryImpl.register", (String)"PROBE_ID_10", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"register", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register", (Object)new Object[]{retValue});
        }
        return retValue;
    }

    public RuntimeEventListener register(Controllable controllable, Controllable parent, ControllableType type) throws AlreadyRegisteredException, SIBExceptionInvalidValue {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)new Object[]{controllable, parent, type});
        }
        Object retValue = null;
        String reason = "Invalid ControllableType of " + type.toString();
        SIBExceptionInvalidValue e = new SIBExceptionInvalidValue(nls.getFormattedMessage("INTERNAL_ERROR_SIAS0003", new Object[]{reason}, reason));
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.MessagingMBeanFactoryImpl.register", (String)"PROBE_ID_20", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register", (Object)e);
        }
        throw e;
    }

    public RuntimeEventListener register(Controllable controllable, RuntimeEventListener parent, ControllableType type) throws AlreadyRegisteredException, SIBExceptionInvalidValue {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)new Object[]{controllable, parent, type});
        }
        Object retValue = null;
        String reason = "Invalid ControllableType of " + type.toString();
        SIBExceptionInvalidValue e = new SIBExceptionInvalidValue(nls.getFormattedMessage("INTERNAL_ERROR_SIAS0003", new Object[]{reason}, reason));
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.admin.internal.MessagingMBeanFactoryImpl.register", (String)"PROBE_ID_30", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register", (Object)e);
        }
        throw e;
    }

    public void deregister(Controllable controllable, ControllableType type) throws NotRegisteredException, SIBExceptionInvalidValue {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregister", (Object)new Object[]{controllable, type});
        }
        try {
            if (type == ControllableType.QUEUE_POINT) {
                ServiceRegistration qMBean = (ServiceRegistration)this.serviceObjects.get(controllable.getName());
                qMBean.unregister();
            } else if (type == ControllableType.PUBLICATION_POINT) {
                ServiceRegistration topicMBean = (ServiceRegistration)this.serviceObjects.get(controllable.getName());
                topicMBean.unregister();
            } else if (type == ControllableType.SUBSCRIPTION_POINT) {
                ServiceRegistration subMBean = (ServiceRegistration)this.serviceObjects.get(controllable.getName());
                subMBean.unregister();
            }
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        this.deregister(controllable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister");
        }
    }

    public void deregister(Controllable controllable) throws NotRegisteredException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregister", (Object)new Object[]{controllable});
        }
        Object previousValue = this.controllableMap.remove(controllable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister Mbean", previousValue);
        }
    }

    public synchronized void deregisterAll() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterAll");
        }
        Set s = this.controllableMap.entrySet();
        Vector v = new Vector();
        for (Map.Entry mapEntry : s) {
            Object o = mapEntry.getKey();
            if (o instanceof Controllable) {
                v.add(o);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            SibTr.debug((TraceComponent)tc, (String)("Object " + o.toString() + " which is not of type Controllable was found in controllableMap"));
        }
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            try {
                Object mbeanObject;
                Controllable c = (Controllable)iter.next();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Controllable object " + c.toString() + " is being deregistered"));
                }
                if ((mbeanObject = this.controllableMap.get(c)) instanceof JsQueue) {
                    this.deregister(c, ControllableType.QUEUE_POINT);
                } else if (mbeanObject instanceof TopicImpl) {
                    this.deregister(c, ControllableType.PUBLICATION_POINT);
                } else if (mbeanObject instanceof SubscriberImpl) {
                    this.deregister(c, ControllableType.SUBSCRIPTION_POINT);
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)"Controllable object was deregistered");
            }
            catch (NotRegisteredException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)"Controllable object could not be deregistered");
            }
            catch (SIBExceptionInvalidValue e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterAll");
        }
    }

    private Controllable createQueueMBean(Controllable c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createQueuePointMBean", (Object)new Object[]{c});
        }
        JsQueue qp = new JsQueue(this._me, c);
        this.controllableMap.put(c, qp);
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.vendor", "IBM");
            String cName = c.getName();
            ((Dictionary)properties).put("jmx.objectname", "WebSphere:feature=wasJmsServer,type=Queue,name=" + cName);
            ServiceRegistration qMbean = this.bcontext.registerService(QueueMBean.class.getName(), (Object)qp, properties);
            this.serviceObjects.put(cName, qMbean);
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createQueuePointMBean", (Object)new Object[]{qp});
        }
        return qp;
    }

    private Controllable createTopicMBean(Controllable c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createPublicationPointMBean", (Object)new Object[]{c});
        }
        TopicImpl pp = new TopicImpl(this._me, c);
        this.controllableMap.put(c, pp);
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.vendor", "IBM");
            String cName = c.getName();
            ((Dictionary)properties).put("jmx.objectname", "WebSphere:feature=wasJmsServer,type=Topic,name=" + cName);
            ServiceRegistration topicMBean = this.bcontext.registerService(TopicMBean.class.getName(), (Object)pp, properties);
            this.serviceObjects.put(cName, topicMBean);
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPublicationPointMBean", (Object)new Object[]{pp});
        }
        return pp;
    }

    private Controllable createSubscriberMBean(Controllable c) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionPointMBean", (Object)new Object[]{c});
        }
        SubscriberImpl sp = new SubscriberImpl(this._me, c);
        this.controllableMap.put(c, sp);
        try {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.vendor", "IBM");
            String cName = c.getName();
            ((Dictionary)properties).put("jmx.objectname", "WebSphere:feature=wasJmsServer,type=Subscriber,name=" + cName);
            ServiceRegistration subscriberMbean = AccessController.doPrivileged(() -> this.bcontext.registerService(SubscriberMBean.class.getName(), (Object)sp, properties));
            this.serviceObjects.put(cName, subscriberMbean);
        }
        catch (Exception e) {
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionPointMBean", (Object)new Object[]{sp});
        }
        return sp;
    }

    public void deregister(Object o) throws NotRegisteredException {
        Object previousValue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregister", (Object)new Object[]{o});
        }
        if ((previousValue = this.newObjects.remove(o)) != null) {
            if (previousValue instanceof JsObject) {
                // empty if block
            }
        } else {
            throw new NotRegisteredException("");
        }
        int i = 0;
        Enumeration vEnum = this.objects.elements();
        while (vEnum.hasMoreElements()) {
            Object el = vEnum.nextElement();
            if (el.equals(o)) {
                this.objects.remove(i);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deregister", (Object)"removed object");
                }
                return;
            }
            ++i;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister", (Object)"did not find object");
        }
        throw new NotRegisteredException("");
    }

    public RuntimeEventListener register(Controllable controllable, StandardMBean parent, ControllableType type) throws AlreadyRegisteredException, ParentNotFoundException, SIBExceptionInvalidValue {
        return null;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"com/ibm/ws/sib/admin/internal/MessagingMBeanFactoryImpl.java");
        }
    }
}

