/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxrs.defaultexceptionmapper.DefaultExceptionMapperCallback;
import com.ibm.ws.microprofile.metrics.impl.SharedMetricRegistries;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.container.ResourceInfo;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={DefaultExceptionMapperCallback.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class MetricsJaxRsEMCallbackImpl
implements DefaultExceptionMapperCallback {
    private static final TraceComponent tc = Tr.register(MetricsJaxRsEMCallbackImpl.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
    public static final String EXCEPTION_KEY = MetricsJaxRsEMCallbackImpl.class.getName() + ".Exception";
    private static final String[] metricCDIBundles = new String[]{"io.astefanutti.metrics.cdi30", "io.openliberty.microprofile.metrics.internal.cdi30.interceptors"};
    static SharedMetricRegistries sharedMetricRegistry;
    static final long serialVersionUID = 5594199407288621415L;

    public static synchronized Counter registerOrRetrieveRESTUnmappedExceptionMetric(String fullyQualifiedClassName, String methodSignature) {
        MetricRegistry baseMetricRegistry = sharedMetricRegistry.getOrCreate(MetricRegistry.Type.BASE.getName());
        Metadata metadata = Metadata.builder().withType(MetricType.COUNTER).withName("REST.request.unmappedException.total").withDescription("REST.request.unmappedException.description").withDisplayName("Total Unmapped Exception Requests").build();
        Tag classTag = new Tag("class", fullyQualifiedClassName);
        Tag methodTag = new Tag("method", methodSignature);
        Counter counter = baseMetricRegistry.counter(metadata, new Tag[]{classTag, methodTag});
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        sharedMetricRegistry.associateMetricIDToApplication(new MetricID(metadata.getName(), new Tag[]{classTag, methodTag}), cmd.getJ2EEName().getApplication(), baseMetricRegistry);
        return counter;
    }

    public Map<String, Object> onDefaultMappedException(Throwable throwable, int statusCode, ResourceInfo resourceInfo) {
        Map.Entry<String, String> classXmethod;
        StackTraceElement[] ste = throwable.getStackTrace();
        if (!ste[0].getClassName().startsWith(metricCDIBundles[0]) && !ste[0].getClassName().startsWith(metricCDIBundles[1]) && (classXmethod = this.resolveSimpleTimerClassMethodTags(resourceInfo)) != null) {
            MetricsJaxRsEMCallbackImpl.registerOrRetrieveRESTUnmappedExceptionMetric(classXmethod.getKey(), classXmethod.getValue()).inc();
        }
        Tr.warning((TraceComponent)tc, (String)"METRICS_UNHANDLED_JAXRS_EXCEPTION", (Object[])new Object[]{throwable});
        return Collections.singletonMap(EXCEPTION_KEY, throwable);
    }

    @Reference
    public void getSharedMetricRegistries(SharedMetricRegistries sharedMetricRegistry) {
        MetricsJaxRsEMCallbackImpl.sharedMetricRegistry = sharedMetricRegistry;
    }

    private Map.Entry<String, String> resolveSimpleTimerClassMethodTags(ResourceInfo resourceInfo) {
        String fullMethodSignature;
        String fullyQualifiedClassName;
        block7: {
            block6: {
                Class resourceClass = resourceInfo.getResourceClass();
                fullyQualifiedClassName = null;
                fullMethodSignature = null;
                if (resourceClass != null) {
                    fullyQualifiedClassName = resourceClass.getName();
                    Method resourceMethod = resourceInfo.getResourceMethod();
                    Class<?>[] parameterClasses = resourceMethod.getParameterTypes();
                    fullMethodSignature = resourceMethod.getName();
                    for (Class<?> p : parameterClasses) {
                        String parameter = p.getCanonicalName();
                        fullMethodSignature = fullMethodSignature + "_" + parameter;
                    }
                }
                if (fullMethodSignature == null || fullyQualifiedClassName == null || fullMethodSignature.isEmpty()) break block6;
                if (!fullyQualifiedClassName.isEmpty()) break block7;
            }
            if (tc.isAnyTracingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Could not resolve the class name or method signature class:[" + fullMethodSignature + "] method:[" + fullMethodSignature + "]"), (Object[])new Object[0]);
            }
            return null;
        }
        return new AbstractMap.SimpleEntry<String, String>(fullyQualifiedClassName, fullMethodSignature);
    }
}

