/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPrivateKey;
import com.ibm.ws.crypto.ltpakeyutil.LTPAPublicKey;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.OffsetDateTime;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LTPAValidationKeysInfo {
    private static final TraceComponent tc = Tr.register(LTPAValidationKeysInfo.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    String filename = null;
    private byte[] secretKey = null;
    private byte[] privateKey = null;
    private byte[] publicKey = null;
    private LTPAPrivateKey ltpaPrivateKey = null;
    private LTPAPublicKey ltpaPublicKey = null;
    OffsetDateTime validUntilDateOdt = null;
    static final long serialVersionUID = 4403524413646326284L;

    LTPAValidationKeysInfo(String filename, byte[] secretKey, byte[] privateKey, byte[] publicKey, OffsetDateTime validUntilDateOdt) {
        this.filename = filename;
        this.secretKey = secretKey;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
        this.validUntilDateOdt = validUntilDateOdt;
        this.ltpaPrivateKey = new LTPAPrivateKey(privateKey);
        this.ltpaPublicKey = new LTPAPublicKey(publicKey);
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public byte[] getprivateKey() {
        return this.privateKey;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public LTPAPrivateKey getLTPAPrivateKey() {
        return this.ltpaPrivateKey;
    }

    public LTPAPublicKey getLTPAPublicKey() {
        return this.ltpaPublicKey;
    }

    public boolean isValidUntilDateExpired() {
        if (this.validUntilDateOdt == null) {
            return false;
        }
        OffsetDateTime currentTime = OffsetDateTime.now(this.validUntilDateOdt.getOffset());
        if (this.validUntilDateOdt.isBefore(currentTime)) {
            Tr.warning((TraceComponent)tc, (String)"LTPA_VALIDATION_KEYS_VALID_UNTIL_DATE_IS_IN_THE_PAST", (Object[])new Object[]{this.validUntilDateOdt, this.filename});
            return true;
        }
        return false;
    }
}

