/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.region.management;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.eclipse.equinox.internal.region.RegionLifecycleListener;
import org.eclipse.equinox.internal.region.management.RegionObjectNameCreator;
import org.eclipse.equinox.internal.region.management.StandardManageableRegion;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.eclipse.equinox.region.management.ManageableRegion;
import org.eclipse.equinox.region.management.ManageableRegionDigraph;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class StandardManageableRegionDigraph
implements ManageableRegionDigraph {
    private final RegionDigraph regionDigraph;
    private final String domain;
    private final RegionObjectNameCreator regionObjectNameCreator;
    private final Map<String, ManageableRegion> manageableRegions = new ConcurrentHashMap<String, ManageableRegion>();
    private final BundleContext bundleContext;
    private final Object monitor = new Object();
    private final MBeanServer mbeanServer;
    private final ObjectName mbeanName;
    private ServiceRegistration<RegionLifecycleListener> listenerRegistration;
    private final String frameworkUUID;
    private final RegionLifecycleListener regionLifecycleListener = new RegionLifecycleListener(){

        @Override
        public void regionAdded(Region region) {
            StandardManageableRegionDigraph.this.addRegion(region);
        }

        @Override
        public void regionRemoving(Region region) {
            StandardManageableRegionDigraph.this.removeRegion(region);
        }
    };

    public StandardManageableRegionDigraph(RegionDigraph regionDigraph, String domain, BundleContext bundleContext) {
        this.regionDigraph = regionDigraph;
        this.domain = domain;
        this.bundleContext = bundleContext;
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        this.frameworkUUID = bundleContext.getProperty("org.osgi.framework.uuid");
        this.regionObjectNameCreator = new RegionObjectNameCreator(domain, this.frameworkUUID);
        String name = String.valueOf(this.domain) + ":type=RegionDigraph";
        if (this.frameworkUUID != null) {
            name = String.valueOf(name) + ",frameworkUUID=" + this.frameworkUUID;
        }
        try {
            this.mbeanName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("Invalid domain name '" + domain + "' resulting in an invalid object name '" + name + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRegionLifecycleListener() {
        Object object = this.monitor;
        synchronized (object) {
            this.listenerRegistration = this.bundleContext.registerService(RegionLifecycleListener.class, (Object)this.regionLifecycleListener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterRegionLifecycleListener() {
        Object object = this.monitor;
        synchronized (object) {
            this.listenerRegistration.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMBean() {
        this.registerRegionLifecycleListener();
        Object object = this.monitor;
        synchronized (object) {
            Set<Region> regions = this.regionDigraph.getRegions();
            for (Region region : regions) {
                this.addRegion(region);
            }
        }
        this.safelyRegisterMBean(this, this.mbeanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMbean() {
        ArrayList<String> currentRegionNames;
        this.unregisterRegionLifecycleListener();
        Object object = this.monitor;
        synchronized (object) {
            currentRegionNames = new ArrayList<String>(this.manageableRegions.keySet());
        }
        for (String regionName : currentRegionNames) {
            this.removeRegion(regionName);
        }
        try {
            this.mbeanServer.unregisterMBean(this.mbeanName);
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException("Problem unregistering mbean", e);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    private void safelyRegisterMBean(Object mbean, ObjectName name) {
        try {
            try {
                this.mbeanServer.registerMBean(mbean, name);
            }
            catch (InstanceAlreadyExistsException e) {
                this.mbeanServer.unregisterMBean(name);
                this.mbeanServer.registerMBean(mbean, name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MBean registration failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManageableRegion[] getRegions() {
        ArrayList<ManageableRegion> regions = new ArrayList<ManageableRegion>();
        Object object = this.monitor;
        synchronized (object) {
            for (ManageableRegion manageableRegion : this.manageableRegions.values()) {
                regions.add(manageableRegion);
            }
        }
        return regions.toArray(new ManageableRegion[regions.size()]);
    }

    @Override
    public ManageableRegion getRegion(String regionName) {
        return this.manageableRegions.get(regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRegion(Region region) {
        StandardManageableRegion manageableRegion = new StandardManageableRegion(region, this, this.regionDigraph);
        this.safelyRegisterMBean(manageableRegion, this.regionObjectNameCreator.getRegionObjectName(region.getName()));
        Object object = this.monitor;
        synchronized (object) {
            this.manageableRegions.put(region.getName(), manageableRegion);
        }
    }

    void removeRegion(Region region) {
        this.removeRegion(region.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRegion(String regionName) {
        Object object = this.monitor;
        synchronized (object) {
            this.manageableRegions.remove(regionName);
        }
        try {
            this.mbeanServer.unregisterMBean(this.regionObjectNameCreator.getRegionObjectName(regionName));
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            throw new RuntimeException("Problem unregistering mbean", e);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }
}

