/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils.ras;

import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AbstractSuppressor {
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private static final long MAXIMUM_INTERVAL = 86400000L;
    private ConcurrentMap<String, Details> _emitMessageKeyAndInsertsTime = new ConcurrentHashMap<String, Details>();
    private long _extraTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SibTr.Suppressor.Decision suppress(String key, String variant) {
        Details newDetails;
        SibTr.Suppressor.Decision decision = SibTr.Suppressor.Decision.makeDecision(key, variant);
        Details details = (Details)this._emitMessageKeyAndInsertsTime.get(key);
        if (details == null && (details = this._emitMessageKeyAndInsertsTime.putIfAbsent(key, newDetails = new Details(this.getNow(), this.getInterval()))) == null) {
            if (this.getInterval() == Long.MAX_VALUE) {
                decision.suppressFutureMesages(-1);
                return decision;
            }
            decision.suppressFutureMesages((int)(this.getInterval() / 60000L));
            return decision;
        }
        Details details2 = details;
        synchronized (details2) {
            if (details.getInterval() == Long.MAX_VALUE) {
                decision.suppressThisMessage();
                return decision;
            }
            long now = this.getNow();
            long interval = now - details.getEmitTime();
            if (interval > details.getInterval()) {
                int suppressedMessageCount = details.getNumberOfSuppressions();
                if (suppressedMessageCount == 0) {
                    details.resetInterval();
                } else if (suppressedMessageCount == 1) {
                    decision.reportEarlierSuppressedMessages(suppressedMessageCount, details.getFirstSuppressionTime(), details.getMostRecentSuppressionTime());
                    details.resetInterval();
                } else {
                    decision.reportEarlierSuppressedMessages(suppressedMessageCount, details.getFirstSuppressionTime(), details.getMostRecentSuppressionTime());
                    details.doubleInterval();
                }
                details.resetEmitTime(now);
                decision.suppressFutureMesages((int)(details.getInterval() / 60000L));
                return decision;
            }
            details.incrementInstances(now);
            decision.suppressThisMessage();
            return decision;
        }
    }

    protected long getInterval() {
        return Long.MAX_VALUE;
    }

    public void pretendTimeElapsed(int minutes) {
        this._extraTime += (long)minutes;
    }

    private long getNow() {
        return System.currentTimeMillis() + this._extraTime * 60000L;
    }

    protected String getMessageNumber(String message) {
        return message.substring(0, 10);
    }

    private static class Details {
        private long _lastEmitTime;
        private int _suppressions = 0;
        private final long _standardInterval;
        private long _interval;
        private long _firstSuppression;
        private long _mostRecentSuppression;

        public Details(long initialEmitTime, long standardInterval) {
            this.resetEmitTime(initialEmitTime);
            this._standardInterval = standardInterval;
            this.resetInterval();
        }

        public void resetEmitTime(long newEmitTime) {
            this._lastEmitTime = newEmitTime;
            this._suppressions = 0;
        }

        public long getEmitTime() {
            return this._lastEmitTime;
        }

        public void incrementInstances(long now) {
            if (this._suppressions == 0) {
                this._firstSuppression = now;
            }
            ++this._suppressions;
            this._mostRecentSuppression = now;
        }

        public int getNumberOfSuppressions() {
            return this._suppressions;
        }

        public long getInterval() {
            return this._interval;
        }

        protected void doubleInterval() {
            this._interval *= 2L;
            if (this._interval > 86400000L) {
                this._interval = 86400000L;
            }
        }

        protected void resetInterval() {
            this._interval = this._standardInterval;
        }

        public long getFirstSuppressionTime() {
            return this._firstSuppression;
        }

        public long getMostRecentSuppressionTime() {
            return this._mostRecentSuppression;
        }
    }
}

