/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jaspi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.jaspi.PersistenceManager;
import com.ibm.ws.security.jaspi.client.JaspiConfig;
import com.ibm.ws.security.jaspi.client.JaspiProvider;
import com.ibm.ws.security.jaspi.client.ObjectFactory;
import com.ibm.ws.security.jaspi.client.Option;
import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class XMLJaspiConfiguration
implements PersistenceManager {
    private static final TraceComponent tc = Tr.register(XMLJaspiConfiguration.class, (String)"Security", null);
    private AuthConfigFactory registry;
    private File configFile;
    private JaspiConfig jaspiConfig = new ObjectFactory().createJaspiConfig();
    static final long serialVersionUID = 4147969557367210066L;

    @Override
    public void setAuthConfigFactory(AuthConfigFactory factory) {
        this.registry = factory;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AuthConfigFactory = " + factory), (Object[])new Object[0]);
        }
    }

    @Override
    public AuthConfigFactory getAuthConfigFactory() {
        return this.registry;
    }

    @Override
    public File getFile() {
        return this.configFile;
    }

    @Override
    public void setFile(File file) {
        this.configFile = file;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Jaspi configuration of persistent providers will be stored in file: " + file), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void load() {
        if (this.isEnabled()) {
            try {
                if (this.configFile != null && this.configFile.exists()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("persistent config file found: " + this.configFile), (Object[])new Object[0]);
                    }
                    this.jaspiConfig = this.readConfigFile(this.configFile);
                    this.registerPersistentProviders();
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("persistent config file not found: " + this.configFile + ", creating new file"), (Object[])new Object[0]);
                    }
                    this.jaspiConfig = new JaspiConfig();
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                void e;
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.jaspi.XMLJaspiConfiguration", (String)"148", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".load"), (String)"143", (Object)this);
                throw new RuntimeException("Unable to load " + this.configFile, (Throwable)e);
            }
        }
    }

    @Override
    @ManualTrace
    public void registerProvider(String className, Map<String, String> properties, String layer, String appContext, String description) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerProvider", (Object[])new Object[]{"className=" + className, "msgLayer=" + layer, "appContext=" + appContext, "description=" + description, "properties=" + properties});
        }
        if (this.isEnabled()) {
            String providerName = layer + "_" + (appContext == null ? null : appContext.replace(' ', '_'));
            JaspiProvider provider = this.getJaspiProvider(layer, appContext);
            if (provider == null) {
                provider = new ObjectFactory().createJaspiProvider();
                this.jaspiConfig.getJaspiProvider().add(provider);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("A new provider will be added in " + this.configFile), (Object[])new Object[0]);
                }
            }
            provider.setProviderName(providerName);
            provider.setClassName(className);
            provider.setMsgLayer(layer);
            provider.setAppContext(appContext);
            provider.setDescription(description);
            this.setProperties(provider, properties);
            this.writeConfigFile(this.jaspiConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerProvider");
        }
    }

    @Override
    @ManualTrace
    public void removeProvider(String layer, String appContext) {
        JaspiProvider provider;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeProvider", (Object[])new Object[]{"msgLayer=" + layer, "appContext=" + appContext});
        }
        if (this.isEnabled() && (provider = this.getJaspiProvider(layer, appContext)) != null) {
            this.jaspiConfig.getJaspiProvider().remove(provider);
            this.writeConfigFile(this.jaspiConfig);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeProvider");
        }
    }

    @Override
    @ManualTrace
    public JaspiProvider getJaspiProvider(String layer, String appContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getJaspiProvider", (Object[])new Object[]{"layer=" + layer, "appContext=" + appContext});
        }
        JaspiProvider provider = null;
        if (this.jaspiConfig != null) {
            for (JaspiProvider p : this.jaspiConfig.getJaspiProvider()) {
                boolean isSameCtx;
                String pLayer = p.getMsgLayer();
                String pCtx = p.getAppContext();
                boolean isSameLayer = layer != null && layer.equals(pLayer) || layer == null && pLayer == null;
                boolean bl = isSameCtx = appContext != null && appContext.equals(pCtx) || appContext == null && pCtx == null;
                if (!isSameLayer || !isSameCtx) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Found a matching provider", (Object[])new Object[]{"className=" + p.getClassName(), "description=" + p.getDescription(), "properties=" + this.convertOptionsToMap(p.getOption())});
                }
                provider = p;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getJaspiProvider", provider);
        }
        return provider;
    }

    private boolean isEnabled() {
        return true;
    }

    @ManualTrace
    private void registerPersistentProviders() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerPersistentProviders", (Object[])new Object[0]);
        }
        if (this.jaspiConfig != null) {
            for (JaspiProvider p : this.jaspiConfig.getJaspiProvider()) {
                String className = p.getClassName();
                String desc = p.getDescription();
                String layer = p.getMsgLayer();
                String appContext = p.getAppContext();
                Map<String, String> props = this.convertOptionsToMap(p.getOption());
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Register persistent provider", (Object[])new Object[]{"className=" + className, "msgLayer=" + layer, "appContext=" + appContext, "description=" + desc, "properties=" + props});
                }
                if (this.registry == null) continue;
                this.registry.registerConfigProvider(className, props, layer, appContext, desc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerPersistentProviders");
        }
    }

    @ManualTrace
    private synchronized JaspiConfig readConfigFile(final File configFile) throws PrivilegedActionException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readConfigFile", (Object[])new Object[]{configFile});
        }
        if (configFile == null) {
            // empty if block
        }
        PrivilegedExceptionAction<JaspiConfig> unmarshalFile = new PrivilegedExceptionAction<JaspiConfig>(){
            static final long serialVersionUID = 766584496826777146L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public JaspiConfig run() throws Exception {
                JaspiConfig cfg = null;
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{JaspiConfig.class});
                Object obj = jc.createUnmarshaller().unmarshal(configFile);
                if (obj instanceof JaspiConfig) {
                    cfg = (JaspiConfig)obj;
                }
                return cfg;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.XMLJaspiConfiguration$1", 1.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
            }
        };
        JaspiConfig jaspi = AccessController.doPrivileged(unmarshalFile);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readConfigFile", (Object)jaspi);
        }
        return jaspi;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private synchronized void writeConfigFile(final JaspiConfig jaspiConfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeConfigFile", (Object[])new Object[]{jaspiConfig});
        }
        if (this.configFile == null) {
            // empty if block
        }
        PrivilegedExceptionAction<Object> marshalFile = new PrivilegedExceptionAction<Object>(){
            static final long serialVersionUID = 1897395688670204260L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() throws Exception {
                JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{JaspiConfig.class});
                Marshaller writer = jc.createMarshaller();
                writer.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                writer.marshal((Object)jaspiConfig, XMLJaspiConfiguration.this.configFile);
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.jaspi.XMLJaspiConfiguration$2", 2.class, (String)"security", (String)"com.ibm.ws.security.jaspi.internal.resources.JaspiMessages");
            }
        };
        try {
            AccessController.doPrivileged(marshalFile);
        }
        catch (PrivilegedActionException privilegedActionException) {
            void e;
            FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.jaspi.XMLJaspiConfiguration", (String)"313", (Object)this, (Object[])new Object[]{jaspiConfig});
            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".writeConfigFile"), (String)"290", (Object)this);
            throw new RuntimeException("Unable to write " + this.configFile, (Throwable)e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"writeConfigFile");
        }
    }

    @ManualTrace
    private Map<String, String> convertOptionsToMap(List<Option> opts) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convertOptionsToMap", (Object[])new Object[]{opts});
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (opts != null) {
            for (Option opt : opts) {
                properties.put(opt.getName(), opt.getValue());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertOptionsToMap", properties);
        }
        return properties;
    }

    @ManualTrace
    private void setProperties(JaspiProvider provider, Map<String, String> properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setProperties", (Object[])new Object[]{provider, properties});
        }
        List<Option> options = provider.getOption();
        options.clear();
        if (properties != null) {
            Set<String> keys = properties.keySet();
            for (String obj : keys) {
                if (!(obj instanceof String)) continue;
                String key = obj;
                String value = properties.get(key);
                Option prop = new ObjectFactory().createOption();
                options.add(prop);
                prop.setName(key);
                prop.setValue(value);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Setting provider propperty key=" + key + ", value=" + value), (Object[])new Object[0]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProperties");
        }
    }
}

