/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.zipkin.internal;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.time.Duration;

public class ZipkinSpanExporterProvider
implements ConfigurableSpanExporterProvider {
    @Override
    public String getName() {
        return "zipkin";
    }

    @Override
    public SpanExporter createExporter(ConfigProperties config) {
        Duration timeout;
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        String endpoint = config.getString("otel.exporter.zipkin.endpoint");
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        if ((timeout = config.getDuration("otel.exporter.zipkin.timeout")) != null) {
            builder.setReadTimeout(timeout);
        }
        return builder.build();
    }
}

