/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.persistence.dispatcher;

import com.ibm.ws.sib.msgstore.persistence.dispatcher.StateUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

final class DispatcherState {
    static final StateUtils.StateUpdater<DispatcherState> updaterForStart = state -> state.startRequested().running(true);
    static final StateUtils.StateUpdater<DispatcherState> updaterForStopped = state -> state.running(false);
    static final StateUtils.StateUpdater<DispatcherState> updaterForErrorOccurred = DispatcherState::addThreadWriteError;
    static final StateUtils.StateUpdater<DispatcherState> updaterForErrorCleared = DispatcherState::clearThreadWriteError;
    final boolean isRunning;
    final boolean isStopRequested;
    final int threadWriteErrors;
    final Throwable requester;

    static StateUtils.StateUpdater<DispatcherState> getUpdaterForStopRequested(Throwable requester) {
        return state -> state.isRunning ? state.stopRequested(new StopRequesterInfo(requester)) : state;
    }

    DispatcherState() {
        this(false, false, 0, null);
    }

    private DispatcherState(boolean running, boolean stopRequested, int threadWriteErrors, Throwable requester) {
        this.isRunning = running;
        this.isStopRequested = stopRequested;
        this.threadWriteErrors = threadWriteErrors;
        this.requester = requester;
    }

    private DispatcherState running(boolean running) {
        return running == this.isRunning ? this : new DispatcherState(running, this.isStopRequested, this.threadWriteErrors, this.requester);
    }

    DispatcherState startRequested() {
        return this.isStopRequested ? new DispatcherState(this.isRunning, false, this.threadWriteErrors, null) : this;
    }

    private DispatcherState stopRequested(Throwable requester) {
        return this.isStopRequested ? this : new DispatcherState(this.isRunning, true, this.threadWriteErrors, requester);
    }

    private DispatcherState addThreadWriteError() {
        return new DispatcherState(this.isRunning, this.isStopRequested, this.threadWriteErrors + 1, this.requester);
    }

    private DispatcherState clearThreadWriteError() {
        return 0 >= this.threadWriteErrors ? this : new DispatcherState(this.isRunning, this.isStopRequested, this.threadWriteErrors - 1, this.requester);
    }

    boolean isHealthy() {
        return this.isRunning && !this.isStopRequested && 0 == this.threadWriteErrors;
    }

    String desc() {
        StringBuilder sb = new StringBuilder();
        if (this.isStopRequested) {
            sb.append(" (STOP REQUESTED)");
        }
        if (!this.isRunning) {
            sb.append(" (STOPPED)");
        }
        if (0 < this.threadWriteErrors) {
            sb.append(" (ERROR (").append(this.threadWriteErrors).append("))");
        }
        if (null != this.requester) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.requester.printStackTrace(pw.printf("%n", new Object[0]));
            sb.append(sw);
        }
        return sb.toString();
    }

    public static final class StopRequesterInfo
    extends Throwable {
        private static final long serialVersionUID = 1L;
        private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yy.MM.dd_HH.mm.ss.SSS_Z");

        public StopRequesterInfo(Throwable requester) {
            super("Stop requested at " + DATE_FORMATTER.format(OffsetDateTime.now()), requester);
        }
    }
}

