/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

public class ResourceParameters {
    static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\{(\\w[\\w\\.-]*)\\}");
    private List<String> pathItemPaths;
    private List<Parameter> pathItemParameters;
    private List<String> operationPaths;
    private List<Parameter> operationParameters;
    private Content formBodyContent;

    private static int position(List<Parameter> preferredOrder, Parameter p) {
        int pos = preferredOrder.indexOf(p);
        return pos >= 0 ? pos : Integer.MAX_VALUE;
    }

    public static Comparator<Parameter> parameterComparator(List<Parameter> preferredOrder) {
        Comparator<Parameter> primaryComparator;
        if (preferredOrder != null) {
            Comparator preferredComparator = (p1, p2) -> Integer.compare(ResourceParameters.position(preferredOrder, p1), ResourceParameters.position(preferredOrder, p2));
            primaryComparator = preferredComparator.thenComparing(Reference::getRef, Comparator.nullsFirst(Comparator.naturalOrder()));
        } else {
            primaryComparator = Comparator.comparing(Reference::getRef, Comparator.nullsFirst(Comparator.naturalOrder()));
        }
        return primaryComparator.thenComparing(Parameter::getIn, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Parameter::getName, Comparator.nullsLast(Comparator.naturalOrder()));
    }

    public List<Parameter> getPathItemParameters() {
        return this.pathItemParameters;
    }

    public List<String> getOperationPaths() {
        return this.operationPaths;
    }

    public List<String> getFullOperationPaths() {
        return this.pathItemPaths.stream().flatMap(pathItemPath -> this.operationPaths.stream().map(operationPath -> pathItemPath + operationPath)).collect(Collectors.toList());
    }

    public List<Parameter> getOperationParameters() {
        return this.operationParameters;
    }

    public void addOperationParameter(Parameter parameter) {
        if (this.operationParameters == null) {
            this.operationParameters = new ArrayList<Parameter>();
        }
        this.operationParameters.add(parameter);
    }

    public Content getFormBodyContent() {
        return this.formBodyContent;
    }

    public Schema getFormBodySchema() {
        if (this.formBodyContent != null) {
            return ((MediaType)this.formBodyContent.getMediaTypes().values().iterator().next()).getSchema();
        }
        return null;
    }

    public List<Parameter> getAllParameters() {
        ArrayList<Parameter> all = new ArrayList<Parameter>();
        if (this.pathItemParameters != null) {
            all.addAll(this.pathItemParameters);
        }
        if (this.operationParameters != null) {
            all.addAll(this.operationParameters);
        }
        return all;
    }

    public void setPathItemPaths(List<String> pathItemPaths) {
        this.pathItemPaths = pathItemPaths;
    }

    public void setPathItemParameters(List<Parameter> pathItemParameters) {
        this.pathItemParameters = pathItemParameters;
    }

    public void setOperationPaths(List<String> operationPaths) {
        this.operationPaths = operationPaths;
    }

    public void setOperationParameters(List<Parameter> operationParameters) {
        this.operationParameters = operationParameters;
    }

    public void setFormBodyContent(Content formBodyContent) {
        this.formBodyContent = formBodyContent;
    }

    public void sort(Comparator<Parameter> comparator) {
        if (this.pathItemParameters != null) {
            this.pathItemParameters.sort(comparator);
        }
        if (this.operationParameters != null) {
            this.operationParameters.sort(comparator);
        }
    }

    public List<String> getPathParameterTemplateNames() {
        return this.pathItemPaths.stream().flatMap(pathItemPath -> this.operationPaths.stream().flatMap(operationPath -> ResourceParameters.getPathParameterTemplateName(pathItemPath, operationPath).stream())).distinct().collect(Collectors.toList());
    }

    private static List<String> getPathParameterTemplateName(String ... paths) {
        ArrayList<String> templateNames = new ArrayList<String>();
        for (String path : paths) {
            Matcher m = TEMPLATE_PARAM_PATTERN.matcher(path);
            while (m.find()) {
                templateNames.add(m.group(1));
            }
        }
        return templateNames;
    }
}

