/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.impl.ConsumerSessionImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.StoppableAsynchConsumerCallback;

public final class AsynchConsumer {
    private AsynchConsumerCallback asynchConsumerCallback = null;
    private boolean asynchConsumerRunning = false;
    private static final TraceComponent tc = SibTr.register(AsynchConsumer.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    void registerCallback(AsynchConsumerCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerCallback", (Object)callback);
        }
        this.asynchConsumerCallback = callback;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMsgs(LockedMessageEnumeration msgEnumeration, ConsumerSession consumerSession) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processMsgs", (Object)new Object[]{msgEnumeration, consumerSession});
        }
        this.asynchConsumerRunning = true;
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Entering asynchConsumerCallback.consumeMessages", (Object)new Object[]{this.asynchConsumerCallback, msgEnumeration});
            }
            this.asynchConsumerCallback.consumeMessages(msgEnumeration);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Exiting asynchConsumerCallback.consumeMessages");
            }
        }
        catch (Throwable e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AsynchConsumer.processMsgs", (String)"1:124:1.37", (Object)this);
            if (consumerSession != null) {
                try {
                    this.notifyExceptionListeners(e, consumerSession);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (e instanceof Exception) {
                SibTr.exception((TraceComponent)tc, (Exception)((Exception)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Exception occurred in consumeMessages " + e));
            }
            if (e instanceof ThreadDeath) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"processMsgs", (Object)e);
                }
                throw (ThreadDeath)e;
            }
        }
        finally {
            this.asynchConsumerRunning = false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processMsgs");
        }
    }

    boolean isAsynchConsumerRunning() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAsynchConsumerRunning");
            SibTr.exit((TraceComponent)tc, (String)"isAsynchConsumerRunning", (Object)new Boolean(this.asynchConsumerRunning));
        }
        return this.asynchConsumerRunning;
    }

    void notifyExceptionListeners(Throwable coreException, ConsumerSession consumerSession) {
        block7: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"notifyExceptionListeners", (Object)new Object[]{coreException, consumerSession});
            }
            if (consumerSession != null) {
                try {
                    ConsumerSessionImpl consumerImpl = (ConsumerSessionImpl)consumerSession;
                    SICoreConnection connection = consumerImpl.getConnectionInternal();
                    SICoreConnectionListener[] listeners = connection.getConnectionListeners();
                    for (int listenerIndex = 0; listenerIndex < listeners.length; ++listenerIndex) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)"Entering SICoreConnectionListener.asynchronousException", (Object)new Object[]{listeners[listenerIndex], consumerSession, coreException});
                        }
                        listeners[listenerIndex].asynchronousException(consumerSession, coreException);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)"Exiting SICoreConnectionListener.asynchronousException");
                    }
                }
                catch (Exception connectionClosed) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    SibTr.debug((TraceComponent)tc, (String)("Exception occurred in asynchronousException " + connectionClosed));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyExceptionListeners");
        }
    }

    void consumerSessionStopped() {
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"consumerSessionStopped");
            }
            try {
                if (this.asynchConsumerCallback instanceof StoppableAsynchConsumerCallback) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Entering asynchConsumerCallback.consumerSessionStopped", (Object)this.asynchConsumerCallback);
                    }
                    ((StoppableAsynchConsumerCallback)this.asynchConsumerCallback).consumerSessionStopped();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Exiting asynchConsumerCallback.consumerSessionStopped");
                    }
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.AsynchConsumer.consumerSessionStopped", (String)"1:264:1.37", (Object)this);
                if (e instanceof Exception) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Exception)e));
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Exception occurred in consumerSessionStopped " + e));
                }
                if (!(e instanceof ThreadDeath)) break block10;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"consumerSessionStopped", (Object)e);
                }
                throw (ThreadDeath)e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consumerSessionStopped");
        }
    }
}

