/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webcontainer.srt.ISRTServletRequest;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainer;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EncodingUtils {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.EncodingUtils";
    private static final Map<String, Charset> supportedEncodingsCache = new ConcurrentHashMap<String, Charset>();
    private static final Charset NOT_FOUND = new Charset("not_found", new String[0]){

        @Override
        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Charset cs) {
            throw new UnsupportedOperationException();
        }
    };
    public static final boolean setContentTypeBySetHeader;
    private static final Hashtable localesCache;
    private static Locale cachedLocale;
    private static String cachedEncoding;

    public static String getCharsetFromContentType(String type) {
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi == -1) {
            return null;
        }
        String afterSemi = type.substring(semi + 1);
        int charsetLocation = afterSemi.indexOf("charset=");
        if (charsetLocation == -1) {
            return null;
        }
        return afterSemi.substring(charsetLocation + 8).trim();
    }

    public static Vector getLocales(HttpServletRequest req) {
        String acceptLanguage = ISRTServletRequest.getHeader(req, HttpHeaderKeys.HDR_ACCEPT_LANGUAGE);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocales", "Accept-Language --> " + acceptLanguage);
        }
        if (acceptLanguage == null || acceptLanguage.trim().length() == 0) {
            Vector<Locale> def = new Vector<Locale>();
            def.addElement(Locale.getDefault());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "getLocales", "processed Locales --> ", def);
            }
            return def;
        }
        Vector langList = null;
        langList = (Vector)localesCache.get(acceptLanguage);
        if (langList == null) {
            langList = EncodingUtils.processAcceptLanguage(acceptLanguage);
            langList = WCCustomProperties.VALIDATE_LOCALE_VALUES ? EncodingUtils.extractLocales(langList, true) : EncodingUtils.extractLocales(langList, false);
            localesCache.put(acceptLanguage, langList);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getLocales", "processed Locales --> " + langList);
        }
        return langList;
    }

    public static Vector processAcceptLanguage(String acceptLanguage) {
        StringTokenizer languageTokenizer = new StringTokenizer(acceptLanguage, ",");
        TreeMap map = new TreeMap(Collections.reverseOrder());
        while (languageTokenizer.hasMoreTokens()) {
            String language = languageTokenizer.nextToken().trim();
            if (language == null || language.length() == 0) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                logger.logp(Level.FINE, CLASS_NAME, "processAcceptLanguage", "Encountered zero length language token without quality index.. skipping token");
                logger.logp(Level.FINE, CLASS_NAME, "processAcceptLanguage", "acceptLanguage param = [" + acceptLanguage + "]");
                continue;
            }
            int semicolonIndex = language.indexOf(59);
            Double qValue = new Double(1.0);
            if (semicolonIndex > -1) {
                int qIndex = language.indexOf("q=");
                String qValueStr = language.substring(qIndex + 2);
                try {
                    qValue = new Double(qValueStr.trim());
                }
                catch (NumberFormatException nfe) {
                    FFDCWrapper.processException(nfe, "com.ibm.ws.webcontainer.srt.SRTRequestUtils.processAcceptLanguage", "215");
                }
                language = language.substring(0, semicolonIndex);
            }
            if (language.length() > 0) {
                if (!(qValue > 0.0) || language.charAt(0) == '*') continue;
                Vector newVector = new Vector();
                if (map.containsKey(qValue)) {
                    newVector = (Vector)map.get(qValue);
                }
                newVector.addElement(language);
                map.put(qValue, newVector);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
            logger.logp(Level.FINE, CLASS_NAME, "processAcceptLanguage", "Encountered zero length language token with quality index.. skipping token");
            logger.logp(Level.FINE, CLASS_NAME, "processAcceptLanguage", "acceptLanguage param = [" + acceptLanguage + "]");
        }
        if (map.isEmpty()) {
            Vector<String> v = new Vector<String>();
            v.addElement(Locale.getDefault().toString());
            map.put("1", v);
        }
        return new Vector(map.values());
    }

    public static Vector extractLocales(Vector languages) {
        return EncodingUtils.extractLocales(languages, false);
    }

    public static Vector extractLocales(Vector languages, boolean secure) {
        Enumeration e = languages.elements();
        Vector<Locale> l = new Vector<Locale>();
        while (e.hasMoreElements()) {
            Vector langVector = (Vector)e.nextElement();
            Enumeration enumeration = langVector.elements();
            while (enumeration.hasMoreElements()) {
                String language = (String)enumeration.nextElement();
                String country = "";
                String variant = "";
                int countryIndex = language.indexOf("-");
                if (countryIndex > -1) {
                    country = language.substring(countryIndex + 1).trim();
                    language = language.substring(0, countryIndex).trim();
                    int variantIndex = country.indexOf("-");
                    if (variantIndex > -1) {
                        variant = country.substring(variantIndex + 1).trim();
                        country = country.substring(0, variantIndex).trim();
                    }
                }
                if (secure) {
                    if (country.trim().length() != 0 && !EncodingUtils.isValueAlphaNumeric(country, "country") || language.trim().length() != 0 && !EncodingUtils.isValueAlphaNumeric(language, "language")) {
                        language = Locale.getDefault().getLanguage();
                        country = Locale.getDefault().getCountry();
                        variant = "";
                    }
                    if (variant.trim().length() != 0 && !EncodingUtils.isValueAlphaNumeric(variant, "variant")) {
                        variant = "";
                    }
                }
                l.addElement(new Locale(language, country, variant));
            }
        }
        return l;
    }

    private static boolean isValueAlphaNumeric(String input, String caller) {
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (Character.isLetterOrDigit(ch) || caller.equalsIgnoreCase("variant") && (ch == '-' || ch == '_')) continue;
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "isValueAlphaNumeric", "Encountered incorrect value [" + ch + "] .. in this token [" + caller + "]");
            }
            return false;
        }
        return true;
    }

    public static String getEncodingFromLocale(Locale locale) {
        com.ibm.wsspi.http.EncodingUtils encodingUtils;
        if (locale == cachedLocale) {
            return cachedEncoding;
        }
        String encoding = null;
        if (encoding == null && (encodingUtils = com.ibm.ws.webcontainer.osgi.WebContainer.getEncodingUtils()) != null) {
            encoding = encodingUtils.getEncodingFromLocale(locale);
        }
        cachedEncoding = encoding;
        cachedLocale = locale;
        return encoding;
    }

    public static String getJvmConverter(String encoding) {
        String converter = null;
        com.ibm.wsspi.http.EncodingUtils encodingUtils = com.ibm.ws.webcontainer.osgi.WebContainer.getEncodingUtils();
        if (encodingUtils != null) {
            converter = encodingUtils.getJvmConverter(encoding);
        }
        if (converter != null) {
            return converter;
        }
        return encoding;
    }

    public static boolean isCharsetSupported(String charset) {
        return EncodingUtils.getCharsetForName(charset) != null;
    }

    public static Charset getCharsetForName(String name) {
        Charset charset = supportedEncodingsCache.get(name);
        if (charset == null) {
            try {
                charset = Charset.forName(name);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                charset = NOT_FOUND;
            }
            supportedEncodingsCache.put(name, charset);
        }
        if (charset == NOT_FOUND && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getCharsetForName", "Encountered UnsupportedEncoding charset [" + name + "]");
        }
        return charset == NOT_FOUND ? null : charset;
    }

    public static void setContentTypeByCustomProperty(String type, String matchString, HttpServletResponse resp) {
        if (type == null) {
            type = matchString.endsWith(".html") || matchString.endsWith(".htm") ? "text/html" : "text/plain";
        }
        if (setContentTypeBySetHeader) {
            resp.setHeader("Content-Type", type);
        } else {
            resp.setContentType(type);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setContentTypeByCustomProperty", "setContentType --> " + type);
        }
    }

    static {
        String propStr = WebContainer.getWebContainerProperties().getProperty("com.ibm.ws.webcontainer.setcontenttypebysetheader");
        setContentTypeBySetHeader = propStr == null || propStr.equalsIgnoreCase("true");
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "staticInitializer", "setContentTypeBySetHeader=" + Boolean.toString(setContentTypeBySetHeader));
        }
        localesCache = new Hashtable();
        cachedLocale = null;
        cachedEncoding = null;
    }
}

