/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence.service;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rsadapter.jdbc.WSJdbcDataSource;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.wsspi.application.Application;
import com.ibm.wsspi.application.ApplicationState;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.persistence.DDLGenerationParticipant;
import com.ibm.wsspi.persistence.DatabaseStore;
import com.ibm.wsspi.persistence.InMemoryMappingFile;
import com.ibm.wsspi.persistence.PersistenceServiceUnit;
import com.ibm.wsspi.resource.ResourceConfig;
import com.ibm.wsspi.resource.ResourceFactory;
import io.openliberty.data.internal.persistence.DataProvider;
import io.openliberty.data.internal.persistence.EntityManagerBuilder;
import io.openliberty.data.internal.persistence.Util;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import io.openliberty.data.internal.persistence.service.ClassDefiner;
import io.openliberty.data.internal.persistence.service.RecordTransformer;
import io.openliberty.data.internal.persistence.service.ResRefDelegator;
import jakarta.data.exceptions.DataException;
import jakarta.data.exceptions.MappingException;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.Convert;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Embedded;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Table;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class DBStoreEMBuilder
extends EntityManagerBuilder
implements DDLGenerationParticipant {
    private static final long MAX_WAIT_FOR_SERVICE_NS = TimeUnit.SECONDS.toNanos(60L);
    private static final Map.Entry<String, String> ID_AND_VERSION_NOT_SPECIFIED = new AbstractMap.SimpleImmutableEntry<Object, Object>(null, null);
    private static final TraceComponent tc = Tr.register(DBStoreEMBuilder.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final ClassDefiner classDefiner = new ClassDefiner();
    private final String databaseStoreId;
    private final String configDisplayId;
    private final String dataSourceFactoryFilter;
    private final Map<Class<?>, Class<?>> generatedToRecordClass = new HashMap();
    private final PersistenceServiceUnit persistenceServiceUnit;
    static final long serialVersionUID = -2842846442609411524L;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DBStoreEMBuilder(DataProvider provider, ClassLoader repositoryClassLoader, Set<Class<?>> repositoryInterfaces, String dataStore, boolean isJNDIName, ComponentMetaData metadata, Set<Class<?>> entityTypes) throws Exception {
        super(provider, repositoryClassLoader, repositoryInterfaces, dataStore);
        Class clazz;
        Class<?> c;
        Object dbStoreId;
        ConcurrentHashMap<String, Configuration> dbStoreConfigurations;
        String module;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        String qualifiedName = null;
        boolean javaApp = false;
        boolean javaModule = false;
        boolean javaComp = false;
        J2EEName jeeName = metadata.getJ2EEName();
        String application = jeeName == null ? null : jeeName.getApplication();
        String string = module = jeeName == null ? null : jeeName.getModule();
        if (isJNDIName) {
            javaApp = dataStore.regionMatches(5, "app", 0, 3);
            javaModule = !javaApp && dataStore.regionMatches(5, "module", 0, 6);
            javaComp = !javaApp && !javaModule && dataStore.regionMatches(5, "comp", 0, 4);
            StringBuilder s = new StringBuilder(dataStore.length() + 80);
            if (application != null && (javaApp || javaModule || javaComp)) {
                s.append("application[").append(application).append(']').append('/');
                if (module != null && (javaModule || javaComp)) {
                    s.append("module[").append(module).append(']').append('/');
                }
            }
            qualifiedName = s.append("databaseStore[").append(dataStore).append(']').toString();
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("computed qualified dataStore name from JNDI name as " + qualifiedName), (Object[])new Object[0]);
            }
        }
        Configuration dbStoreConfig = (dbStoreConfigurations = provider.dbStoreConfigAllApps.get(application)) == null ? null : dbStoreConfigurations.get(isJNDIName ? qualifiedName : dataStore);
        Dictionary dbStoreConfigProps = dbStoreConfig == null ? null : dbStoreConfig.getProperties();
        Object object = dbStoreId = dbStoreConfigProps == null ? null : (String)dbStoreConfigProps.get("id");
        if (dbStoreId == null) {
            Object dsFactoryFilter = null;
            BundleContext bc = FrameworkUtil.getBundle(DatabaseStore.class).getBundleContext();
            ServiceReference dsRef = null;
            if (isJNDIName) {
                filter = new StringBuilder(200).append("(&(service.factoryPid=com.ibm.ws.jdbc.dataSource)");
                if (application != null && (javaApp || javaModule || javaComp)) {
                    ((StringBuilder)filter).append(FilterUtils.createPropertyFilter((String)"application", (String)application));
                }
                if (module != null && javaModule || javaComp) {
                    ((StringBuilder)filter).append(FilterUtils.createPropertyFilter((String)"module", (String)module));
                }
                ((StringBuilder)filter).append(FilterUtils.createPropertyFilter((String)"jndiName", (String)dataStore)).append(')');
                Collection dsRefs = bc.getServiceReferences(ResourceFactory.class, ((StringBuilder)filter).toString());
                if (!dsRefs.isEmpty()) {
                    dbStoreId = qualifiedName;
                    dsRef = (ServiceReference)dsRefs.iterator().next();
                }
            } else {
                filter = FilterUtils.createPropertyFilter((String)"id", (String)dataStore);
                Collection dbStoreRefs = bc.getServiceReferences(DatabaseStore.class, (String)filter);
                if (!dbStoreRefs.isEmpty()) {
                    dbStoreId = dataStore;
                    dsFactoryFilter = (String)((ServiceReference)dbStoreRefs.iterator().next()).getProperty("DataSourceFactory.target");
                } else {
                    filter = "(&(service.factoryPid=com.ibm.ws.jdbc.dataSource)" + FilterUtils.createPropertyFilter((String)"id", (String)dataStore) + ")";
                    Collection dsRefs = bc.getServiceReferences(ResourceFactory.class, (String)filter);
                    if (!dsRefs.isEmpty()) {
                        dbStoreId = "application[" + application + "]/databaseStore[" + dataStore + "]";
                        dsRef = (ServiceReference)dsRefs.iterator().next();
                    } else {
                        filter = "(&(service.factoryPid=com.ibm.ws.jdbc.dataSource)" + FilterUtils.createPropertyFilter((String)"jndiName", (String)dataStore) + ")";
                        dsRefs = bc.getServiceReferences(ResourceFactory.class, (String)filter);
                        if (!dsRefs.isEmpty()) {
                            dbStoreId = "application[" + application + "]/databaseStore[" + dataStore + "]";
                            dsRef = (ServiceReference)dsRefs.iterator().next();
                        }
                    }
                }
            }
            if (dbStoreId == null) {
                ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>> empty;
                ResRefDelegator delegator = new ResRefDelegator(dataStore, metadata);
                Hashtable<String, Object> svcProps = new Hashtable<String, Object>();
                dbStoreId = isJNDIName ? qualifiedName : "application[" + application + "]/databaseStore[" + dataStore + "]";
                String id = (String)dbStoreId + "/ResourceFactory";
                svcProps.put("id", id);
                svcProps.put("config.displayId", id);
                if (application != null) {
                    svcProps.put("application", application);
                }
                ServiceRegistration reg = bc.registerService(ResourceFactory.class, (Object)delegator, svcProps);
                dsRef = reg.getReference();
                ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>> registrations = provider.delegatorsAllApps.get(application);
                if (registrations == null && (registrations = (ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>>)provider.delegatorsAllApps.putIfAbsent(application, empty = new ConcurrentLinkedQueue<ServiceRegistration<ResourceFactory>>())) == null) {
                    registrations = empty;
                }
                registrations.add((ServiceRegistration<ResourceFactory>)reg);
            }
            if (dbStoreId != dataStore) {
                ConcurrentHashMap<String, Configuration> empty;
                if (dbStoreConfigurations == null && (dbStoreConfigurations = (ConcurrentHashMap<String, Configuration>)provider.dbStoreConfigAllApps.putIfAbsent(application, empty = new ConcurrentHashMap<String, Configuration>())) == null) {
                    dbStoreConfigurations = empty;
                }
                String dataSourceId = (String)dsRef.getProperty("id");
                boolean nonJTA = Boolean.FALSE.equals(dsRef.getProperty("transactional"));
                this.configDisplayId = dbStoreId;
                Hashtable<String, Object> svcProps = new Hashtable<String, Object>();
                svcProps.put("id", this.configDisplayId);
                svcProps.put("config.displayId", this.configDisplayId);
                dsFactoryFilter = dataSourceId == null ? "(jndiName=" + String.valueOf(dsRef.getProperty("jndiName")) + ")" : "(id=" + dataSourceId + ")";
                svcProps.put("DataSourceFactory.target", dsFactoryFilter);
                svcProps.put("AuthData.target", "(service.pid=${authDataRef})");
                svcProps.put("AuthData.cardinality.minimum", 0);
                svcProps.put("NonJTADataSourceFactory.cardinality.minimum", nonJTA ? 1 : 0);
                if (nonJTA) {
                    svcProps.put("NonJTADataSourceFactory.target", svcProps.get("DataSourceFactory.target"));
                } else {
                    svcProps.put("NonJTADataSourceFactory.target", "(&(service.pid=${nonTransactionalDataSourceRef})(transactional=false))");
                }
                svcProps.put("createTables", provider.createTables);
                svcProps.put("dropTables", provider.dropTables);
                svcProps.put("tablePrefix", "");
                svcProps.put("keyGenerationStrategy", "AUTO");
                dbStoreConfig = provider.configAdmin.createFactoryConfiguration("com.ibm.ws.persistence.databaseStore", bc.getBundle().getLocation());
                dbStoreConfig.update(svcProps);
                dbStoreConfigurations.put(isJNDIName ? qualifiedName : dataStore, dbStoreConfig);
            } else if (dsRef != null) {
                this.configDisplayId = (String)dsRef.getProperty("config.displayId");
                dsFactoryFilter = "(config.displayId=" + this.configDisplayId + ")";
            } else {
                this.configDisplayId = "databaseStore[" + (String)dbStoreId + "]";
            }
            this.dataSourceFactoryFilter = dsFactoryFilter;
        } else {
            this.dataSourceFactoryFilter = (String)dbStoreConfigProps.get("DataSourceFactory.target");
            this.configDisplayId = dbStoreId;
        }
        this.databaseStoreId = dbStoreId;
        BundleContext bc = FrameworkUtil.getBundle(DatabaseStore.class).getBundleContext();
        ServiceReference ref = null;
        long start = System.nanoTime();
        long poll_ms = 125L;
        while (ref == null) {
            String filter = FilterUtils.createPropertyFilter((String)"id", (String)this.databaseStoreId);
            Collection refs = bc.getServiceReferences(DatabaseStore.class, filter);
            if (refs.isEmpty()) {
                if (FrameworkState.isStopping()) {
                    throw DataExtension.exc(IllegalStateException.class, "CWWKD1113.server.stopping", Util.names(repositoryInterfaces));
                }
                if (application != null) {
                    filter = FilterUtils.createPropertyFilter((String)"name", (String)application);
                    Collection appRefs = bc.getServiceReferences(Application.class, filter);
                    if (appRefs.isEmpty()) {
                        throw DataExtension.exc(IllegalStateException.class, "CWWKD1115.app.unavailable", Util.names(repositoryInterfaces), application);
                    }
                    Iterator<Class<?>> state = ((ServiceReference)appRefs.iterator().next()).getProperty("application.state");
                    if (ApplicationState.STOPPED == state || ApplicationState.STOPPING == state) {
                        throw DataExtension.exc(IllegalStateException.class, "CWWKD1114.app.stopping", Util.names(repositoryInterfaces), application, state);
                    }
                }
                if (System.nanoTime() - start >= MAX_WAIT_FOR_SERVICE_NS) throw DataExtension.exc(IllegalStateException.class, "CWWKD1116.resource.unavailable", Util.names(repositoryInterfaces), this.configDisplayId, TimeUnit.NANOSECONDS.toSeconds(MAX_WAIT_FOR_SERVICE_NS));
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Wait " + poll_ms + " ms for service reference to become available..."), (Object[])new Object[0]);
                }
                TimeUnit.MILLISECONDS.sleep(poll_ms);
            } else {
                ref = (ServiceReference)refs.iterator().next();
            }
            poll_ms = poll_ms < 1000L ? poll_ms * 2L : 1000L;
        }
        String tablePrefix = (String)ref.getProperty("tablePrefix");
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)(this.configDisplayId + " databaseStore reference"), (Object[])new Object[]{ref});
        }
        ArrayList<InMemoryMappingFile> generatedEntities = new ArrayList<InMemoryMappingFile>();
        LinkedHashSet<String> entityClassNames = new LinkedHashSet<String>(entityTypes.size() * 2);
        LinkedHashSet<String> entityTableNames = new LinkedHashSet<String>(entityClassNames.size());
        LinkedList annotatedEntityClassQueue = new LinkedList();
        ArrayList<String> entityClassInfo = new ArrayList<String>(entityTypes.size());
        LinkedHashMap embeddableTypes = new LinkedHashMap();
        for (Class<?> c2 : entityTypes) {
            if (c2.isAnnotationPresent(Entity.class)) {
                annotatedEntityClassQueue.add(c2);
                continue;
            }
            String tableName = c2.getSimpleName();
            Class<?> ec = c2;
            if (c2.isRecord()) {
                this.disallowPersistenceAnnos(c2, true);
                String string2 = c2.getName() + "Entity";
                byte[] byArray = RecordTransformer.generateEntityClassBytes(c2, string2, jeeName, repositoryInterfaces);
                String string3 = string2.replace('.', '/') + ".class";
                generatedEntities.add(new InMemoryMappingFile(byArray, string3));
                ec = this.classDefiner.findLoadedOrDefineClass(this.getRepositoryClassLoader(), string2, byArray);
                this.generatedToRecordClass.put(ec, c2);
            } else {
                this.disallowPersistenceAnnos(c2, false);
            }
            StringBuilder stringBuilder = new StringBuilder(500);
            stringBuilder.append(" <entity class=\"").append(ec.getName()).append("\">").append(Util.EOLN);
            stringBuilder.append("  <table name=\"").append(tablePrefix).append(tableName).append("\"/>").append(Util.EOLN);
            this.writeAttributes(stringBuilder, this.findAttributes(c2), embeddableTypes);
            stringBuilder.append(" </entity>").append(Util.EOLN);
            entityClassInfo.add(stringBuilder.toString());
        }
        HashSet<Class> converterTypes = new HashSet<Class>();
        LinkedList annotatedEmbeddedClassQueue = new LinkedList();
        HashSet<void> embeddedClassesProcessed = new HashSet<void>();
        Object var33_41 = null;
        while ((c = (Class)annotatedEntityClassQueue.poll()) != null || (clazz = (Class)annotatedEmbeddedClassQueue.poll()) != null) {
            void var34_53;
            void var33_42;
            if (c != null) {
                if (entityClassNames.add(c.getName())) {
                    Table table = c.getAnnotation(Table.class);
                    String string4 = table == null || table.name().length() == 0 ? c.getSimpleName() : table.name();
                    entityTableNames.add(string4);
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("entity class " + c.getName() + " will use table " + string4), (Object[])new Object[0]);
                    }
                } else {
                    c = null;
                }
            } else if (var33_42 != null) {
                c = var33_42;
                embeddedClassesProcessed.add((void)c);
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("embedded class " + var33_42.getName()), (Object[])new Object[0]);
                }
            } else {
                c = null;
            }
            Class clazz2 = c;
            while (var34_53 != null && var34_53 != Object.class) {
                Convert convert;
                int n;
                int n2;
                Convert[] convertArray;
                for (Convert convert2 : (Convert[])var34_53.getAnnotationsByType(Convert.class)) {
                    if (convert2.converter() == null) continue;
                    converterTypes.add(convert2.converter());
                }
                for (Field field : var34_53.getDeclaredFields()) {
                    if (field.isAnnotationPresent(Embedded.class) || field.isAnnotationPresent(EmbeddedId.class)) {
                        if (field.getType().isAnnotationPresent(Embeddable.class)) {
                            annotatedEmbeddedClassQueue.add(field.getType());
                        } else {
                            c = this.getEmbeddableClass(field.getGenericType());
                            if (c != null) {
                                annotatedEmbeddedClassQueue.add(c);
                            }
                        }
                    } else if (field.getType().isAnnotationPresent(Entity.class)) {
                        annotatedEntityClassQueue.add(field.getType());
                    } else {
                        c = this.getEntityClass(field.getGenericType());
                        if (c != null) {
                            annotatedEntityClassQueue.add(c);
                        }
                    }
                    convertArray = (Convert[])field.getAnnotationsByType(Convert.class);
                    n2 = convertArray.length;
                    for (n = 0; n < n2; ++n) {
                        convert = convertArray[n];
                        if (convert.converter() == null) continue;
                        converterTypes.add(convert.converter());
                    }
                }
                for (Method method : var34_53.getDeclaredMethods()) {
                    if (method.isAnnotationPresent(Embedded.class) || method.isAnnotationPresent(EmbeddedId.class)) {
                        if (method.getReturnType().isAnnotationPresent(Embeddable.class)) {
                            annotatedEmbeddedClassQueue.add(method.getReturnType());
                        } else {
                            c = this.getEmbeddableClass(method.getGenericReturnType());
                            if (c != null) {
                                annotatedEmbeddedClassQueue.add(c);
                            }
                        }
                    } else if (method.getReturnType().isAnnotationPresent(Entity.class)) {
                        annotatedEntityClassQueue.add(method.getReturnType());
                    } else {
                        c = this.getEntityClass(method.getGenericReturnType());
                        if (c != null) {
                            annotatedEntityClassQueue.add(c);
                        }
                    }
                    convertArray = (Convert[])method.getAnnotationsByType(Convert.class);
                    n2 = convertArray.length;
                    for (n = 0; n < n2; ++n) {
                        convert = convertArray[n];
                        if (convert.converter() == null) continue;
                        converterTypes.add(convert.converter());
                    }
                }
                Class clazz3 = var34_53.getSuperclass();
            }
        }
        for (Map.Entry entry : embeddableTypes.entrySet()) {
            Class clazz4 = (Class)entry.getKey();
            Map map = (Map)entry.getValue();
            StringBuilder xml = new StringBuilder(500).append(" <embeddable class=\"").append(clazz4.getName()).append("\">").append(Util.EOLN);
            this.writeAttributes(xml, map, null);
            xml.append(" </embeddable>").append(Util.EOLN);
            entityClassInfo.add(xml.toString());
        }
        HashSet convertibleTypes = new HashSet();
        for (Class clazz5 : converterTypes) {
            StringBuilder stringBuilder = new StringBuilder(500).append(" <converter class=\"").append(clazz5.getName()).append("\"></converter>").append(Util.EOLN);
            entityClassInfo.add(stringBuilder.toString());
            for (Class c3 = clazz5; c3 != null; c3 = c3.getSuperclass()) {
                for (Type ifc : c3.getGenericInterfaces()) {
                    Type[] typeParams;
                    if (!(ifc instanceof ParameterizedType)) continue;
                    ParameterizedType type = (ParameterizedType)ifc;
                    if (!ifc.getTypeName().startsWith(Util.ATTR_CONVERTER_CLASS_NAME)) continue;
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("found converter: " + ifc.getTypeName()), (Object[])new Object[0]);
                    }
                    if (Util.UNSUPPORTED_ATTR_TYPES.contains((typeParams = type.getActualTypeArguments())[1])) {
                        throw DataExtension.exc(MappingException.class, "CWWKD1111.unsupported.convert", clazz5.getName(), typeParams[0].getTypeName(), typeParams[1].getTypeName(), Util.SUPPORTED_TEMPORAL_TYPES, Util.SUPPORTED_BASIC_TYPES);
                    }
                    if (!(typeParams[0] instanceof Class)) continue;
                    convertibleTypes.add((Class)typeParams[0]);
                }
            }
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("io.openliberty.persistence.internal.entityClassInfo", entityClassInfo.toArray(new String[entityClassInfo.size()]));
        hashMap.put("io.openliberty.persistence.internal.tableNames", entityTableNames);
        if (!generatedEntities.isEmpty()) {
            hashMap.put("io.openliberty.persistence.internal.generatedEntities", generatedEntities);
        }
        DatabaseStore databaseStore = (DatabaseStore)bc.getService(ref);
        this.persistenceServiceUnit = databaseStore.createPersistenceServiceUnit(this.getRepositoryClassLoader(), hashMap, entityClassNames.toArray(new String[entityClassNames.size()]));
        this.collectEntityInfo(entityTypes, convertibleTypes);
    }

    @Override
    @Trivial
    public EntityManager createEntityManager() {
        EntityManager em = this.persistenceServiceUnit.createEntityManager();
        em.setCacheRetrieveMode(CacheRetrieveMode.BYPASS);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("createEntityManager: " + String.valueOf(em)), (Object[])new Object[0]);
        }
        return em;
    }

    @Trivial
    private void disallowPersistenceAnnos(Class<?> c, boolean isRecord) {
        if (!isRecord) {
            for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
                for (Annotation anno : accessibleObject.getAnnotations()) {
                    if (!anno.annotationType().getPackageName().startsWith("jakarta.persistence")) continue;
                    throw DataExtension.exc(MappingException.class, "CWWKD1108.missing.entity.anno", c.getName(), Entity.class.getName(), anno.annotationType().getName(), ((Field)accessibleObject).getName());
                }
            }
        }
        for (AccessibleObject accessibleObject : c.getDeclaredMethods()) {
            for (Annotation anno : accessibleObject.getAnnotations()) {
                if (!anno.annotationType().getPackageName().startsWith("jakarta.persistence")) continue;
                if (isRecord) {
                    throw DataExtension.exc(MappingException.class, "CWWKD1109.jpa.anno.on.record", anno.annotationType().getName(), ((Method)accessibleObject).getName(), c.getName());
                }
                throw DataExtension.exc(MappingException.class, "CWWKD1108.missing.entity.anno", c.getName(), Entity.class.getName(), anno.annotationType().getName(), ((Method)accessibleObject).getName());
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SortedMap<String, Class<?>> findAttributes(Class<?> c) {
        TreeMap attributes = new TreeMap();
        if (c.isRecord()) {
            for (RecordComponent r : c.getRecordComponents()) {
                attributes.put(r.getName(), r.getType());
            }
            return attributes;
        } else {
            for (Field f : c.getFields()) {
                attributes.put(f.getName(), f.getType());
            }
            try {
                PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(c).getPropertyDescriptors();
                if (propertyDescriptors == null) return attributes;
                for (PropertyDescriptor p : propertyDescriptors) {
                    Method setter = p.getWriteMethod();
                    if (setter == null) continue;
                    String n = setter.getName();
                    String name = new StringBuilder(n.length() - 3).append(Character.toLowerCase(n.charAt(3))).append(n.substring(4)).toString();
                    attributes.putIfAbsent(name, p.getPropertyType());
                }
                return attributes;
            }
            catch (IntrospectionException propertyDescriptors) {
                void x;
                FFDCFilter.processException((Throwable)propertyDescriptors, (String)"io.openliberty.data.internal.persistence.service.DBStoreEMBuilder", (String)"665", (Object)this, (Object[])new Object[]{c});
                throw new MappingException((Throwable)x);
            }
        }
    }

    private Map.Entry<String, String> findIdAndVersion(Map<String, Class<?>> attrs) {
        String idAttrName = null;
        String versionAttrName = null;
        int idPrecedence = 10;
        int vPrecedence = 10;
        for (Map.Entry<String, Class<?>> attribute : attrs.entrySet()) {
            String name = attribute.getKey();
            Class<?> type = attribute.getValue();
            int len = name.length();
            if (idPrecedence > 1 && len >= 2 && name.regionMatches(true, len - 2, "id", 0, 2)) {
                if (name.length() == 2) {
                    idAttrName = name;
                    idPrecedence = 1;
                } else if (idPrecedence > 2 && name.charAt(len - 3) == '_') {
                    idAttrName = name;
                    idPrecedence = 2;
                } else if (idPrecedence > 3 && name.charAt(len - 2) == 'I') {
                    idAttrName = name;
                    idPrecedence = 3;
                }
            } else if (idPrecedence > 4 && UUID.class.equals(type)) {
                idAttrName = name;
                idPrecedence = 4;
            }
            if (vPrecedence > 1 && len == 7 && Util.VERSION_TYPES.contains(type) && "version".equalsIgnoreCase(name)) {
                versionAttrName = name;
                vPrecedence = 1;
                continue;
            }
            if (vPrecedence <= 2 || len != 8 || !Util.VERSION_TYPES.contains(type) || !"_version".equalsIgnoreCase(name)) continue;
            versionAttrName = name;
            vPrecedence = 2;
        }
        return idAttrName == null ? null : new AbstractMap.SimpleImmutableEntry<Object, Object>(idAttrName, versionAttrName);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataSource getDataSource(Method repoMethod, Class<?> repoInterface) {
        Collection dsFactoryRefs;
        BundleContext bc = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        try {
            dsFactoryRefs = bc.getServiceReferences(ResourceFactory.class, this.dataSourceFactoryFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void x;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"io.openliberty.data.internal.persistence.service.DBStoreEMBuilder", (String)"755", (Object)this, (Object[])new Object[]{repoMethod, repoInterface});
            throw new RuntimeException((Throwable)x);
        }
        if (dsFactoryRefs.isEmpty()) {
            throw DataExtension.exc(IllegalStateException.class, "CWWKD1062.resource.not.found", repoMethod.getName(), repoInterface.getName(), DataSource.class.getSimpleName(), this.dataSourceFactoryFilter);
        }
        ResourceFactory dsFactory = (ResourceFactory)bc.getService((ServiceReference)dsFactoryRefs.iterator().next());
        try {
            ResourceConfig resRef = null;
            if (!(dsFactory instanceof ResRefDelegator)) {
                resRef = this.provider.resourceConfigFactory.createResourceConfig(DataSource.class.getName());
                resRef.setSharingScope(0);
                resRef.setIsolationLevel(2);
                resRef.setResAuthType(0);
                String dbStoreFilter = FilterUtils.createPropertyFilter((String)"id", (String)this.databaseStoreId);
                Collection dbStoreRefs = bc.getServiceReferences(DatabaseStore.class, dbStoreFilter);
                if (dbStoreRefs.isEmpty()) {
                    throw DataExtension.exc(IllegalStateException.class, "CWWKD1062.resource.not.found", repoMethod.getName(), repoInterface.getName(), "databaseStore", dbStoreFilter);
                }
                ServiceReference ref = (ServiceReference)dbStoreRefs.iterator().next();
                if (ref.getProperty("authDataRef") != null) {
                    String authDataFilter = (String)ref.getProperty("AuthData.target");
                    ServiceReference[] authDataRefs = bc.getServiceReferences("com.ibm.websphere.security.auth.data.AuthData", authDataFilter);
                    if (authDataRefs == null) {
                        throw DataExtension.exc(IllegalStateException.class, "CWWKD1062.resource.not.found", repoMethod.getName(), repoInterface.getName(), "authData", authDataFilter);
                    }
                    String authDataId = (String)authDataRefs[0].getProperty("id");
                    resRef.addLoginProperty("DefaultPrincipalMapping", authDataId.matches(".*(\\]/).*(\\[default-\\d*\\])") ? (String)authDataRefs[0].getProperty("config.displayId") : authDataId);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"using resource reference", (Object[])new Object[]{resRef});
                }
            }
            return (DataSource)dsFactory.createResource(resRef);
        }
        catch (Exception resRef) {
            void x;
            FFDCFilter.processException((Throwable)resRef, (String)"io.openliberty.data.internal.persistence.service.DBStoreEMBuilder", (String)"816", (Object)this, (Object[])new Object[]{repoMethod, repoInterface});
            if (x instanceof RuntimeException && x.getMessage() != null && x.getMessage().startsWith("CWWKD")) {
                throw (RuntimeException)x;
            }
            String datastore = dsFactory instanceof ResRefDelegator ? ((ResRefDelegator)dsFactory).jndiName : this.databaseStoreId;
            throw (DataException)DataExtension.exc(DataException.class, "CWWKD1064.datastore.error", repoMethod.getName(), repoInterface.getName(), datastore, x.getMessage()).initCause((Throwable)x);
        }
    }

    @Trivial
    private Class<?> getEmbeddableClass(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeParams;
            for (Type t : typeParams = ((ParameterizedType)type).getActualTypeArguments()) {
                if (!(t instanceof Class) || !((Class)t).isAnnotationPresent(Embeddable.class)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("getEmbeddableClass from parameterized " + String.valueOf(type) + ": " + String.valueOf(t)), (Object[])new Object[0]);
                }
                return (Class)t;
            }
        }
        return null;
    }

    @Trivial
    private Class<?> getEntityClass(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeParams;
            for (Type t : typeParams = ((ParameterizedType)type).getActualTypeArguments()) {
                if (!(t instanceof Class) || !((Class)t).isAnnotationPresent(Entity.class)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("getEntityClass from parameterized " + String.valueOf(type) + ": " + String.valueOf(t)), (Object[])new Object[0]);
                }
                return (Class)t;
            }
        }
        return null;
    }

    @Override
    @Trivial
    protected Class<?> getRecordClass(Class<?> generatedEntityClass) {
        return this.generatedToRecordClass.get(generatedEntityClass);
    }

    @Override
    @Trivial
    public void introspect(PrintWriter writer, String indent) {
        super.introspect(writer, indent);
        writer.println(indent + "  databaseStore config.displayId: " + this.configDisplayId);
        writer.println(indent + "  databaseStore id: " + this.databaseStoreId);
        writer.println(indent + "  databaseStore DataSourceFactory.target: " + this.dataSourceFactoryFilter);
        writer.println(indent + "  PersistenceServiceUnit: " + String.valueOf(this.persistenceServiceUnit));
        this.generatedToRecordClass.forEach((entityClass, recordClass) -> {
            writer.println(indent + "  Record entity:");
            writer.println(Util.toString(recordClass, indent + "    "));
            writer.println(indent + "    converted to entity class:");
            writer.println(Util.toString(entityClass, indent + "    "));
        });
    }

    @Override
    @FFDCIgnore(value={Exception.class})
    public boolean isConnectionError(SQLException cause) {
        boolean isConnectionError;
        block2: {
            isConnectionError = false;
            try {
                WSJdbcDataSource ds = (WSJdbcDataSource)this.getDataSource(null, null);
                isConnectionError = ds != null && ds.getDatabaseHelper().isConnectionError(cause);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Could not obtain DataSource to check isConnectionError", (Object[])new Object[0]);
            }
        }
        return isConnectionError || super.isConnectionError(cause);
    }

    @Trivial
    public String toString() {
        return new StringBuilder(26 + this.configDisplayId.length()).append("DBStoreEMBuilder@").append(Integer.toHexString(this.hashCode())).append(":").append(this.configDisplayId).toString();
    }

    private void writeAttributes(StringBuilder xml, Map<String, Class<?>> attributes, Map<Class<?>, Map<String, Class<?>>> embeddableTypes) {
        boolean isEmbeddable = embeddableTypes == null;
        Map.Entry<String, String> idAndVersion = isEmbeddable ? ID_AND_VERSION_NOT_SPECIFIED : this.findIdAndVersion(attributes);
        xml.append("  <attributes>").append(Util.EOLN);
        for (Map.Entry<String, Class<?>> attributeInfo : attributes.entrySet()) {
            String attributeName = attributeInfo.getKey();
            Class<?> attributeType = attributeInfo.getValue();
            boolean isCollection = Collection.class.isAssignableFrom(attributeType);
            boolean isPrimitive = attributeType.isPrimitive();
            boolean isId = attributeName.equals(idAndVersion.getKey());
            String columnType = isPrimitive || attributeType.isInterface() || Serializable.class.isAssignableFrom(attributeType) ? (isId ? "id" : (isCollection ? "element-collection" : (attributeName.equals(idAndVersion.getValue()) ? "version" : "basic"))) : (isId ? "embedded-id" : "embedded");
            xml.append("   <").append(columnType).append(" name=\"").append(attributeName).append('\"');
            if (isCollection) {
                xml.append(" fetch=\"EAGER\"");
            }
            xml.append('>').append(Util.EOLN);
            if (!isEmbeddable && columnType.charAt(1) == 'm') {
                Map.Entry emb;
                LinkedList stack = new LinkedList();
                Map<String, Class<?>> attrs = embeddableTypes.get(attributeType);
                if (attrs == null) {
                    attrs = this.findAttributes(attributeType);
                    embeddableTypes.put(attributeType, attrs);
                }
                stack.add(new AbstractMap.SimpleImmutableEntry(new String[]{attributeName}, attrs));
                while (null != (emb = (Map.Entry)stack.pollLast())) {
                    String[] names = (String[])emb.getKey();
                    Map embeddableAttrs = (Map)emb.getValue();
                    for (Map.Entry e : embeddableAttrs.entrySet()) {
                        String name = (String)e.getKey();
                        Class type = (Class)e.getValue();
                        if (type.isPrimitive() || type.isInterface() || Serializable.class.isAssignableFrom(type)) {
                            int n;
                            xml.append("    <attribute-override name=\"");
                            for (n = 1; n < names.length; ++n) {
                                xml.append(names[n]).append('.');
                            }
                            xml.append(name).append("\">").append(Util.EOLN);
                            xml.append("     <column name=\"");
                            for (n = 0; n < names.length; ++n) {
                                xml.append(names[n].toUpperCase()).append('_');
                            }
                            xml.append(name.toUpperCase()).append("\"/>").append(Util.EOLN);
                            xml.append("    </attribute-override>").append(Util.EOLN);
                            continue;
                        }
                        Map<String, Class<?>> a = embeddableTypes.get(type);
                        if (a == null) {
                            a = this.findAttributes(type);
                            embeddableTypes.put(type, a);
                        }
                        String[] names2 = new String[names.length + 1];
                        System.arraycopy(names, 0, names2, 0, names.length);
                        names2[names.length] = name;
                        stack.add(new AbstractMap.SimpleImmutableEntry(names2, a));
                    }
                }
            }
            if (isPrimitive && !isEmbeddable) {
                xml.append("    <column nullable=\"false\"/>").append(Util.EOLN);
            }
            xml.append("   </" + columnType + ">").append(Util.EOLN);
        }
        xml.append("  </attributes>").append(Util.EOLN);
    }

    public void generate(Writer out) throws Exception {
        if (this.persistenceServiceUnit == null) {
            throw new IllegalStateException("EntityManagerFactory for Jakarta Data repository has not been initialized for the " + this.configDisplayId + " DatabaseStore.");
        }
        this.persistenceServiceUnit.generateDDL(out);
    }

    public String getDDLFileName() {
        return this.configDisplayId + "_JakartaData";
    }
}

