/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.data.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.data.internal.persistence.QueryInfo;
import io.openliberty.data.internal.persistence.cdi.DataExtension;
import jakarta.data.page.CursoredPage;
import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.stream.Stream;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PageImpl<T>
implements Page<T> {
    private static final TraceComponent tc = Tr.register(PageImpl.class, (String)"data", (String)"io.openliberty.data.internal.persistence.resources.CWWKDMessages");
    private final Object[] args;
    private final PageRequest pageRequest;
    private final QueryInfo queryInfo;
    private final List<T> results;
    private long totalElements = -1L;
    static final long serialVersionUID = -4615494547936867487L;

    @Trivial
    @ManualTrace
    PageImpl(QueryInfo queryInfo, EntityManager em, PageRequest pageRequest, Object[] args) {
        List resultList;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[]{queryInfo, pageRequest, queryInfo.loggable(args)});
        }
        if (pageRequest == null) {
            queryInfo.missingPageRequest();
        }
        if (pageRequest.mode() != PageRequest.Mode.OFFSET) {
            throw DataExtension.exc(IllegalArgumentException.class, "CWWKD1035.incompat.page.mode", pageRequest.mode(), queryInfo.method.getName(), queryInfo.repositoryInterface.getName(), queryInfo.method.getGenericReturnType().getTypeName(), CursoredPage.class.getName());
        }
        this.queryInfo = queryInfo;
        this.pageRequest = pageRequest;
        this.args = args;
        Query query = em.createQuery(queryInfo.jpql);
        queryInfo.setParameters(query, args);
        if (queryInfo.entityInfo.loadGraph != null) {
            query.setHint("jakarta.persistence.loadgraph", queryInfo.entityInfo.loadGraph);
        }
        int maxPageSize = pageRequest.size();
        query.setFirstResult(queryInfo.computeOffset(pageRequest));
        query.setMaxResults(maxPageSize + (maxPageSize == Integer.MAX_VALUE ? 0 : 1));
        this.results = resultList = query.getResultList();
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @FFDCIgnore(value={Exception.class})
    private long countTotalElements() {
        if (!this.pageRequest.requestTotal()) {
            throw DataExtension.exc(IllegalStateException.class, "CWWKD1042.no.totals", this.queryInfo.method.getName(), this.queryInfo.repositoryInterface.getName(), this.pageRequest);
        }
        if (this.pageRequest.page() == 1L && this.results.size() <= this.pageRequest.size() && this.pageRequest.size() < Integer.MAX_VALUE) {
            return this.results.size();
        }
        if (this.queryInfo.jpqlCount.length() < 15) {
            throw DataExtension.exc(UnsupportedOperationException.class, "CWWKD1119.keyword.prevents.count", this.queryInfo.method.getName(), this.queryInfo.repositoryInterface.getName(), this.queryInfo.jpqlCount, this.queryInfo.jpql);
        }
        try (EntityManager em = this.queryInfo.entityInfo.builder.createEntityManager();){
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("query for count: " + this.queryInfo.jpqlCount), (Object[])new Object[0]);
            }
            TypedQuery query = em.createQuery(this.queryInfo.jpqlCount, Long.class);
            this.queryInfo.setParameters((Query)query, this.args);
            long l = (Long)query.getSingleResult();
            return l;
        }
    }

    @Trivial
    public List<T> content() {
        int max;
        List content;
        int size = this.results.size();
        List list = content = size > (max = this.pageRequest.size()) ? new ResultList(max) : this.results;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"content", (Object[])new Object[]{this.queryInfo.loggable(content)});
        }
        return content;
    }

    public boolean hasContent() {
        return !this.results.isEmpty();
    }

    public boolean hasNext() {
        return this.results.size() > this.pageRequest.size() || this.pageRequest.size() == Integer.MAX_VALUE && this.results.size() == this.pageRequest.size();
    }

    public boolean hasPrevious() {
        return this.pageRequest.page() > 1L;
    }

    public boolean hasTotals() {
        return this.queryInfo.jpqlCount.length() >= 15 && this.pageRequest.requestTotal();
    }

    public Iterator<T> iterator() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? new ResultIterator(max) : this.results.iterator();
    }

    public int numberOfElements() {
        int max;
        int size = this.results.size();
        return size > (max = this.pageRequest.size()) ? max : size;
    }

    public PageRequest pageRequest() {
        return this.pageRequest;
    }

    public PageRequest nextPageRequest() {
        if (this.hasNext()) {
            return PageRequest.ofPage((long)(this.pageRequest.page() + 1L), (int)this.pageRequest.size(), (boolean)this.pageRequest.requestTotal());
        }
        throw DataExtension.exc(NoSuchElementException.class, "CWWKD1040.no.next.page", this.queryInfo.method.getName(), this.queryInfo.repositoryInterface.getName(), "Page.hasNext");
    }

    public PageRequest previousPageRequest() {
        if (this.pageRequest.page() > 1L) {
            return PageRequest.ofPage((long)(this.pageRequest.page() - 1L), (int)this.pageRequest.size(), (boolean)this.pageRequest.requestTotal());
        }
        throw DataExtension.exc(NoSuchElementException.class, "CWWKD1038.no.prev.offset.page", this.pageRequest.page(), this.queryInfo.method.getName(), this.queryInfo.repositoryInterface.getName());
    }

    public Stream<T> stream() {
        return this.content().stream();
    }

    @Trivial
    public String toString() {
        int maxPageSize = this.pageRequest.size();
        int size = Math.min(this.results.size(), maxPageSize);
        StringBuilder s = new StringBuilder(80).append("Page ").append(this.pageRequest.page());
        if (this.totalElements >= 0L) {
            s.append('/');
            s.append(this.totalElements / (long)maxPageSize + (long)(this.totalElements % (long)maxPageSize > 0L ? 1 : 0));
        }
        if (!this.results.isEmpty()) {
            s.append(" of ").append(this.results.get(0).getClass().getSimpleName());
        }
        s.append(", size ").append(size);
        s.append('/').append(maxPageSize);
        s.append(" @").append(Integer.toHexString(this.hashCode()));
        return s.toString();
    }

    public long totalElements() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements;
    }

    public long totalPages() {
        if (this.totalElements == -1L) {
            this.totalElements = this.countTotalElements();
        }
        return this.totalElements / (long)this.pageRequest.size() + (long)(this.totalElements % (long)this.pageRequest.size() > 0L ? 1 : 0);
    }

    @Trivial
    private class ResultList
    extends AbstractList<T>
    implements RandomAccess {
        private final int size;

        private ResultList(int size) {
            this.size = size;
        }

        @Override
        public T get(int index) {
            if (index < this.size) {
                return PageImpl.this.results.get(index);
            }
            throw new IndexOutOfBoundsException(index);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @Trivial
    private class ResultIterator
    implements Iterator<T> {
        private int index;
        private final Iterator<T> iterator;
        private final int size;

        private ResultIterator(int size) {
            this.size = size;
            this.iterator = PageImpl.this.results.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.size && this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.index >= this.size) {
                throw new NoSuchElementException("Element at index " + this.index);
            }
            Object result = this.iterator.next();
            ++this.index;
            return result;
        }
    }
}

