/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeLog;
import com.ibm.ws.recoverylog.spi.PeerLogsMissingException;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RecoveryLogImpl
implements DistributedRecoveryLog {
    private static final TraceComponent tc = Tr.register(RecoveryLogImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private final MultiScopeLog _recoveryLog;
    private final FailureScope _failureScope;
    static final long serialVersionUID = -1656255119254068862L;

    @ManualTrace
    public RecoveryLogImpl(MultiScopeLog recoveryLog, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryLogImpl", (Object[])new Object[]{recoveryLog, failureScope});
        }
        this._recoveryLog = recoveryLog;
        this._failureScope = failureScope;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryLogImpl", (Object)this);
        }
    }

    @Override
    @Trivial
    public void openLog(boolean localRecovery) throws LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException, PeerLogsMissingException {
        this._recoveryLog.openLog(localRecovery);
    }

    @Override
    @Trivial
    public void closeLog() throws InternalLogException {
        this._recoveryLog.closeLog();
    }

    @Override
    @Trivial
    public void closeLog(byte[] serviceData) throws InternalLogException {
        this._recoveryLog.closeLog(serviceData);
    }

    @Override
    @Trivial
    public void closeLogImmediate() throws InternalLogException {
        this._recoveryLog.closeLogImmediate();
    }

    @Override
    @Trivial
    public void recoveryComplete() throws LogClosedException, InternalLogException, LogIncompatibleException {
        this._recoveryLog.recoveryComplete();
    }

    @Override
    @Trivial
    public void recoveryComplete(byte[] serviceData) throws LogClosedException, InternalLogException, LogIncompatibleException {
        this._recoveryLog.recoveryComplete(serviceData);
    }

    @Override
    @Trivial
    public void keypoint() throws LogClosedException, InternalLogException, LogIncompatibleException {
        this._recoveryLog.keypoint();
    }

    @Override
    @Trivial
    public byte[] serviceData() throws LogClosedException, InternalLogException {
        return this._recoveryLog.serviceData();
    }

    @Override
    @Trivial
    public RecoverableUnit createRecoverableUnit() throws LogClosedException, InternalLogException, LogIncompatibleException {
        return this._recoveryLog.createRecoverableUnit(this._failureScope);
    }

    @Override
    @Trivial
    public void removeRecoverableUnit(long identity) throws LogClosedException, InvalidRecoverableUnitException, InternalLogException, LogIncompatibleException {
        this._recoveryLog.removeRecoverableUnit(identity);
    }

    @Override
    @Trivial
    public RecoverableUnit lookupRecoverableUnit(long identity) throws LogClosedException {
        return this._recoveryLog.lookupRecoverableUnit(identity);
    }

    @Override
    @Trivial
    public LogCursor recoverableUnits() throws LogClosedException {
        return this._recoveryLog.recoverableUnits(this._failureScope);
    }

    @Override
    @Trivial
    public LogProperties logProperties() {
        return this._recoveryLog.logProperties();
    }

    public String toString() {
        return "" + this._recoveryLog + " [" + this._failureScope + "]";
    }

    @Trivial
    private MultiScopeLog getMultiScopeLog() {
        return this._recoveryLog;
    }

    @Override
    @Trivial
    public void associateLog(DistributedRecoveryLog otherLog, boolean failAssociatedLog) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"associateLog {0} {1} {2}", (Object[])new Object[]{otherLog, failAssociatedLog, this});
        }
        if (otherLog instanceof RecoveryLogImpl) {
            this._recoveryLog.associateLog(((RecoveryLogImpl)otherLog).getMultiScopeLog(), failAssociatedLog);
        } else {
            this._recoveryLog.associateLog(otherLog, failAssociatedLog);
        }
    }

    @Override
    @Trivial
    public boolean delete() {
        return this._recoveryLog.delete();
    }

    @Override
    @Trivial
    public void retainLogsInPeerRecoveryEnv(boolean retainLogs) {
        this._recoveryLog.retainLogsInPeerRecoveryEnv(retainLogs);
    }

    @Override
    @Trivial
    public boolean failed() {
        return this._recoveryLog.failed();
    }
}

