/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.mfp.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.impl.MfpDiagnostics;
import com.ibm.ws.sib.mfp.impl.SchemaSet;
import com.ibm.ws.sib.mfp.jmf.JMFException;
import com.ibm.ws.sib.mfp.jmf.JMFRegistry;
import com.ibm.ws.sib.mfp.jmf.JMFSchema;
import com.ibm.ws.sib.mfp.jmf.JMFSchemaIdException;
import com.ibm.ws.sib.mfp.jmf.impl.JSRegistry;
import com.ibm.ws.sib.mfp.schema.ControlAccess;
import com.ibm.ws.sib.mfp.schema.JmsBytesBodyAccess;
import com.ibm.ws.sib.mfp.schema.JmsMapBodyAccess;
import com.ibm.ws.sib.mfp.schema.JmsObjectBodyAccess;
import com.ibm.ws.sib.mfp.schema.JmsStreamBodyAccess;
import com.ibm.ws.sib.mfp.schema.JmsTextBodyAccess;
import com.ibm.ws.sib.mfp.schema.JsApiAccess;
import com.ibm.ws.sib.mfp.schema.JsHdr2Access;
import com.ibm.ws.sib.mfp.schema.JsHdrAccess;
import com.ibm.ws.sib.mfp.schema.JsPayloadAccess;
import com.ibm.ws.sib.mfp.schema.SubscriptionAccess;
import com.ibm.ws.sib.mfp.schema.TrmAccess;
import com.ibm.ws.sib.mfp.schema.TrmFirstContactAccess;
import com.ibm.ws.sib.mfp.util.ArrayUtil;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;

public class SchemaManager {
    private static TraceComponent tc = SibTr.register(SchemaManager.class, (String)"SIBMfp", (String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.mfp.CWSIFMessages");
    private static String JMF_ONLY_PROPERTY = "sib.client.JMFOnly";
    private static String JMS_ONLY_PROPERTY = "sib.client.JMSOnly";

    static void ensureInitialized() {
    }

    public static void init() throws JMFSchemaIdException {
        MfpDiagnostics.initialize();
        try {
            JMFRegistry.instance.register(JsHdrAccess.schema);
            JMFRegistry.instance.register(JsHdr2Access.schema);
            JMFRegistry.instance.register(JsApiAccess.schema);
            JMFRegistry.instance.register(JsPayloadAccess.schema);
            JMFRegistry.instance.register(JmsBytesBodyAccess.schema);
            JMFRegistry.instance.register(JmsTextBodyAccess.schema);
            JMFRegistry.instance.register(JmsObjectBodyAccess.schema);
            JMFRegistry.instance.register(JmsStreamBodyAccess.schema);
            JMFRegistry.instance.register(JmsMapBodyAccess.schema);
            JMFRegistry.instance.register(TrmAccess.schema);
            JMFRegistry.instance.register(SubscriptionAccess.schema);
            JMFRegistry.instance.register(ControlAccess.schema);
            JMFRegistry.instance.register(TrmFirstContactAccess.schema);
        }
        catch (JMFSchemaIdException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.SchemaManager.<clinit>", (String)"188");
            throw e;
        }
    }

    static void openLink(CommsConnection conn) throws SIConnectionLostException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"openLink", (Object)conn);
        }
        JMFSchema[] schemas = JMFRegistry.instance.retrieveAll();
        byte[] remoteList = conn.mfpHandshakeExchange(SchemaManager.makeSchemaIdList(schemas));
        Coder cin = new Coder(remoteList);
        conn.setSchemaSet(SchemaManager.makeSchemaIdSet(cin));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"openLink");
        }
    }

    static void closeLink(CommsConnection conn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"closeLink", (Object)conn);
        }
        conn.setSchemaSet(null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"closeLink");
        }
    }

    static byte[] receiveHandshake(CommsConnection conn, byte[] data) throws JMFException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"receiveHandshake", (Object)conn);
        }
        Coder coder = new Coder(data);
        conn.setSchemaSet(SchemaManager.makeSchemaIdSet(coder));
        byte[] ids = SchemaManager.makeSchemaIdList(JMFRegistry.instance.retrieveAll());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"receiveHandshake");
        }
        return ids;
    }

    static void receiveSchemas(CommsConnection conn, byte[] data) throws JMFException {
        SchemaSet ids;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"receiveSchemas", (Object)conn);
        }
        try {
            ids = (SchemaSet)conn.getSchemaSet();
            if (ids == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("getSchemaSet() returned null for CommsConnection: " + conn));
                }
                throw new IllegalStateException("CommsConnection returned null SchemaSet");
            }
        }
        catch (SIConnectionDroppedException e) {
            throw new IllegalStateException("CommsConnection threw exception", e);
        }
        Coder coder = new Coder(data);
        SchemaManager.addSchemaDefinitions(ids, coder);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"receiveSchemas");
        }
    }

    static void sendSchemas(CommsConnection conn, JMFSchema[] schemas) throws SIConnectionLostException, SIConnectionUnavailableException {
        int i;
        SchemaSet ids;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendSchemas", (Object)conn);
        }
        if ((ids = (SchemaSet)conn.getSchemaSet()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("getSchemaSet() returned null for CommsConnection: " + conn));
            }
            throw new IllegalStateException("CommsConnection returned null SchemaSet");
        }
        JMFSchema[] missing = new JMFSchema[schemas.length];
        int count = 0;
        for (i = 0; i < schemas.length; ++i) {
            if (ids.contains(schemas[i].getLongID())) continue;
            missing[count++] = schemas[i];
        }
        if (count > 0) {
            conn.sendMFPSchema(SchemaManager.makeSchemaDefinitionList(missing, count));
            for (i = 0; i < count; ++i) {
                ids.add(missing[i].getLongID());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendSchemas");
        }
    }

    static byte[] getEncodedSchemataByEncodedIDs(byte[] encodedSchemaIDs) {
        if (encodedSchemaIDs != null && encodedSchemaIDs.length >= 8) {
            int numSchemas = encodedSchemaIDs.length / 8;
            long[] schemaIDs = new long[numSchemas];
            int offset = 0;
            for (int i = 0; i < numSchemas; ++i) {
                schemaIDs[i] = ArrayUtil.readLong(encodedSchemaIDs, offset);
                offset += 8;
            }
            return SchemaManager.getEncodedSchemataBySchemaIDs(schemaIDs);
        }
        return new byte[0];
    }

    static byte[] getEncodedSchemataBySchemaIDs(long[] schemaIDs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEncodedSchemataBySchemaIDs", (Object)schemaIDs);
        }
        JMFSchema[] temp = new JMFSchema[schemaIDs.length];
        int j = 0;
        for (int i = 0; i < schemaIDs.length; ++i) {
            JMFSchema schema = JSRegistry.instance.retrieve(schemaIDs[i]);
            if (schema == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unable to retrieve message schema " + schemaIDs[i]));
                }
                MessageDecodeFailedException e = new MessageDecodeFailedException("No schema registered for schema id " + schemaIDs[i]);
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.mfp.impl.SchemaManager.getEncodedSchemasBySchemaIDs", (String)"281");
                continue;
            }
            temp[j++] = schema;
        }
        JMFSchema[] found = new JMFSchema[j];
        System.arraycopy(temp, 0, found, 0, j);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEncodedSchemataBySchemaIDs");
        }
        return SchemaManager.makeSchemaDefinitionList(found, j);
    }

    private static byte[] makeSchemaIdList(JMFSchema[] schemas) {
        Coder coder = new Coder(8 * schemas.length, schemas.length);
        for (int i = 0; i < coder.count; ++i) {
            ArrayUtil.writeLong(coder.buffer, coder.offset, schemas[i].getID());
            coder.offset += 8;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Encoding " + coder.count + " schema ids for handshake"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.bytes((TraceComponent)tc, (byte[])coder.buffer, (int)13);
        }
        return coder.buffer;
    }

    private static SchemaSet makeSchemaIdSet(Coder coder) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Decoding " + coder.count + "schema ids from handshake"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.bytes((TraceComponent)tc, (byte[])coder.buffer, (int)13);
        }
        SchemaSet result = new SchemaSet();
        for (int i = 0; i < coder.count; ++i) {
            long id = ArrayUtil.readLong(coder.buffer, coder.offset);
            coder.offset += 8;
            result.add((Object)id);
        }
        return result;
    }

    private static byte[] makeSchemaDefinitionList(JMFSchema[] schemas, int count) {
        int length = 0;
        for (int i = 0; i < count; ++i) {
            length += 4 + schemas[i].toByteArray().length;
        }
        Coder coder = new Coder(length, count);
        for (int i = 0; i < coder.count; ++i) {
            byte[] b = schemas[i].toByteArray();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("   Encoded Schema " + SchemaManager.debugSchema(schemas[i]) + " for transmission"));
            }
            ArrayUtil.writeInt(coder.buffer, coder.offset, b.length);
            coder.offset += 4;
            System.arraycopy(b, 0, coder.buffer, coder.offset, b.length);
            coder.offset += b.length;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Encoding " + coder.count + "new schema definitions"));
        }
        return coder.buffer;
    }

    private static void addSchemaDefinitions(SchemaSet ids, Coder coder) throws JMFException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Decoding " + coder.count + "new schema definitions"));
        }
        for (int i = 0; i < coder.count; ++i) {
            int length = ArrayUtil.readInt(coder.buffer, coder.offset);
            coder.offset += 4;
            JMFSchema schema = JMFRegistry.instance.createJMFSchema(coder.buffer, coder.offset, length);
            JMFRegistry.instance.register(schema);
            ids.add(schema.getLongID());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("   Added Schema " + SchemaManager.debugSchema(schema)));
            }
            coder.offset += length;
        }
    }

    private static String debugSchema(JMFSchema schema) {
        if (schema != null) {
            return schema.getName() + "(" + Long.toHexString(schema.getID()) + ")";
        }
        return "<null>";
    }

    static {
        try {
            SchemaManager.init();
        }
        catch (JMFSchemaIdException e) {
            String exString = nls.getFormattedMessage("UNEXPECTED_CLASS_INIT_ERROR_CWSIF0721", new Object[]{e}, "Error in SchemaManager static initialization");
            throw new SIErrorException(exString, e);
        }
    }

    static class Coder {
        static final int HDR_LENGTH = 13;
        private int count;
        private byte[] buffer;
        private int offset;

        Coder(byte[] data) {
            this.buffer = data;
            this.offset = 0;
            this.offset += 4;
            this.offset += 4;
            this.count = ArrayUtil.readInt(this.buffer, this.offset);
            this.offset += 4;
        }

        Coder(int length, int count) {
            this.count = count;
            this.buffer = new byte[length + 13];
            this.offset = 0;
            ArrayUtil.writeInt(this.buffer, this.offset, 1);
            this.offset += 4;
            ArrayUtil.writeInt(this.buffer, this.offset, length);
            this.offset += 4;
            ArrayUtil.writeInt(this.buffer, this.offset, count);
            this.offset += 4;
        }
    }
}

