/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.probe;

import com.ibm.ws.request.probe.RequestId;
import java.util.concurrent.atomic.AtomicLong;

public class RequestIdGeneratorPUID {
    private static final char[] Base64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final String startTimeAlphaNumeric;
    private static final char UNDERSCORE = '_';
    private static final AtomicLong sequence;

    public RequestId getNextRequestId() {
        long sequenceNumber = sequence.getAndIncrement();
        String id = RequestIdGeneratorPUID.toBase64(sequenceNumber).insert(0, startTimeAlphaNumeric).toString();
        RequestId requestId = new RequestId(sequenceNumber + 1L, id);
        return requestId;
    }

    private static StringBuilder toBase64(long value) {
        StringBuilder result = new StringBuilder(23);
        for (int shift = 60; shift >= 0; shift -= 6) {
            result.append(Base64[(int)(value >> shift & 0x3FL)]);
        }
        return result;
    }

    static {
        sequence = new AtomicLong();
        startTimeAlphaNumeric = RequestIdGeneratorPUID.toBase64(System.nanoTime()).append('_').toString();
    }
}

