/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.ApiMessages;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.OpenAPIImpl;
import io.smallrye.openapi.api.models.PathsImpl;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.api.util.ConfigUtil;
import io.smallrye.openapi.api.util.FilterUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.api.util.UnusedSchemaFilter;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;

public class OpenApiDocument {
    public static final OpenApiDocument INSTANCE = new OpenApiDocument();
    private transient OpenApiConfig config;
    private transient OpenAPI annotationsModel;
    private transient OpenAPI readerModel;
    private transient OpenAPI staticFileModel;
    private transient Map<String, OASFilter> filters = new HashMap<String, OASFilter>();
    private transient String archiveName;
    private transient String version;
    private transient OpenAPI model;

    private OpenApiDocument() {
    }

    public static OpenApiDocument newInstance() {
        return new OpenApiDocument();
    }

    public synchronized OpenAPI get() {
        if (this.model == null) {
            throw ApiMessages.msg.modelNotInitialized();
        }
        return this.model;
    }

    public synchronized void set(OpenAPI model) {
        this.model = model;
    }

    public synchronized void reset() {
        this.model = null;
        this.clear();
    }

    public synchronized boolean isSet() {
        return this.model != null;
    }

    public synchronized void config(OpenApiConfig config) {
        this.set(() -> {
            this.config = config;
        });
    }

    public void modelFromAnnotations(OpenAPI model) {
        this.set(() -> {
            this.annotationsModel = model;
        });
    }

    public void modelFromReader(OpenAPI model) {
        this.set(() -> {
            this.readerModel = model;
        });
    }

    public void modelFromStaticFile(OpenAPI model) {
        this.set(() -> {
            this.staticFileModel = model;
        });
    }

    public void filter(OASFilter filter) {
        if (filter != null) {
            this.set(() -> this.filters.putIfAbsent(filter.getClass().getName(), filter));
        }
    }

    public void archiveName(String archiveName) {
        this.set(() -> {
            this.archiveName = archiveName;
        });
    }

    public void version(String version) {
        this.set(() -> {
            this.version = version;
        });
    }

    public synchronized void initialize() {
        if (this.model != null) {
            this.modelAlreadyInitialized();
        }
        if (this.config == null) {
            throw ApiMessages.msg.configMustBeSet();
        }
        OpenAPI merged = this.readerModel;
        merged = MergeUtil.mergeObjects(merged, this.staticFileModel);
        merged = MergeUtil.mergeObjects(merged, this.annotationsModel);
        if ((merged = this.filterModel(merged)) == null) {
            merged = new OpenAPIImpl();
            merged.setOpenapi("3.0.3");
        }
        if (merged.getPaths() == null) {
            merged.setPaths((Paths)new PathsImpl());
        }
        if (merged.getInfo() == null) {
            merged.setInfo((Info)new InfoImpl());
        }
        if (merged.getInfo().getTitle() == null) {
            merged.getInfo().setTitle((this.archiveName == null ? "Generated" : this.archiveName) + " API");
        }
        if (merged.getInfo().getVersion() == null) {
            merged.getInfo().setVersion(this.version == null ? "1.0" : this.version);
        }
        ConfigUtil.applyConfig(this.config, merged);
        this.model = merged;
        this.clear();
    }

    private OpenAPI filterModel(OpenAPI model) {
        if (model == null) {
            return model;
        }
        if (this.config.removeUnusedSchemas()) {
            model = FilterUtil.applyFilter(new UnusedSchemaFilter(), model);
        }
        for (OASFilter filter : this.filters.values()) {
            model = FilterUtil.applyFilter(filter, model);
        }
        return model;
    }

    private synchronized void set(Runnable action) {
        if (this.model != null) {
            this.modelAlreadyInitialized();
        }
        action.run();
    }

    private void modelAlreadyInitialized() {
        throw ApiMessages.msg.modelAlreadyInitialized();
    }

    private void clear() {
        this.config = null;
        this.annotationsModel = null;
        this.readerModel = null;
        this.staticFileModel = null;
        this.filters.clear();
        this.archiveName = null;
    }
}

