/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.pipeline;

import com.ibm.websphere.channelfw.EndPointInfo;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.netty.NettyChain;
import com.ibm.ws.http.netty.NettyHttpChannelConfig;
import com.ibm.ws.http.netty.NettyHttpConstants;
import com.ibm.ws.http.netty.pipeline.AccessLoggerHandler;
import com.ibm.ws.http.netty.pipeline.CRLFValidationHandler;
import com.ibm.ws.http.netty.pipeline.RemoteIpHandler;
import com.ibm.ws.http.netty.pipeline.http2.LibertyNettyALPNHandler;
import com.ibm.ws.http.netty.pipeline.http2.LibertyUpgradeCodec;
import com.ibm.ws.http.netty.pipeline.inbound.HttpDispatcherHandler;
import com.ibm.ws.http.netty.pipeline.inbound.LibertyHttpObjectAggregator;
import com.ibm.ws.http.netty.pipeline.inbound.LibertyHttpRequestHandler;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http2.CleartextHttp2ServerUpgradeHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.ReferenceCountUtil;
import io.openliberty.http.netty.channel.AllocatorContextSetter;
import io.openliberty.http.netty.channel.LoggingRecvByteBufAllocator;
import io.openliberty.http.netty.channel.TransportHandler;
import io.openliberty.http.netty.timeout.TimeoutHandler;
import io.openliberty.netty.internal.ChannelInitializerWrapper;
import io.openliberty.netty.internal.exception.NettyException;
import io.openliberty.netty.internal.tls.NettyTlsProvider;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class HttpPipelineInitializer
extends ChannelInitializerWrapper {
    private static final TraceComponent tc = Tr.register(HttpPipelineInitializer.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private final NettyChain chain;
    private final NettyHttpChannelConfig httpConfig;
    private final Map<ConfigElement, Map<String, Object>> configOptions;
    public static final String NO_UPGRADE_OCURRED_HANDLER_NAME = "UPGRADE_HANDLER_CHECK";
    public static final String NETTY_HTTP_SERVER_CODEC = "HTTP_SERVER_HANDLER";
    public static final String HTTP_DISPATCHER_HANDLER_NAME = "HTTP_DISPATCHER";
    public static final String HTTP_SSL_HANDLER_NAME = "SSL_HANDLER";
    public static final String HTTP_ALPN_HANDLER_NAME = "ALPN_HANDLER";
    public static final String HTTP_KEEP_ALIVE_HANDLER_NAME = "httpKeepAlive";
    public static final String HTTP_AGGREGATOR_HANDLER_NAME = "LIBERTY_OBJECT_AGGREGATOR";
    public static final String HTTP_REQUEST_HANDLER_NAME = "LIBERTY_REQUEST_HANDLER";
    public static final String HTTP2_CLEARTEXT_UPGRADE_HANDLER_NAME = "H2C_UPGRADE_HANDLER";
    public static final String CRLF_VALIDATION_HANDLER = "CRLFValidationHandler";
    public static final long maxContentLength = Long.MAX_VALUE;
    static final long serialVersionUID = 9134138794038207941L;

    private HttpPipelineInitializer(NettyChain chain, NettyHttpChannelConfig httpConfig, Map<ConfigElement, Map<String, Object>> configOptions) {
        this.chain = chain;
        this.httpConfig = httpConfig;
        this.configOptions = configOptions;
        httpConfig.registerAccessLog(chain.getOwner().getName());
    }

    @ManualTrace
    protected void initChannel(Channel channel) throws Exception {
        Tr.entry((TraceComponent)tc, (String)"initChannel", (Object[])new Object[0]);
        ChannelPipeline pipeline = channel.pipeline();
        this.chain.getBootstrap().getBaseInitializer().init(channel);
        channel.attr(NettyHttpConstants.IS_OUTBOUND_KEY).set((Object)false);
        channel.attr(NettyHttpConstants.ENDPOINT_PID).set((Object)this.chain.getEndpointPID());
        FixedRecvByteBufAllocator channelAllocator = new FixedRecvByteBufAllocator(this.httpConfig.getIncomingBodyBufferSize());
        LoggingRecvByteBufAllocator loggingAllocator = new LoggingRecvByteBufAllocator((RecvByteBufAllocator)channelAllocator);
        channel.config().setRecvByteBufAllocator((RecvByteBufAllocator)loggingAllocator);
        pipeline.addLast("AllocatorContextSetter", (ChannelHandler)AllocatorContextSetter.INSTANCE);
        pipeline.addLast("writeTimeoutHandler", (ChannelHandler)new WriteTimeoutHandler((long)this.httpConfig.getWriteTimeout(), TimeUnit.MILLISECONDS));
        if (this.chain.isHttps()) {
            this.setupSecurePipeline(pipeline);
        } else {
            this.setupUnsecurePipeline(pipeline);
        }
        if (Objects.nonNull(pipeline.get("inactivityTimeoutHandler"))) {
            pipeline.remove("inactivityTimeoutHandler");
        }
        Tr.exit((TraceComponent)tc, (String)"initChannel");
    }

    private void setupSecurePipeline(ChannelPipeline pipeline) throws NettyException {
        if (this.chain.isHttp2Enabled()) {
            this.setupH2Pipeline(pipeline);
        } else {
            this.setupHttpsPipeline(pipeline);
        }
    }

    private void setupUnsecurePipeline(ChannelPipeline pipeline) {
        if (this.chain.isHttp2Enabled()) {
            this.setupH2cPipeline(pipeline);
        } else {
            this.setupHttp11Pipeline(pipeline);
        }
    }

    private void setupH2Pipeline(ChannelPipeline pipeline) throws NettyException {
        SslHandler handler = this.getSslHandler(pipeline.channel());
        pipeline.addFirst(HTTP_SSL_HANDLER_NAME, (ChannelHandler)handler);
        this.addPreHttpCodecHandlers(pipeline);
        pipeline.addLast(HTTP_ALPN_HANDLER_NAME, (ChannelHandler)new LibertyNettyALPNHandler(this.httpConfig));
        pipeline.addLast(HTTP_DISPATCHER_HANDLER_NAME, (ChannelHandler)new HttpDispatcherHandler(this.httpConfig));
        this.addPreDispatcherHandlers(pipeline, true);
        pipeline.channel().attr(NettyHttpConstants.IS_SECURE).set((Object)Boolean.TRUE);
        pipeline.channel().config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)false);
    }

    private void setupHttpsPipeline(ChannelPipeline pipeline) throws NettyException {
        SslHandler handler = this.getSslHandler(pipeline.channel());
        pipeline.addFirst(HTTP_SSL_HANDLER_NAME, (ChannelHandler)handler);
        pipeline.channel().attr(NettyHttpConstants.IS_SECURE).set((Object)Boolean.TRUE);
        this.setupHttp11Pipeline(pipeline);
    }

    private SslHandler getSslHandler(Channel channel) throws NettyException {
        NettyTlsProvider tlsProvider = this.chain.getOwner().getNettyTlsProvider();
        SslHandler handler = null;
        if (tlsProvider == null) {
            throw new NettyException("TLS Provider is not loaded");
        }
        EndPointInfo ep = this.chain.getEndpointInfo();
        String host = ep.getHost();
        String port = Integer.toString(ep.getPort());
        handler = this.chain.isHttp2Enabled() ? tlsProvider.getInboundALPNSSLContext(this.configOptions.get((Object)ConfigElement.SSL_OPTIONS), host, port, channel) : tlsProvider.getInboundSSLContext(this.configOptions.get((Object)ConfigElement.SSL_OPTIONS), host, port, channel);
        if (handler == null) {
            throw new NettyException("Failed to create SSL handler for endpoint: " + ep.getHost() + ":" + ep.getPort());
        }
        return handler;
    }

    private void setupH2cPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(HTTP_DISPATCHER_HANDLER_NAME, (ChannelHandler)new HttpDispatcherHandler(this.httpConfig));
        this.addPreHttpCodecHandlers(pipeline);
        this.addH2CCodecHandlers(pipeline);
        this.addPreDispatcherHandlers(pipeline, true);
        pipeline.channel().config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)false);
    }

    private void setupHttp11Pipeline(ChannelPipeline pipeline) {
        HttpServerCodec sourceCodec = new HttpServerCodec(8192, this.httpConfig.getIncomingBodyBufferSize(), this.httpConfig.getLimitOfFieldSize(), this.httpConfig.getLimitOnNumberOfHeaders());
        pipeline.addLast(CRLF_VALIDATION_HANDLER, (ChannelHandler)CRLFValidationHandler.INSTANCE);
        pipeline.addLast(NETTY_HTTP_SERVER_CODEC, (ChannelHandler)sourceCodec);
        pipeline.addLast(HTTP_DISPATCHER_HANDLER_NAME, (ChannelHandler)new HttpDispatcherHandler(this.httpConfig));
        this.addPreHttpCodecHandlers(pipeline);
        this.addPreDispatcherHandlers(pipeline, false);
    }

    private void addH2CCodecHandlers(final ChannelPipeline pipeline) {
        CleartextHttp2ServerUpgradeHandler cleartextHttp2ServerUpgradeHandler = LibertyUpgradeCodec.createCleartextUpgradeHandler(this.httpConfig, pipeline.channel());
        pipeline.addBefore(HTTP_DISPATCHER_HANDLER_NAME, HTTP2_CLEARTEXT_UPGRADE_HANDLER_NAME, (ChannelHandler)cleartextHttp2ServerUpgradeHandler);
        pipeline.addBefore(HTTP_DISPATCHER_HANDLER_NAME, NO_UPGRADE_OCURRED_HANDLER_NAME, (ChannelHandler)new SimpleChannelInboundHandler<HttpMessage>(){
            static final long serialVersionUID = -8914219597370767205L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            protected void channelRead0(ChannelHandlerContext ctx, HttpMessage msg) throws Exception {
                if ("HTTP2".equals(ctx.pipeline().channel().attr(NettyHttpConstants.PROTOCOL).get())) {
                    ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
                    return;
                }
                ctx.channel().config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, (Object)true);
                pipeline.addBefore("transportHandler", HttpPipelineInitializer.HTTP_KEEP_ALIVE_HANDLER_NAME, (ChannelHandler)new HttpServerKeepAliveHandler());
                ctx.channel().attr(NettyHttpConstants.PROTOCOL).set((Object)NettyHttpConstants.ProtocolName.HTTP1.name());
                pipeline.addAfter(HttpPipelineInitializer.HTTP_KEEP_ALIVE_HANDLER_NAME, HttpPipelineInitializer.HTTP_AGGREGATOR_HANDLER_NAME, (ChannelHandler)new LibertyHttpObjectAggregator(HttpPipelineInitializer.this.httpConfig.getMessageSizeLimit() == -1L ? Long.MAX_VALUE : HttpPipelineInitializer.this.httpConfig.getMessageSizeLimit()));
                pipeline.addAfter(HttpPipelineInitializer.HTTP_AGGREGATOR_HANDLER_NAME, HttpPipelineInitializer.HTTP_REQUEST_HANDLER_NAME, (ChannelHandler)new LibertyHttpRequestHandler(HttpPipelineInitializer.this.httpConfig));
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof CleartextHttp2ServerUpgradeHandler.PriorKnowledgeUpgradeEvent) {
                    ctx.pipeline().remove(HttpPipelineInitializer.NO_UPGRADE_OCURRED_HANDLER_NAME);
                }
                super.userEventTriggered(ctx, evt);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.pipeline.HttpPipelineInitializer$1", 1.class, null, null);
            }
        });
    }

    private void addPreHttpCodecHandlers(ChannelPipeline pipeline) {
        if (this.httpConfig.isAccessLoggingEnabled() && pipeline.names().contains(NETTY_HTTP_SERVER_CODEC)) {
            pipeline.addLast(new ChannelHandler[]{new AccessLoggerHandler(this.httpConfig)});
        }
    }

    private void addPreDispatcherHandlers(ChannelPipeline pipeline, boolean isHttp2) {
        if (!isHttp2) {
            pipeline.addAfter(NETTY_HTTP_SERVER_CODEC, HTTP_KEEP_ALIVE_HANDLER_NAME, (ChannelHandler)new HttpServerKeepAliveHandler());
            pipeline.addAfter(HTTP_KEEP_ALIVE_HANDLER_NAME, HTTP_AGGREGATOR_HANDLER_NAME, (ChannelHandler)new LibertyHttpObjectAggregator(this.httpConfig.getMessageSizeLimit() == -1L ? Long.MAX_VALUE : this.httpConfig.getMessageSizeLimit()));
            pipeline.addAfter(HTTP_AGGREGATOR_HANDLER_NAME, HTTP_REQUEST_HANDLER_NAME, (ChannelHandler)new LibertyHttpRequestHandler(this.httpConfig));
        }
        pipeline.addBefore(HTTP_DISPATCHER_HANDLER_NAME, "transportHandler", (ChannelHandler)TransportHandler.INSTANCE);
        if (pipeline.get(TimeoutHandler.class) == null) {
            pipeline.addBefore(HTTP_DISPATCHER_HANDLER_NAME, TimeoutHandler.NAME, (ChannelHandler)new TimeoutHandler(this.httpConfig));
        }
        if (this.httpConfig.useForwardingHeaders()) {
            pipeline.addBefore(HTTP_DISPATCHER_HANDLER_NAME, null, (ChannelHandler)new RemoteIpHandler(this.httpConfig));
        }
    }

    public void clearConfig() {
        this.httpConfig.clear();
    }

    public static enum ConfigElement {
        HTTP_OPTIONS,
        SSL_OPTIONS,
        REMOTE_IP,
        COMPRESSION,
        SAMESITE,
        HEADERS,
        ACCESS_LOG,
        TCP_OPTIONS;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class HttpPipelineBuilder {
        private final NettyChain chain;
        private final EnumMap<ConfigElement, Map<String, Object>> configOptions = new EnumMap(ConfigElement.class);
        private final Set<ConfigElement> activeConfigs = EnumSet.noneOf(ConfigElement.class);
        static final long serialVersionUID = 6897114882551355140L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public HttpPipelineBuilder(NettyChain chain) {
            this.chain = Objects.requireNonNull(chain, "Netty chain cannot be null");
        }

        public HttpPipelineBuilder with(ConfigElement config, Map<String, Object> options) {
            Objects.requireNonNull(config, "ConfigElement cannot be null");
            Objects.requireNonNull(options, "Options cannot be null");
            String id = String.valueOf(options.get("id"));
            if (config == ConfigElement.SSL_OPTIONS || config == ConfigElement.HTTP_OPTIONS) {
                this.configOptions.put(config, options);
                this.activeConfigs.add(config);
            } else if (!this.isDefaultConfig(config, id)) {
                this.configOptions.put(config, options);
                this.activeConfigs.add(config);
            }
            return this;
        }

        private boolean isDefaultConfig(ConfigElement config, String id) {
            switch (config) {
                case HTTP_OPTIONS: {
                    return "defaultHttpOptions".equalsIgnoreCase(id);
                }
                case REMOTE_IP: {
                    return "defaultRemoteIp".equalsIgnoreCase(id);
                }
                case COMPRESSION: {
                    return "defaultCompression".equalsIgnoreCase(id);
                }
                case SAMESITE: {
                    return "defaultSameSite".equalsIgnoreCase(id);
                }
                case HEADERS: {
                    return "defaultHeaders".equalsIgnoreCase(id);
                }
                case SSL_OPTIONS: {
                    return "defaultSSLOptions".equalsIgnoreCase(id);
                }
                case TCP_OPTIONS: {
                    return "defaultTCPOptions".equalsIgnoreCase(id);
                }
            }
            return false;
        }

        public HttpPipelineInitializer build() {
            NettyHttpChannelConfig.NettyConfigBuilder configBuilder = new NettyHttpChannelConfig.NettyConfigBuilder();
            for (ConfigElement element : ConfigElement.values()) {
                if (!this.activeConfigs.contains((Object)element)) continue;
                configBuilder.with(element, this.configOptions.get((Object)element));
            }
            NettyHttpChannelConfig httpConfig = configBuilder.build();
            return new HttpPipelineInitializer(this.chain, httpConfig, this.configOptions);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.http.netty.pipeline.HttpPipelineInitializer$HttpPipelineBuilder", HttpPipelineBuilder.class, null, null);
        }
    }
}

