/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal;

import com.ibm.websphere.channelfw.OutboundChannelDefinition;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.HashMap;
import java.util.Map;

public class OutboundChannelDefinitionImpl
implements OutboundChannelDefinition {
    private static TraceComponent tc = Tr.register(OutboundChannelDefinitionImpl.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");
    private Class<?> factory = null;
    private Map<Object, Object> factoryProps = null;
    private Map<Object, Object> channelProps = null;
    private static final long serialVersionUID = -4159575078432063481L;

    public OutboundChannelDefinitionImpl(OutboundChannelDefinition existingChanDef, Map<Object, Object> newProps, boolean overwriteExisting) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object[])new Object[0]);
        }
        this.factory = existingChanDef.getOutboundFactory();
        this.factoryProps = existingChanDef.getOutboundFactoryProperties();
        this.channelProps = existingChanDef.getOutboundChannelProperties();
        if (this.factoryProps == null) {
            this.factoryProps = new HashMap<Object, Object>();
        }
        if (this.channelProps == null) {
            this.channelProps = new HashMap<Object, Object>();
        }
        if (newProps == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null properties found", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"constructor");
            }
            return;
        }
        for (Map.Entry<Object, Object> entry : newProps.entrySet()) {
            if (this.channelProps.containsKey(entry.getKey())) {
                if (overwriteExisting) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Object oldValue = this.channelProps.get(entry.getKey());
                        Tr.debug((TraceComponent)tc, (String)("Found existing property, " + entry.getKey() + ", value " + oldValue + " replacing with " + entry.getValue()), (Object[])new Object[0]);
                    }
                    this.channelProps.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Found existing property, " + entry.getKey() + ", but not overwriting"), (Object[])new Object[0]);
                continue;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adding property, " + entry.getKey() + ", value " + entry.getValue()), (Object[])new Object[0]);
            }
            this.channelProps.put(entry.getKey(), entry.getValue());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    public static String toString(OutboundChannelDefinition def) {
        StringBuilder sb = new StringBuilder();
        sb.append("OutboundChannelDefinition@").append(def.hashCode());
        sb.append(' ').append(def.getOutboundFactory().getName());
        sb.append(",[");
        Map<Object, Object> map = def.getOutboundFactoryProperties();
        if (map == null || map.isEmpty()) {
            sb.append("null]");
        } else {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue());
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
        }
        sb.append(",[");
        map = def.getOutboundChannelProperties();
        if (map == null || map.isEmpty()) {
            sb.append("null]");
        } else {
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                sb.append(entry.getKey());
                sb.append('=');
                sb.append(entry.getValue());
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
        }
        return sb.toString();
    }

    @Override
    public Class<?> getOutboundFactory() {
        return this.factory;
    }

    @Override
    public Map<Object, Object> getOutboundFactoryProperties() {
        return this.factoryProps;
    }

    @Override
    public Map<Object, Object> getOutboundChannelProperties() {
        return this.channelProps;
    }
}

