/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry20.logging.internal;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.logging.data.AccessLogData;
import com.ibm.ws.logging.data.AccessLogDataFormatter;
import com.ibm.ws.logging.data.AuditData;
import com.ibm.ws.logging.data.FFDCData;
import com.ibm.ws.logging.data.GenericData;
import com.ibm.ws.logging.data.KeyValuePair;
import com.ibm.ws.logging.data.KeyValuePairList;
import com.ibm.ws.logging.data.LogTraceData;
import io.openliberty.microprofile.telemetry20.logging.internal.MpTelemetryAccessEventMappingUtils;
import io.openliberty.microprofile.telemetry20.logging.internal.MpTelemetryAuditEventMappingUtils;
import io.openliberty.microprofile.telemetry20.logging.internal.semconv.SemconvConstantsAccessor;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.logs.LogRecordBuilder;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public class MpTelemetryLogMappingUtils {
    private static final TraceComponent tc = Tr.register(MpTelemetryLogMappingUtils.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    static final long serialVersionUID = 8200946268554906643L;

    public static String getLibertyEventType(String source) {
        if (source.equals("com.ibm.ws.logging.source.message")) {
            return "liberty_message";
        }
        if (source.endsWith("com.ibm.ws.logging.source.trace")) {
            return "liberty_trace";
        }
        if (source.endsWith("com.ibm.ws.logging.ffdc.source.ffdcsource")) {
            return "liberty_ffdc";
        }
        if (source.endsWith("audit")) {
            return "liberty_audit";
        }
        if (source.endsWith("com.ibm.ws.http.logging.source.accesslog")) {
            return "liberty_accesslog";
        }
        return "";
    }

    public static void mapLibertyEventToOpenTelemetry(LogRecordBuilder builder, String eventType, Object event, SemconvConstantsAccessor semconvConstantsAccessor) {
        if (eventType.equals("liberty_message")) {
            MpTelemetryLogMappingUtils.mapMessageAndTraceToOpenTelemetry(builder, eventType, event, semconvConstantsAccessor);
        } else if (eventType.equals("liberty_trace")) {
            MpTelemetryLogMappingUtils.mapMessageAndTraceToOpenTelemetry(builder, eventType, event, semconvConstantsAccessor);
        } else if (eventType.equals("liberty_ffdc")) {
            MpTelemetryLogMappingUtils.mapFFDCToOpenTelemetry(builder, eventType, event, semconvConstantsAccessor);
        } else if (eventType.equals("liberty_audit")) {
            MpTelemetryLogMappingUtils.mapAuditLogsToOpenTelemetry(builder, eventType, event, semconvConstantsAccessor);
        } else if (eventType.equals("liberty_accesslog")) {
            MpTelemetryLogMappingUtils.mapAccessToOpenTelemetry(builder, eventType, event, semconvConstantsAccessor);
        }
    }

    private static void mapMessageAndTraceToOpenTelemetry(LogRecordBuilder builder, String eventType, Object event, SemconvConstantsAccessor semconvConstantsAccessor) {
        LogTraceData logData = (LogTraceData)event;
        builder.setTimestamp(logData.getDatetime(), TimeUnit.MILLISECONDS);
        String loglevel = logData.getLoglevel();
        builder.setSeverity(MpTelemetryLogMappingUtils.mapWsLevelToSeverity(loglevel));
        builder.setSeverityText(loglevel);
        String message = logData.getMessage();
        if (loglevel != null && (loglevel.equals("ENTRY") || loglevel.equals("EXIT"))) {
            message = MpTelemetryLogMappingUtils.removeSpace(message);
        }
        builder.setBody(message);
        AttributesBuilder attributes = Attributes.builder();
        attributes.put(semconvConstantsAccessor.threadName(), (Object)logData.getThreadName());
        attributes.put(semconvConstantsAccessor.threadId(), logData.getThreadId());
        String exceptionName = logData.getExceptionName();
        String throwable = logData.getThrowable();
        if (exceptionName != null && throwable != null) {
            attributes.put(semconvConstantsAccessor.exceptionType(), (Object)exceptionName);
            attributes.put(semconvConstantsAccessor.exceptionStackTrace(), (Object)throwable);
        }
        attributes.put("io.openliberty.type", eventType).put("io.openliberty.message_id", logData.getMessageId()).put("io.openliberty.method_name", logData.getMethodName()).put("io.openliberty.module", logData.getModule()).put("io.openliberty.class_name", logData.getClassName()).put("io.openliberty.sequence", logData.getSequence());
        ArrayList extensions = null;
        KeyValuePairList kvpl = null;
        kvpl = logData.getExtensions();
        if (kvpl != null && kvpl.getKey().equals("extensions")) {
            extensions = kvpl.getList();
            for (KeyValuePair k : extensions) {
                String extKey = k.getKey();
                if (extKey.equals("ext_appName")) {
                    attributes.put("io.openliberty.ext.app_name", k.getStringValue());
                    continue;
                }
                if (extKey.equals("ext_thread")) continue;
                if (extKey.endsWith("_int")) {
                    extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                    attributes.put(extKey, (long)k.getIntValue());
                    continue;
                }
                if (extKey.endsWith("_float")) {
                    extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                    attributes.put(extKey, (double)k.getFloatValue());
                    continue;
                }
                if (extKey.endsWith("_long")) {
                    extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                    attributes.put(extKey, k.getLongValue());
                    continue;
                }
                if (extKey.endsWith("_bool")) {
                    extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                    attributes.put(extKey, k.getBooleanValue());
                    continue;
                }
                extKey = MpTelemetryLogMappingUtils.formatExtensionKey(extKey);
                attributes.put(extKey, k.getStringValue());
            }
        }
        builder.setAllAttributes(attributes.build());
        builder.setContext(Context.current());
    }

    private static void mapFFDCToOpenTelemetry(LogRecordBuilder builder, String eventType, Object event, SemconvConstantsAccessor semconvConstantsAccessor) {
        FFDCData ffdcData = (FFDCData)event;
        builder.setTimestamp(ffdcData.getDatetime(), TimeUnit.MILLISECONDS);
        builder.setSeverity(Severity.WARN);
        String ffdcMsg = ffdcData.getMessage();
        if (ffdcMsg != null) {
            builder.setBody(ffdcMsg);
        } else {
            builder.setBody(ffdcData.getExceptionName());
        }
        AttributesBuilder attributes = Attributes.builder();
        attributes.put(semconvConstantsAccessor.threadId(), (Object)ffdcData.getThreadId());
        attributes.put(semconvConstantsAccessor.exceptionType(), (Object)ffdcData.getExceptionName());
        attributes.put(semconvConstantsAccessor.exceptionStackMessage(), (Object)ffdcData.getMessage());
        attributes.put(semconvConstantsAccessor.exceptionStackTrace(), (Object)ffdcData.getStacktrace());
        attributes.put("io.openliberty.type", eventType).put("io.openliberty.probe_id", ffdcData.getProbeId()).put("io.openliberty.object_details", ffdcData.getObjectDetails()).put("io.openliberty.class_name", ffdcData.getClassName()).put("io.openliberty.sequence", ffdcData.getSequence());
        builder.setAllAttributes(attributes.build());
        builder.setContext(Context.current());
    }

    private static void mapAuditLogsToOpenTelemetry(LogRecordBuilder builder, String eventType, Object event, SemconvConstantsAccessor semconvConstantsAccessor) {
        GenericData genData = (GenericData)event;
        KeyValuePair[] pairs = genData.getPairs();
        String key = null;
        builder.setSeverity(Severity.INFO2);
        AttributesBuilder attributes = Attributes.builder();
        attributes.put("io.openliberty.type", eventType);
        for (KeyValuePair kvp : pairs) {
            if (kvp == null || kvp.isList() || (key = kvp.getKey()).equals("ibm_datetime") || key.equals("loggingEventTime") || AuditData.getDatetimeKey((int)0).equals(key)) continue;
            if (key.equals("eventName")) {
                builder.setBody(kvp.getStringValue());
                attributes.put(MpTelemetryAuditEventMappingUtils.getOTelMappedAuditEventKeyName(key), kvp.getStringValue());
                continue;
            }
            if (key.equals("eventTime")) {
                builder.setTimestamp(MpTelemetryLogMappingUtils.formatDateTime(kvp.getStringValue()));
                continue;
            }
            if (key.equals("ibm_sequence") || key.equals("loggingSequenceNumber") || AuditData.getSequenceKey((int)0).equals(key)) {
                attributes.put("io.openliberty.sequence", kvp.getStringValue());
                continue;
            }
            if (key.equals("ibm_threadId") || AuditData.getThreadIDKey((int)0).equals(key)) {
                attributes.put(semconvConstantsAccessor.threadId(), kvp.getIntValue());
                continue;
            }
            attributes.put(MpTelemetryAuditEventMappingUtils.getOTelMappedAuditEventKeyName(key), kvp.getStringValue());
        }
        builder.setAllAttributes(attributes.build());
        builder.setContext(Context.current());
    }

    private static void mapAccessToOpenTelemetry(LogRecordBuilder builder, String eventType, Object event, SemconvConstantsAccessor semconvConstantsAccessor) {
        AccessLogData accessLogData = (AccessLogData)event;
        builder.setSeverity(Severity.INFO2);
        builder.setBody("Empty");
        AttributesBuilder attributes = Attributes.builder();
        ArrayList kvpList = new ArrayList();
        AccessLogDataFormatter[] formatters = accessLogData.getFormatters();
        if (formatters[4] != null) {
            formatters[4].populate(kvpList, accessLogData);
        } else if (formatters[5] != null) {
            formatters[5].populate(kvpList, accessLogData);
        }
        String key = null;
        Object value = null;
        Span customSpan = null;
        for (KeyValuePair next : kvpList) {
            key = next.getKey();
            value = MpTelemetryLogMappingUtils.getPairValue(next);
            String formattedKey = MpTelemetryAccessEventMappingUtils.getOTelMappedAccessEventKeyName(key);
            if (value == null) continue;
            if (key.equals("requestProtocol")) {
                String[] requestProtocolSplit = value.toString().split("/");
                attributes.put(semconvConstantsAccessor.networkProtocolName(), (Object)requestProtocolSplit[0]);
                attributes.put(semconvConstantsAccessor.networkProtocolVersion(), (Object)requestProtocolSplit[1]);
                continue;
            }
            if (key.equals("datetime") || key.equals("accessLogDatetime")) {
                builder.setTimestamp(MpTelemetryLogMappingUtils.formatDateTime((String)value));
                continue;
            }
            if (key.contains("requestHeader") || key.contains("responseHeader")) {
                if (key.equals("responseHeader_io.openliberty.trace")) {
                    customSpan = MpTelemetryLogMappingUtils.createSpan(key, (String)value);
                    continue;
                }
                String[] headerSplit = ((String)value).split(",");
                for (int i = 0; i < headerSplit.length; ++i) {
                    headerSplit[i] = headerSplit[i].trim();
                }
                attributes.put(formattedKey, headerSplit);
                continue;
            }
            if (key.equals("requestPort")) {
                attributes.put(formattedKey, (long)Integer.parseInt((String)value));
                continue;
            }
            if (key.equals("requestFirstLine")) {
                attributes.put(formattedKey, (String)value);
                String accessLogMsg = accessLogData.getRequestFirstLine();
                if (accessLogMsg == null) continue;
                builder.setBody(accessLogMsg);
                continue;
            }
            if (value instanceof String) {
                attributes.put(formattedKey, (String)value);
                continue;
            }
            if (value instanceof Long) {
                attributes.put(formattedKey, ((Long)value).longValue());
                continue;
            }
            if (!(value instanceof Integer)) continue;
            attributes.put(formattedKey, (long)((Integer)value).intValue());
        }
        attributes.put("io.openliberty.type", eventType);
        builder.setAllAttributes(attributes.build());
        if (customSpan != null) {
            builder.setContext(Context.current().with(customSpan));
        } else {
            builder.setContext(Context.current());
        }
    }

    private static Span createSpan(String key, String requestHeader) {
        SpanContext customSpanContext;
        block4: {
            customSpanContext = null;
            try {
                if (key.equals("responseHeader_io.openliberty.trace")) {
                    String[] traceSplit = requestHeader.split(":");
                    customSpanContext = SpanContext.create((String)traceSplit[0], (String)traceSplit[1], (TraceFlags)TraceFlags.getSampled(), (TraceState)TraceState.getDefault());
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught an exception when parsing trace and span ID. An invalid header value was found for header: " + key + ", header value: "), (Object[])new Object[]{requestHeader});
            }
        }
        if (customSpanContext != null) {
            Span customSpan = Span.wrap(customSpanContext);
            return customSpan;
        }
        return null;
    }

    private static Severity mapWsLevelToSeverity(String level) {
        if (level.equals(WsLevel.FATAL.toString())) {
            return Severity.FATAL;
        }
        if (level.equals(WsLevel.SEVERE.toString()) || level.equals(WsLevel.ERROR.toString())) {
            return Severity.ERROR;
        }
        if (level.equals(WsLevel.WARNING.toString()) || level.equals("SystemErr")) {
            return Severity.WARN;
        }
        if (level.equals(WsLevel.AUDIT.toString())) {
            return Severity.INFO2;
        }
        if (level.equals(WsLevel.INFO.toString()) || level.equals("SystemOut")) {
            return Severity.INFO;
        }
        if (level.equals(WsLevel.CONFIG.toString())) {
            return Severity.DEBUG4;
        }
        if (level.equals(WsLevel.DETAIL.toString())) {
            return Severity.DEBUG3;
        }
        if (level.equals(WsLevel.FINE.toString()) || level.equals(WsLevel.EVENT.toString())) {
            return Severity.DEBUG2;
        }
        if (level.equals(WsLevel.FINER.toString()) || level.equals("ENTRY") || level.equals("EXIT")) {
            return Severity.DEBUG;
        }
        if (level.equals(WsLevel.FINEST.toString())) {
            return Severity.TRACE;
        }
        return Severity.INFO;
    }

    private static String formatExtensionKey(String extKey) {
        StringBuffer sb = new StringBuffer();
        String extName = "";
        int extStartIdx = extKey.indexOf("_");
        int extEndIdx = extKey.indexOf("_", extStartIdx + 1);
        extName = extEndIdx != -1 ? extKey.substring(extStartIdx + 1, extEndIdx) : extKey.substring(extStartIdx + 1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing the name from the following extension key: " + extKey + " to " + extName), (Object[])new Object[0]);
        }
        sb.append("io.openliberty.ext.").append(extName.toLowerCase());
        return sb.toString();
    }

    private static String removeSpace(String s) {
        StringBuilder sb = new StringBuilder();
        boolean isLine = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                sb.append(c);
                isLine = true;
                continue;
            }
            if (c == ' ' && isLine) continue;
            if (isLine && c != ' ') {
                isLine = false;
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static Instant formatDateTime(String dateTime) {
        TemporalAccessor tempAccessor = FORMATTER.parse(dateTime);
        Instant instant = Instant.from(tempAccessor);
        return instant;
    }

    private static Object getPairValue(KeyValuePair value) {
        KeyValuePair.ValueTypes pairValueType = value.getType();
        if (pairValueType.equals((Object)KeyValuePair.ValueTypes.STRING)) {
            return value.getStringValue();
        }
        if (pairValueType.equals((Object)KeyValuePair.ValueTypes.LONG)) {
            return value.getLongValue();
        }
        if (pairValueType.equals((Object)KeyValuePair.ValueTypes.INTEGER)) {
            return value.getIntValue();
        }
        return value.getStringValue();
    }
}

