/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi.internal.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi.internal.common.services.OpenAPIAppConfigProvider;
import io.openliberty.microprofile.openapi.internal.common.services.OpenAPIServerXMLConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.OPTIONAL, configurationPid={"io.openliberty.microprofile.openapi"})
public class OpenAPIAppConfigProviderImpl
implements OpenAPIAppConfigProvider {
    private static final TraceComponent tc = Tr.register(OpenAPIAppConfigProviderImpl.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final String INVALID_APP_WARNING = "OPEN_API_SLASH_IN_APPLICATION_CWWKO1678W";
    private static final String INVALID_MODULE_WARNING = "OPEN_API_SLASH_IN_MODULE_CWWKO1679W";
    private static final String INCLUDE_APP_PROPERTY_NAME = "includeApplication";
    private static final String EXCLUDE_APP_PROPERTY_NAME = "excludeApplication";
    private static final String INCLUDE_MODULE_PROPERTY_NAME = "includeModule";
    private static final String EXCLUDE_MODULE_PROPERTY_NAME = "excludeModule";
    private final List<OpenAPIAppConfigProvider.OpenAPIAppConfigListener> openAPIAppConfigListeners = new CopyOnWriteArrayList<OpenAPIAppConfigProvider.OpenAPIAppConfigListener>();
    private volatile MpConfigServerConfigObject config = null;
    static final long serialVersionUID = 3516552485670287729L;

    @Activate
    protected void activate(BundleContext context, Map<String, Object> properties) {
        MpConfigServerConfigObject newConfig;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Initial processing of server.xml", (Object[])new Object[0]);
        }
        this.config = newConfig = new MpConfigServerConfigObject(properties);
    }

    @Modified
    protected void modified(Map<String, Object> properties) {
        MpConfigServerConfigObject newConfig;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Processing update to server.xml", (Object[])new Object[0]);
        }
        if (this.config.equals(newConfig = new MpConfigServerConfigObject(properties))) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"After update there is no need to rebuild the openAPI document", (Object[])new Object[0]);
        } else {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Clearing out the outdated openAPI document", (Object[])new Object[0]);
            this.config = newConfig;
            this.openAPIAppConfigListeners.sort((o1, o2) -> Integer.compare(o1.getConfigListenerPriority(), o2.getConfigListenerPriority()));
            for (OpenAPIAppConfigProvider.OpenAPIAppConfigListener listener : this.openAPIAppConfigListeners) {
                listener.processConfigUpdate();
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Deactivating OpenAPIAppConfigProviderImpl", (Object[])new Object[0]);
        }
        this.config = null;
    }

    @Override
    @Deprecated
    public MpConfigServerConfigObject getConfiguration() {
        return this.config;
    }

    @Override
    public void registerAppConfigListener(OpenAPIAppConfigProvider.OpenAPIAppConfigListener listener) {
        this.openAPIAppConfigListeners.add(listener);
    }

    @Override
    public void unregisterAppConfigListener(OpenAPIAppConfigProvider.OpenAPIAppConfigListener listener) {
        this.openAPIAppConfigListeners.remove(listener);
    }

    private static boolean isNotValidModuleName(String elementName) {
        if (elementName.indexOf(47) < 0 || elementName.indexOf(47) == elementName.length() - 1) {
            Tr.warning((TraceComponent)tc, (String)INVALID_MODULE_WARNING, (Object[])new Object[]{elementName, elementName});
            return true;
        }
        return false;
    }

    private static boolean isNotValidAppName(String elementName) {
        if (elementName.indexOf(47) >= 0 || elementName.length() == 0) {
            Tr.warning((TraceComponent)tc, (String)INVALID_APP_WARNING, (Object[])new Object[]{elementName, elementName});
            return true;
        }
        return false;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class MpConfigServerConfigObject
    implements OpenAPIServerXMLConfig {
        private final List<String> includedApps = new ArrayList<String>();
        private final List<String> excludedApps = new ArrayList<String>();
        private final List<String> includedModules = new ArrayList<String>();
        private final List<String> excludedModules = new ArrayList<String>();
        private Optional<OpenAPIServerXMLConfig.ConfigMode> configMode = Optional.empty();
        static final long serialVersionUID = -7115958107968365894L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private MpConfigServerConfigObject(Map<String, Object> properties) {
            Optional<String[]> includedAppArray = Optional.ofNullable((String[])properties.get(OpenAPIAppConfigProviderImpl.INCLUDE_APP_PROPERTY_NAME));
            Optional<String[]> excludedAppArray = Optional.ofNullable((String[])properties.get(OpenAPIAppConfigProviderImpl.EXCLUDE_APP_PROPERTY_NAME));
            Optional<String[]> includedModulesArray = Optional.ofNullable((String[])properties.get(OpenAPIAppConfigProviderImpl.INCLUDE_MODULE_PROPERTY_NAME));
            Optional<String[]> excludedModulesArray = Optional.ofNullable((String[])properties.get(OpenAPIAppConfigProviderImpl.EXCLUDE_MODULE_PROPERTY_NAME));
            Optional<List<Object>> includedAppList = includedAppArray.map(array -> new ArrayList<String>(Arrays.asList(array)));
            Optional<List> excludedAppList = excludedAppArray.map(array -> new ArrayList<String>(Arrays.asList(array)));
            Optional<List> includedModulesList = includedModulesArray.map(array -> new ArrayList<String>(Arrays.asList(array)));
            Optional<List> excludedModulesList = excludedModulesArray.map(array -> new ArrayList<String>(Arrays.asList(array)));
            includedAppList.ifPresent(list -> list.removeIf(x$0 -> OpenAPIAppConfigProviderImpl.isNotValidAppName(x$0)));
            excludedAppList.ifPresent(list -> list.removeIf(x$0 -> OpenAPIAppConfigProviderImpl.isNotValidAppName(x$0)));
            includedModulesList.ifPresent(list -> list.removeIf(x$0 -> OpenAPIAppConfigProviderImpl.isNotValidModuleName(x$0)));
            excludedModulesList.ifPresent(list -> list.removeIf(x$0 -> OpenAPIAppConfigProviderImpl.isNotValidModuleName(x$0)));
            if (includedAppList.isPresent() && includedAppList.get().size() == 1) {
                String includedString = ((String)includedAppList.get().get(0)).toLowerCase().trim();
                if (includedString.equals("all")) {
                    this.configMode = Optional.of(OpenAPIServerXMLConfig.ConfigMode.All);
                    includedAppList = Optional.empty();
                } else if (includedString.equals("first")) {
                    this.configMode = Optional.of(OpenAPIServerXMLConfig.ConfigMode.First);
                    includedAppList = Optional.empty();
                } else if (includedString.equals("none")) {
                    this.configMode = Optional.of(OpenAPIServerXMLConfig.ConfigMode.None);
                    includedAppList = Optional.empty();
                }
            }
            this.includedApps.addAll(includedAppList.orElse(Collections.emptyList()));
            this.excludedApps.addAll(excludedAppList.orElse(Collections.emptyList()));
            this.includedModules.addAll(includedModulesList.orElse(Collections.emptyList()));
            this.excludedModules.addAll(excludedModulesList.orElse(Collections.emptyList()));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"OpenAPI finished processing modules from server.xml. found the following configuration for included apps {0}, found the following configuration for excluded apps {1}, found the following configuration for included modules {2}, found the following configuration for excluded modules {3}", (Object[])new Object[]{this.includedApps, this.excludedApps, this.includedModules, this.excludedModules});
            }
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof MpConfigServerConfigObject)) {
                return false;
            }
            MpConfigServerConfigObject otherConfig = (MpConfigServerConfigObject)other;
            return this.includedApps.equals(otherConfig.includedApps) && this.excludedApps.equals(otherConfig.excludedApps) && this.includedModules.equals(otherConfig.includedModules) && this.excludedModules.equals(otherConfig.excludedModules) && this.configMode.equals(otherConfig.configMode);
        }

        public int hashCode() {
            return Objects.hash(this.configMode, this.excludedApps, this.excludedModules, this.includedApps, this.includedModules);
        }

        @Override
        public Optional<List<String>> getIncludedAppsAndModules() {
            ArrayList<String> combinedList = new ArrayList<String>(this.includedApps);
            combinedList.addAll(this.includedModules);
            return combinedList.isEmpty() ? Optional.empty() : Optional.of(Collections.unmodifiableList(combinedList));
        }

        @Override
        public Optional<List<String>> getExcludedAppsAndModules() {
            ArrayList<String> combinedList = new ArrayList<String>(this.excludedApps);
            combinedList.addAll(this.excludedModules);
            return combinedList.isEmpty() ? Optional.empty() : Optional.of(Collections.unmodifiableList(combinedList));
        }

        @Override
        public Optional<OpenAPIServerXMLConfig.ConfigMode> getConfigMode() {
            return this.configMode;
        }

        @Override
        public boolean wasAnyConfigFound() {
            return this.includedApps.size() > 0 || this.excludedApps.size() > 0 || this.includedModules.size() > 0 || this.excludedModules.size() > 0 || this.configMode.isPresent();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("MpConfigServerConfigObject [includedApps=");
            builder.append(this.includedApps);
            builder.append(", excludedApps=");
            builder.append(this.excludedApps);
            builder.append(", includedModules=");
            builder.append(this.includedModules);
            builder.append(", excludedModules=");
            builder.append(this.excludedModules);
            builder.append(", configMode=");
            builder.append(this.configMode);
            builder.append(", wasAnyConfigFound()=");
            builder.append(this.wasAnyConfigFound());
            builder.append("]");
            return builder.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi.internal.common.OpenAPIAppConfigProviderImpl$MpConfigServerConfigObject", MpConfigServerConfigObject.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }
}

