/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channelfw.internal.chains;

import com.ibm.websphere.channelfw.ChainData;
import com.ibm.websphere.channelfw.ChannelData;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channelfw.internal.ChannelFactoryDataImpl;
import com.ibm.ws.channelfw.internal.ChannelFrameworkImpl;
import com.ibm.ws.channelfw.internal.ChildChannelDataImpl;
import com.ibm.ws.channelfw.internal.RuntimeState;
import com.ibm.ws.channelfw.internal.chains.Chain;
import com.ibm.ws.channelfw.internal.discrim.DiscriminationGroup;
import com.ibm.ws.channelfw.internal.discrim.DiscriminationProcessImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channelfw.Channel;
import com.ibm.wsspi.channelfw.ChannelFactory;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.DiscriminationProcess;
import com.ibm.wsspi.channelfw.Discriminator;
import com.ibm.wsspi.channelfw.InboundChannel;
import com.ibm.wsspi.channelfw.exception.ChainException;
import com.ibm.wsspi.channelfw.exception.ChannelException;
import com.ibm.wsspi.channelfw.exception.ChannelFactoryException;
import com.ibm.wsspi.channelfw.exception.DiscriminationProcessException;
import com.ibm.wsspi.channelfw.exception.IncoherentChainException;
import com.ibm.wsspi.channelfw.exception.InvalidChannelNameException;
import java.util.Map;

public class InboundChain
extends Chain {
    private static final TraceComponent tc = Tr.register(InboundChain.class, (String)"ChannelFramework", (String)"com.ibm.ws.channelfw.internal.resources.ChannelfwMessages");

    public InboundChain(ChainData config, ChannelFrameworkImpl framework) throws ChannelException, IncoherentChainException {
        super(config);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object[])new Object[0]);
        }
        ChannelFactory channelFactory = null;
        this.channels = new InboundChannel[this.channelDataArray.length];
        Channel prevChannel = null;
        for (int i = 0; i < this.channelDataArray.length; ++i) {
            DiscriminationProcess dp;
            channelFactory = framework.getChannelFactoryInternal(this.channelDataArray[i].getFactoryType(), true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("factory: " + channelFactory), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("findOrCreateChannel: " + this.channelDataArray[i].getName()), (Object[])new Object[0]);
            }
            if (i != 0) {
                ((ChildChannelDataImpl)this.channelDataArray[i]).setDeviceInterface(this.channels[i - 1].getApplicationInterface());
            }
            ((ChildChannelDataImpl)this.channelDataArray[i]).setIsInbound(true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("putting into PropertyBag chain name of: " + this.chainData.getName()), (Object[])new Object[0]);
            }
            Map<Object, Object> propertyBag = this.channelDataArray[i].getPropertyBag();
            propertyBag.put("chainName", this.chainData.getName());
            this.channels[i] = channelFactory.findOrCreateChannel(this.channelDataArray[i]);
            if (null == this.channels[i]) {
                InvalidChannelNameException e = new InvalidChannelNameException("Chain cannot be created because of channel, " + this.channelDataArray[i].getName());
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".constructor"), (String)"89", (Object)this, (Object[])new Object[]{this.channelDataArray[i]});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"constructor");
                }
                throw e;
            }
            if (null != prevChannel) {
                Class<?> prevChannelDiscType = ((InboundChannel)prevChannel).getDiscriminatoryType();
                Class<?> nextChannelDiscDataType = ((InboundChannel)this.channels[i]).getDiscriminator().getDiscriminatoryDataType();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("prev.AppSideClass: " + prevChannel.getApplicationInterface()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("this.DevSideClass: " + this.channels[i].getDeviceInterface()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("prev.DiscType: " + prevChannelDiscType), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("this.DiscType: " + nextChannelDiscDataType), (Object[])new Object[0]);
                }
                if (prevChannelDiscType != nextChannelDiscDataType) {
                    IncoherentChainException e = new IncoherentChainException("Unmatching channel disc types: " + prevChannel.getName() + ", " + prevChannelDiscType + " " + this.channels[i].getName() + ", " + nextChannelDiscDataType);
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".constructor"), (String)"122", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"constructor");
                    }
                    throw e;
                }
                if (prevChannel.getApplicationInterface() != this.channels[i].getDeviceInterface()) {
                    IncoherentChainException e = new IncoherentChainException("Unmatching channel interfaces: " + prevChannel.getName() + ", " + this.channels[i].getName());
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".constructor"), (String)"136", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"constructor");
                    }
                    throw e;
                }
            }
            if (this.channelDataArray.length != i + 1 && null == (dp = ((InboundChannel)this.channels[i]).getDiscriminationProcess())) {
                Class<?> discriminatoryType = ((InboundChannel)this.channels[i]).getDiscriminatoryType();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("discriminatoryType: " + discriminatoryType), (Object[])new Object[0]);
                }
                dp = new DiscriminationProcessImpl(discriminatoryType, this.channelDataArray[i].getName());
                ((InboundChannel)this.channels[i]).setDiscriminationProcess(dp);
            }
            prevChannel = this.channels[i];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    public void setupDiscProcess() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setupDiscProcess", (Object[])new Object[0]);
        }
        ChannelData[] list = this.chainData.getChannelList();
        Class<?> discriminatoryType = null;
        DiscriminationProcessImpl dp = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Get the channels started", (Object[])new Object[0]);
        }
        for (int i = 0; i < list.length; ++i) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set up disc process for channel, " + list[i].getName()), (Object[])new Object[0]);
            }
            if (list.length != i + 1) {
                dp = (DiscriminationProcessImpl)((InboundChannel)this.channels[i]).getDiscriminationProcess();
                if (dp == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Create a discrimination process for channel, " + this.channels[i].getName()), (Object[])new Object[0]);
                    }
                    discriminatoryType = ((InboundChannel)this.channels[i]).getDiscriminatoryType();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Discriminatory type: " + discriminatoryType), (Object[])new Object[0]);
                    }
                    dp = new DiscriminationProcessImpl(discriminatoryType, list[i].getName());
                    ((InboundChannel)this.channels[i]).setDiscriminationProcess(dp);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Found DP: " + dp), (Object[])new Object[0]);
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Last channel in chain, " + list[i].getName()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setupDiscProcess");
        }
    }

    public void startDiscProcessBetweenChannels(InboundChannel appChannel, InboundChannel devChannel, int discWeight) throws ChainException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startDiscProcessBetweenChannels", (Object[])new Object[0]);
        }
        Discriminator d = null;
        Exception discException = null;
        try {
            d = appChannel.getDiscriminator();
            if (d == null) {
                discException = new Exception("Null discriminator extracted from channel " + appChannel.getName());
            }
        }
        catch (Exception e) {
            discException = e;
        }
        if (null != discException) {
            FFDCFilter.processException((Throwable)discException, (String)(this.getClass().getName() + ".startDiscProcessBetweenChannels"), (String)"234", (Object)this, (Object[])new Object[]{appChannel, devChannel, discWeight});
            throw new ChainException("Unable to get discriminator from " + appChannel.getName(), discException);
        }
        DiscriminationGroup prevDg = (DiscriminationGroup)devChannel.getDiscriminationProcess();
        if (!((DiscriminationProcessImpl)prevDg).containsDiscriminator(d)) {
            if (!prevDg.getDiscriminators().isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Create new dp for channel, " + devChannel.getName()), (Object[])new Object[0]);
                }
                DiscriminationProcessImpl newDg = new DiscriminationProcessImpl(devChannel.getDiscriminatoryType(), prevDg);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Add in discriminator from channel, " + appChannel.getName()), (Object[])new Object[0]);
                }
                newDg.addDiscriminator(d, discWeight);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Set dp into channel, " + devChannel.getName()), (Object[])new Object[0]);
                }
                newDg.start();
                devChannel.setDiscriminationProcess(newDg);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Add in disc from channel, " + appChannel.getName() + " into dp of channel, " + devChannel.getName()), (Object[])new Object[0]);
                }
                prevDg.addDiscriminator(d, discWeight);
                prevDg.start();
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Found discriminator in dp, " + appChannel.getName()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startDiscProcessBetweenChannels");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableChannel(Channel inputChannel) throws InvalidChannelNameException, DiscriminationProcessException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("disableChannel: " + inputChannel.getName()), (Object[])new Object[0]);
        }
        RuntimeState runtimeState = this.state;
        synchronized (runtimeState) {
            if (RuntimeState.STARTED.equals(this.state) || RuntimeState.QUIESCED.equals(this.state)) {
                int index;
                String targetName = inputChannel.getName();
                InboundChannel prevChannel = null;
                for (index = 0; index < this.channels.length && !this.channels[index].getName().equals(targetName); ++index) {
                    prevChannel = (InboundChannel)this.channels[index];
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Index of channel, " + index), (Object[])new Object[0]);
                }
                if (this.channels.length == index) {
                    InvalidChannelNameException e = new InvalidChannelNameException("ERROR: can't unlink unknown channel, " + targetName);
                    FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".disableChannel"), (String)"319", (Object)this, (Object[])new Object[]{inputChannel});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"disableChannel");
                    }
                    throw e;
                }
                if (null != prevChannel) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Previous channel, " + prevChannel.getName()), (Object[])new Object[0]);
                    }
                    Class<?> discriminatoryType = prevChannel.getDiscriminatoryType();
                    DiscriminationProcessImpl newDp = new DiscriminationProcessImpl(discriminatoryType, (DiscriminationGroup)prevChannel.getDiscriminationProcess());
                    newDp.removeDiscriminator(((InboundChannel)inputChannel).getDiscriminator());
                    prevChannel.setDiscriminationProcess(newDp);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("RuntimeState invalid to disable channel: " + inputChannel.getName() + ", chain state: " + this.state.ordinal), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"disableChannel");
        }
    }

    public static void verifyChainCoherency(ChainData chainData) throws IncoherentChainException {
        ChannelData[] channelDataArray;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"verifyChainCoherency", (Object[])new Object[0]);
        }
        if ((channelDataArray = chainData.getChannelList()).length > 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Found channel list greater than 1", (Object[])new Object[0]);
            }
            ChannelFrameworkImpl fw = (ChannelFrameworkImpl)ChannelFrameworkFactory.getChannelFramework();
            ChannelFactoryDataImpl current = null;
            ChannelFactoryDataImpl next = null;
            Class<?> currentAppClass = null;
            Class<?>[] nextDevClasses = null;
            try {
                current = fw.findOrCreateChannelFactoryData(channelDataArray[0].getFactoryType());
            }
            catch (ChannelFactoryException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Found invalid channel factory of type " + channelDataArray[0].getFactoryType().getName()), (Object[])new Object[0]);
                }
                throw new IncoherentChainException("Invalid channel factory");
            }
            for (int i = 1; i < channelDataArray.length; ++i) {
                currentAppClass = current.getApplicationInterface();
                try {
                    next = fw.findOrCreateChannelFactoryData(channelDataArray[i].getFactoryType());
                }
                catch (ChannelFactoryException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found invalid channel factory of type " + channelDataArray[i].getFactoryType().getName()), (Object[])new Object[0]);
                    }
                    throw new IncoherentChainException("Invalid channel factory");
                }
                nextDevClasses = next.getDeviceInterface();
                if (null == currentAppClass || null == nextDevClasses) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found null interface classes between two channel factories: " + current.getFactory().getName() + ", " + next.getFactory().getName()), (Object[])new Object[0]);
                    }
                    throw new IncoherentChainException("Found null interface classes between two channel factories: " + current.getFactory().getName() + ", " + next.getFactory().getName());
                }
                boolean foundMatch = false;
                for (int j = 0; j < nextDevClasses.length; ++j) {
                    if (!currentAppClass.isAssignableFrom(nextDevClasses[j])) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found compatible class; " + currentAppClass), (Object[])new Object[0]);
                    }
                    foundMatch = true;
                    break;
                }
                if (!foundMatch) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found incoherency between two channel factories: " + current + ", " + next), (Object[])new Object[0]);
                    }
                    throw new IncoherentChainException("Found incoherency between two channel factories: " + current + ", " + next);
                }
                current = next;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"verifyChainCoherency");
        }
    }
}

