/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.merge;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.MergedOpenAPIProvider;
import io.openliberty.microprofile.openapi20.internal.merge.ModelCopy;
import io.openliberty.microprofile.openapi20.internal.merge.ModelEquality;
import io.openliberty.microprofile.openapi20.internal.merge.NameProcessor;
import io.openliberty.microprofile.openapi20.internal.merge.NameType;
import io.openliberty.microprofile.openapi20.internal.merge.RenameReferenceVisitor;
import io.openliberty.microprofile.openapi20.internal.services.MergeProcessor;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIProvider;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIUtils;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.Components;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MergeProcessorImpl
implements MergeProcessor {
    private static final TraceComponent tc = Tr.register(MergeProcessorImpl.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final Info MERGED_INFO = OASFactory.createInfo();
    @Reference
    protected OpenAPIModelWalker modelWalker;
    static final long serialVersionUID = -6369521323745026418L;

    /*
     * WARNING - void declaration
     */
    @Override
    public OpenAPIProvider mergeDocuments(List<OpenAPIProvider> documents) {
        MergeProcessorInstance mergeProcessor = this.createMergeProcessorInstance(documents);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)mergeProcessor, (TraceComponent)tc, (String)("Beginning merge of OpenAPI documents for " + documents), (Object[])new Object[0]);
        }
        mergeProcessor.process();
        OpenAPIProvider mergedDoc = mergeProcessor.getMergedDocument();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            try {
                Tr.event((Object)mergeProcessor, (TraceComponent)tc, (String)"Merged document: ", (Object[])new Object[]{OpenApiSerializer.serialize((OpenAPI)mergedDoc.getModel(), (Format)Format.JSON)});
            }
            catch (IOException iOException) {
                void e;
                FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.microprofile.openapi20.internal.merge.MergeProcessorImpl", (String)"109", (Object)this, (Object[])new Object[]{documents});
                Tr.event((Object)mergeProcessor, (TraceComponent)tc, (String)"Unable to trace merged document", (Object[])new Object[]{e});
            }
        }
        return mergedDoc;
    }

    protected MergeProcessorInstance createMergeProcessorInstance(List<OpenAPIProvider> documents) {
        return new MergeProcessorInstance(documents);
    }

    private static void prependPaths(OpenAPI model, String contextRoot, NameProcessor.DocumentNameProcessor documentNameProcessor) {
        if (contextRoot == null) {
            return;
        }
        if (contextRoot.endsWith("/")) {
            contextRoot = contextRoot.substring(0, contextRoot.length() - 1);
        }
        if (contextRoot.isEmpty()) {
            return;
        }
        Paths paths = model.getPaths();
        if (paths == null) {
            return;
        }
        List servers = model.getServers();
        boolean allServersEndWithContextRoot = true;
        for (Object server : OpenAPIUtils.notNull(servers)) {
            if (MergeProcessorImpl.serverEndsWithContextRoot((Server)server, contextRoot)) continue;
            allServersEndWithContextRoot = false;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break;
            Tr.event((TraceComponent)tc, (String)("Server " + server.getUrl() + " does not end with the context root " + contextRoot + ". Context root cannot be prepended to paths."), (Object[])new Object[0]);
            break;
        }
        Map pathItems = paths.getPathItems();
        if (allServersEndWithContextRoot) {
            for (Map.Entry entry : pathItems.entrySet()) {
                if (MergeProcessorImpl.pathServersEndWithContextRoot((PathItem)entry.getValue(), contextRoot)) continue;
                allServersEndWithContextRoot = false;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Server under path " + (String)entry.getKey() + " did not end with context root " + contextRoot + ". Context root cannot be prepended to paths."), (Object[])new Object[0]);
            }
        }
        if (allServersEndWithContextRoot) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Removing context root " + contextRoot + " from servers and adding it to paths"), (Object[])new Object[0]);
            }
            for (Server server : OpenAPIUtils.notNull(servers)) {
                MergeProcessorImpl.removeContextRoot(server, contextRoot);
            }
            LinkedHashMap<String, PathItem> newPathItems = new LinkedHashMap<String, PathItem>();
            for (Map.Entry entry : pathItems.entrySet()) {
                PathItem pathItem = (PathItem)entry.getValue();
                for (Server server : OpenAPIUtils.notNull(pathItem.getServers())) {
                    MergeProcessorImpl.removeContextRoot(server, contextRoot);
                }
                for (Operation op : OpenAPIUtils.notNull(pathItem.getOperations()).values()) {
                    for (Server server : OpenAPIUtils.notNull(op.getServers())) {
                        MergeProcessorImpl.removeContextRoot(server, contextRoot);
                    }
                }
                String newPath = MergeProcessorImpl.addContextRoot((String)entry.getKey(), contextRoot);
                documentNameProcessor.registerRename(NameType.PATHS, (String)entry.getKey(), newPath);
                newPathItems.put(newPath, pathItem);
            }
            paths.setPathItems(newPathItems);
            boolean bl = OpenAPIUtils.notNull(servers).stream().allMatch(MergeProcessorImpl::isServerEmpty);
            if (bl) {
                model.setServers(null);
            }
        }
    }

    private static boolean isServerEmpty(Server server) {
        Map extensions = server.getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            return false;
        }
        String description = server.getDescription();
        if (description != null && !description.isEmpty()) {
            return false;
        }
        Map variables = server.getVariables();
        if (variables != null && !variables.isEmpty()) {
            return false;
        }
        String url = server.getUrl();
        return url == null || url.isEmpty() || url.equals("/");
    }

    private static boolean pathServersEndWithContextRoot(PathItem pathItem, String contextRoot) {
        boolean allServersEndWithContextRoot = true;
        for (Server server : OpenAPIUtils.notNull(pathItem.getServers())) {
            if (MergeProcessorImpl.serverEndsWithContextRoot(server, contextRoot)) continue;
            allServersEndWithContextRoot = false;
            break;
        }
        if (allServersEndWithContextRoot) {
            block1: for (Operation op : OpenAPIUtils.notNull(pathItem.getOperations()).values()) {
                for (Server server : OpenAPIUtils.notNull(op.getServers())) {
                    if (MergeProcessorImpl.serverEndsWithContextRoot(server, contextRoot)) continue;
                    allServersEndWithContextRoot = false;
                    continue block1;
                }
            }
        }
        return allServersEndWithContextRoot;
    }

    private static String addContextRoot(String key, String contextRoot) {
        return contextRoot + key;
    }

    private static void removeContextRoot(Server server, String contextRoot) {
        String url = server.getUrl();
        String newUrl = url.endsWith("/") ? url.substring(0, url.length() - contextRoot.length() - 1) : url.substring(0, url.length() - contextRoot.length());
        server.setUrl(newUrl);
    }

    private static boolean serverEndsWithContextRoot(Server server, String contextRoot) {
        return server.getUrl().endsWith(contextRoot) || server.getUrl().endsWith(contextRoot + "/");
    }

    private static boolean isSecurityIdentical(List<InProgressModel> models) {
        List reqs = models.stream().map(d -> ((InProgressModel)d).model.getSecurity()).collect(Collectors.toList());
        return OpenAPIUtils.allEqual(reqs, ModelEquality::equals);
    }

    private static boolean isServersIdentical(List<InProgressModel> processedModels) {
        List servers = processedModels.stream().map(m -> ((InProgressModel)m).model).map(OpenAPI::getServers).collect(Collectors.toList());
        return OpenAPIUtils.allEqual(servers, ModelEquality::equals);
    }

    private static boolean isInfoIdentical(List<InProgressModel> models) {
        List infos = models.stream().map(m -> ((InProgressModel)m).model).map(OpenAPI::getInfo).collect(Collectors.toList());
        return OpenAPIUtils.allEqual(infos, ModelEquality::equals);
    }

    private static boolean isExternalDocsIdentical(List<InProgressModel> models) {
        List docs = models.stream().map(m -> ((InProgressModel)m).model).map(OpenAPI::getExternalDocs).collect(Collectors.toList());
        return OpenAPIUtils.allEqual(docs, ModelEquality::equals);
    }

    private static void moveServersUnderPaths(OpenAPI model) {
        List servers = model.getServers();
        if (servers == null) {
            return;
        }
        Paths paths = model.getPaths();
        if (paths != null) {
            for (PathItem item : OpenAPIUtils.notNull(paths.getPathItems()).values()) {
                if (item.getServers() != null) continue;
                item.setServers(servers);
            }
        }
        model.setServers(null);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        MERGED_INFO.setTitle("Merged documentation");
        MERGED_INFO.setVersion("1.0");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected class MergeProcessorInstance {
        private List<OpenAPIProvider> providers = new ArrayList<OpenAPIProvider>();
        private final List<OpenAPI> processedModels = new ArrayList<OpenAPI>();
        private final List<OpenAPIProvider> includedProviders = new ArrayList<OpenAPIProvider>();
        private final Map<OpenAPIProvider, Set<String>> pathNames = new HashMap<OpenAPIProvider, Set<String>>();
        private final Map<OpenAPIProvider, Map<String, Object>> topLevelExtensions = new HashMap<OpenAPIProvider, Map<String, Object>>();
        private final NameProcessor nameProcessor = new NameProcessor();
        private final List<String> mergeProblems = new ArrayList<String>();
        static final long serialVersionUID = -6837482890035924955L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public MergeProcessorInstance(List<OpenAPIProvider> providers) {
            this.providers = Collections.unmodifiableList(providers);
        }

        public void process() {
            ArrayList<InProgressModel> inProgressModels = new ArrayList<InProgressModel>();
            for (OpenAPIProvider provider : this.providers) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Starting path processing for " + provider), (Object[])new Object[0]);
                }
                OpenAPI model = (OpenAPI)ModelCopy.copy(provider.getModel());
                NameProcessor.DocumentNameProcessor documentNameProcessor = this.nameProcessor.createDocumentNameProcessor();
                MergeProcessorImpl.prependPaths(model, provider.getApplicationPath(), documentNameProcessor);
                boolean pathClashes = this.findAndRecordPathClashes(model, provider);
                boolean extensionClashes = this.findAndRecordExtensionClashes(model, provider);
                if (pathClashes || extensionClashes) continue;
                inProgressModels.add(new InProgressModel(provider, model, documentNameProcessor));
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                Tr.event((Object)this, (TraceComponent)tc, (String)("No path clashes for " + provider + ", including in merge"), (Object[])new Object[0]);
            }
            boolean securityIdentical = MergeProcessorImpl.isSecurityIdentical(inProgressModels);
            boolean infoIdentical = MergeProcessorImpl.isInfoIdentical(inProgressModels);
            boolean externalDocsIdentical = MergeProcessorImpl.isExternalDocsIdentical(inProgressModels);
            boolean serversIdentical = MergeProcessorImpl.isServersIdentical(inProgressModels);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)("Security identical = " + securityIdentical), (Object[])new Object[0]);
                Tr.event((Object)this, (TraceComponent)tc, (String)("Info identical = " + infoIdentical), (Object[])new Object[0]);
                Tr.event((Object)this, (TraceComponent)tc, (String)("External docs identical = " + externalDocsIdentical), (Object[])new Object[0]);
                Tr.event((Object)this, (TraceComponent)tc, (String)("Servers identical = " + serversIdentical), (Object[])new Object[0]);
            }
            for (InProgressModel inProgress : inProgressModels) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Starting main processing for " + inProgress.provider), (Object[])new Object[0]);
                }
                this.renameClashingTags(inProgress.model, inProgress.documentNameProcessor);
                this.renameClashingComponents(inProgress.model, inProgress.documentNameProcessor);
                this.renameClashingOperationIds(inProgress.model, inProgress.documentNameProcessor);
                this.renameClashingWebhooks(inProgress.model, inProgress.documentNameProcessor);
                if (!securityIdentical) {
                    this.moveSecurityRequirements(inProgress.model);
                }
                if (!infoIdentical) {
                    inProgress.model.setInfo(MERGED_INFO);
                }
                if (!externalDocsIdentical) {
                    inProgress.model.setExternalDocs(null);
                }
                if (!serversIdentical) {
                    MergeProcessorImpl.moveServersUnderPaths(inProgress.model);
                }
                if (inProgress.documentNameProcessor.hasRenames()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Updating references to renamed elements", (Object[])new Object[0]);
                    }
                    RenameReferenceVisitor visitor = new RenameReferenceVisitor(inProgress.documentNameProcessor);
                    MergeProcessorImpl.this.modelWalker.walk(inProgress.model, visitor);
                }
                this.processedModels.add(inProgress.model);
                this.includedProviders.add(inProgress.provider);
            }
        }

        public OpenAPIProvider getMergedDocument() {
            if (this.includedProviders.size() == 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)"Only one document was able to be merged. Returning that document without changes.", (Object[])new Object[0]);
                }
                return new MergedOpenAPIProvider(this.includedProviders.get(0).getModel(), this.mergeProblems, this.includedProviders.get(0).getApplicationPath());
            }
            OpenAPI merged = OASFactory.createOpenAPI();
            for (OpenAPI model : this.processedModels) {
                merged = MergeUtil.merge((OpenAPI)merged, (OpenAPI)model);
            }
            merged.setOpenapi("3.0.3");
            return new MergedOpenAPIProvider(merged, this.mergeProblems);
        }

        private boolean findAndRecordPathClashes(OpenAPI model, OpenAPIProvider provider) {
            Paths paths = model.getPaths();
            if (paths == null) {
                return false;
            }
            Map pathItems = paths.getPathItems();
            if (pathItems == null || pathItems.isEmpty()) {
                return false;
            }
            boolean clashesFound = false;
            for (String path : pathItems.keySet()) {
                for (Map.Entry<OpenAPIProvider, Set<String>> entry : this.pathNames.entrySet()) {
                    OpenAPIProvider otherProvider = entry.getKey();
                    Set<String> pathNames = entry.getValue();
                    if (!pathNames.contains(path)) continue;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("Path " + path + " clashes with " + otherProvider), (Object[])new Object[0]);
                    }
                    this.mergeProblems.add(Tr.formatMessage((TraceComponent)tc, (String)"OPENAPI_MERGE_PROBLEM_PATH_CLASH", (Object[])new Object[]{path, provider, otherProvider}));
                    clashesFound = true;
                }
            }
            if (!clashesFound) {
                this.pathNames.put(provider, pathItems.keySet());
            }
            return clashesFound;
        }

        private boolean findAndRecordExtensionClashes(OpenAPI model, OpenAPIProvider provider) {
            Map extensions = model.getExtensions();
            if (extensions == null || extensions.isEmpty()) {
                return false;
            }
            boolean clashesFound = false;
            for (Map.Entry<OpenAPIProvider, Map<String, Object>> entry : this.topLevelExtensions.entrySet()) {
                OpenAPIProvider otherProvider = entry.getKey();
                Map<String, Object> otherExtensions = entry.getValue();
                for (Map.Entry extensionEntry : extensions.entrySet()) {
                    String key = (String)extensionEntry.getKey();
                    Object value = extensionEntry.getValue();
                    Object otherValue = otherExtensions.get(key);
                    if (otherValue == null || Objects.equals(value, otherValue)) continue;
                    this.mergeProblems.add(Tr.formatMessage((TraceComponent)tc, (String)"OPENAPI_MERGE_PROBLEM_EXTENSION_CLASH", (Object[])new Object[]{key, provider, otherProvider}));
                    clashesFound = true;
                }
            }
            if (!clashesFound) {
                this.topLevelExtensions.put(provider, extensions);
            }
            return clashesFound;
        }

        private void renameClashingTags(OpenAPI document, NameProcessor.DocumentNameProcessor documentNameProcessor) {
            for (Tag tag : OpenAPIUtils.notNull(document.getTags())) {
                tag.setName(documentNameProcessor.createUniqueName(NameType.TAG, tag.getName(), tag));
            }
        }

        protected void renameClashingComponents(OpenAPI document, NameProcessor.DocumentNameProcessor documentNameProcessor) {
            Components components = document.getComponents();
            if (components == null) {
                return;
            }
            components.setCallbacks(this.renameComponents(NameType.CALLBACKS, components.getCallbacks(), documentNameProcessor));
            components.setExamples(this.renameComponents(NameType.EXAMPLES, components.getExamples(), documentNameProcessor));
            components.setHeaders(this.renameComponents(NameType.HEADERS, components.getHeaders(), documentNameProcessor));
            components.setLinks(this.renameComponents(NameType.LINKS, components.getLinks(), documentNameProcessor));
            components.setParameters(this.renameComponents(NameType.PARAMETERS, components.getParameters(), documentNameProcessor));
            components.setRequestBodies(this.renameComponents(NameType.REQUEST_BODIES, components.getRequestBodies(), documentNameProcessor));
            components.setResponses(this.renameComponents(NameType.RESPONSES, components.getResponses(), documentNameProcessor));
            components.setSchemas(this.renameComponents(NameType.SCHEMAS, components.getSchemas(), documentNameProcessor));
            components.setSecuritySchemes(this.renameComponents(NameType.SECURITY_SCHEMES, components.getSecuritySchemes(), documentNameProcessor));
        }

        protected <T> Map<String, T> renameComponents(NameType nameType, Map<String, T> componentMap, NameProcessor.DocumentNameProcessor documentNameProcessor) {
            if (componentMap == null) {
                return null;
            }
            LinkedHashMap<String, T> newMap = new LinkedHashMap<String, T>();
            for (Map.Entry<String, T> entry : componentMap.entrySet()) {
                String key = entry.getKey();
                newMap.put(documentNameProcessor.createUniqueName(nameType, key, entry.getValue()), entry.getValue());
            }
            return newMap;
        }

        private void renameClashingOperationIds(OpenAPI document, NameProcessor.DocumentNameProcessor documentNameProcessor) {
            Paths paths = document.getPaths();
            if (paths == null) {
                return;
            }
            for (PathItem item : OpenAPIUtils.notNull(paths.getPathItems()).values()) {
                for (Operation op : OpenAPIUtils.notNull(item.getOperations()).values()) {
                    op.setOperationId(documentNameProcessor.createUniqueName(NameType.OPERATION_ID, op.getOperationId(), null));
                }
            }
        }

        protected void renameClashingWebhooks(OpenAPI document, NameProcessor.DocumentNameProcessor documentNameProcessor) {
        }

        private void moveSecurityRequirements(OpenAPI document) {
            Paths paths;
            List securityRequirements = document.getSecurity();
            if (securityRequirements == null) {
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Moving security requirements from the top level to under paths", (Object[])new Object[0]);
            }
            if ((paths = document.getPaths()) == null) {
                return;
            }
            for (PathItem item : OpenAPIUtils.notNull(paths.getPathItems()).values()) {
                for (Operation op : OpenAPIUtils.notNull(item.getOperations()).values()) {
                    if (op.getSecurity() != null) continue;
                    op.setSecurity(securityRequirements);
                }
            }
            document.setSecurity(null);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.merge.MergeProcessorImpl$MergeProcessorInstance", MergeProcessorInstance.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class InProgressModel {
        private final OpenAPIProvider provider;
        private final OpenAPI model;
        private final NameProcessor.DocumentNameProcessor documentNameProcessor;
        static final long serialVersionUID = 9096114687168450356L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private InProgressModel(OpenAPIProvider provider, OpenAPI model, NameProcessor.DocumentNameProcessor documentNameProcessor) {
            this.provider = provider;
            this.model = model;
            this.documentNameProcessor = documentNameProcessor;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.merge.MergeProcessorImpl$InProgressModel", InProgressModel.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }
}

